/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AuditChannelEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AuditOpenSecureChannelEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;

public class AuditOpenSecureChannelEventTypeNode
extends AuditChannelEventTypeNode
implements AuditOpenSecureChannelEventType {
    public AuditOpenSecureChannelEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public ByteString getClientCertificate() throws UaException {
        PropertyTypeNode node = this.getClientCertificateNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientCertificate(ByteString clientCertificate) throws UaException {
        PropertyTypeNode node = this.getClientCertificateNode();
        node.setValue(new Variant((Object)clientCertificate));
    }

    @Override
    public ByteString readClientCertificate() throws UaException {
        try {
            return this.readClientCertificateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientCertificate(ByteString clientCertificate) throws UaException {
        try {
            this.writeClientCertificateAsync(clientCertificate).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readClientCertificateAsync() {
        return ((CompletableFuture)this.getClientCertificateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientCertificateAsync(ByteString clientCertificate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientCertificate));
        return this.getClientCertificateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientCertificateNode() throws UaException {
        try {
            return this.getClientCertificateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientCertificateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientCertificate", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getClientCertificateThumbprint() throws UaException {
        PropertyTypeNode node = this.getClientCertificateThumbprintNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientCertificateThumbprint(String clientCertificateThumbprint) throws UaException {
        PropertyTypeNode node = this.getClientCertificateThumbprintNode();
        node.setValue(new Variant((Object)clientCertificateThumbprint));
    }

    @Override
    public String readClientCertificateThumbprint() throws UaException {
        try {
            return this.readClientCertificateThumbprintAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientCertificateThumbprint(String clientCertificateThumbprint) throws UaException {
        try {
            this.writeClientCertificateThumbprintAsync(clientCertificateThumbprint).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientCertificateThumbprintAsync() {
        return ((CompletableFuture)this.getClientCertificateThumbprintNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientCertificateThumbprintAsync(String clientCertificateThumbprint) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientCertificateThumbprint));
        return this.getClientCertificateThumbprintNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientCertificateThumbprintNode() throws UaException {
        try {
            return this.getClientCertificateThumbprintNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientCertificateThumbprintNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientCertificateThumbprint", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public SecurityTokenRequestType getRequestType() throws UaException {
        PropertyTypeNode node = this.getRequestTypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return SecurityTokenRequestType.from((int)((Integer)value));
        }
        if (value instanceof SecurityTokenRequestType) {
            return (SecurityTokenRequestType)value;
        }
        return null;
    }

    @Override
    public void setRequestType(SecurityTokenRequestType requestType) throws UaException {
        PropertyTypeNode node = this.getRequestTypeNode();
        node.setValue(new Variant((Object)requestType));
    }

    @Override
    public SecurityTokenRequestType readRequestType() throws UaException {
        try {
            return this.readRequestTypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRequestType(SecurityTokenRequestType requestType) throws UaException {
        try {
            this.writeRequestTypeAsync(requestType).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SecurityTokenRequestType> readRequestTypeAsync() {
        return ((CompletableFuture)this.getRequestTypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return SecurityTokenRequestType.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeRequestTypeAsync(SecurityTokenRequestType requestType) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)requestType));
        return this.getRequestTypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRequestTypeNode() throws UaException {
        try {
            return this.getRequestTypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRequestTypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RequestType", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSecurityPolicyUri() throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityPolicyUri(String securityPolicyUri) throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        node.setValue(new Variant((Object)securityPolicyUri));
    }

    @Override
    public String readSecurityPolicyUri() throws UaException {
        try {
            return this.readSecurityPolicyUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityPolicyUri(String securityPolicyUri) throws UaException {
        try {
            this.writeSecurityPolicyUriAsync(securityPolicyUri).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecurityPolicyUriAsync() {
        return ((CompletableFuture)this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityPolicyUriAsync(String securityPolicyUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityPolicyUri));
        return this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityPolicyUriNode() throws UaException {
        try {
            return this.getSecurityPolicyUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityPolicyUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityPolicyUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public MessageSecurityMode getSecurityMode() throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return MessageSecurityMode.from((int)((Integer)value));
        }
        if (value instanceof MessageSecurityMode) {
            return (MessageSecurityMode)value;
        }
        return null;
    }

    @Override
    public void setSecurityMode(MessageSecurityMode securityMode) throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        node.setValue(new Variant((Object)securityMode));
    }

    @Override
    public MessageSecurityMode readSecurityMode() throws UaException {
        try {
            return this.readSecurityModeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityMode(MessageSecurityMode securityMode) throws UaException {
        try {
            this.writeSecurityModeAsync(securityMode).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends MessageSecurityMode> readSecurityModeAsync() {
        return ((CompletableFuture)this.getSecurityModeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return MessageSecurityMode.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityModeAsync(MessageSecurityMode securityMode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityMode));
        return this.getSecurityModeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityModeNode() throws UaException {
        try {
            return this.getSecurityModeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityModeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityMode", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getRequestedLifetime() throws UaException {
        PropertyTypeNode node = this.getRequestedLifetimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setRequestedLifetime(Double requestedLifetime) throws UaException {
        PropertyTypeNode node = this.getRequestedLifetimeNode();
        node.setValue(new Variant((Object)requestedLifetime));
    }

    @Override
    public Double readRequestedLifetime() throws UaException {
        try {
            return this.readRequestedLifetimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRequestedLifetime(Double requestedLifetime) throws UaException {
        try {
            this.writeRequestedLifetimeAsync(requestedLifetime).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readRequestedLifetimeAsync() {
        return ((CompletableFuture)this.getRequestedLifetimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRequestedLifetimeAsync(Double requestedLifetime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)requestedLifetime));
        return this.getRequestedLifetimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRequestedLifetimeNode() throws UaException {
        try {
            return this.getRequestedLifetimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRequestedLifetimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RequestedLifetime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

