/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.structuredtextcore.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElseIfPart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElsePart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.AccessMode;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STCoreControlFlowValidator {
    private final ValidationMessageAcceptor acceptor;
    private Map<STVarDeclaration, VariableState> variables = new HashMap<STVarDeclaration, VariableState>();

    public STCoreControlFlowValidator(ValidationMessageAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void validateVariableBlocks(List<? extends STVarDeclarationBlock> blocks) {
        blocks.forEach(this::validateVariableBlock);
    }

    public void validateVariableBlock(STVarDeclarationBlock block) {
        this.validateVariables((List<? extends STVarDeclaration>)block.getVarDeclarations());
    }

    public void validateVariables(List<? extends STVarDeclaration> declarations) {
        declarations.forEach(this::validateVariable);
    }

    public void validateVariable(STVarDeclaration declaration) {
        this.validateFeatureReferences((EObject)declaration);
        this.variables.put(declaration, VariableState.DEFINED);
    }

    public void validateStatements(List<? extends STStatement> statements) {
        statements.forEach(this::validateStatement);
    }

    protected Map<STVarDeclaration, VariableState> validateSubStatements(List<? extends STStatement> statements) {
        Map<STVarDeclaration, VariableState> originalVariables = this.variables;
        this.variables = new HashMap<STVarDeclaration, VariableState>(this.variables);
        statements.forEach(this::validateStatement);
        Map<STVarDeclaration, VariableState> subVariables = this.variables;
        this.variables = originalVariables;
        return subVariables;
    }

    public void validateStatement(STStatement statement) {
        if (statement instanceof STAssignment) {
            STAssignment assignment = (STAssignment)statement;
            this.validateStatement(assignment);
        } else if (statement instanceof STIfStatement) {
            STIfStatement ifStatement = (STIfStatement)statement;
            this.validateStatement(ifStatement);
        } else if (statement instanceof STCaseStatement) {
            STCaseStatement caseStatement = (STCaseStatement)statement;
            this.validateStatement(caseStatement);
        } else if (statement instanceof STForStatement) {
            STForStatement forStatement = (STForStatement)statement;
            this.validateStatement(forStatement);
        } else if (statement instanceof STWhileStatement) {
            STWhileStatement whileStatement = (STWhileStatement)statement;
            this.validateStatement(whileStatement);
        } else if (statement instanceof STRepeatStatement) {
            STRepeatStatement repeatStatement = (STRepeatStatement)statement;
            this.validateStatement(repeatStatement);
        } else {
            this.validateFeatureReferences((EObject)statement);
        }
    }

    protected void validateStatement(STAssignment assignment) {
        this.validateFeatureReferences((EObject)assignment.getRight());
        this.validateFeatureReferences((EObject)assignment.getLeft());
    }

    protected void validateStatement(STIfStatement statement) {
        this.validateFeatureReferences((EObject)statement.getCondition());
        this.variables = Stream.concat(Stream.of(this.validateSubStatements((List<? extends STStatement>)statement.getStatements()), this.validateElsePart(statement.getElse())), statement.getElseifs().stream().map(this::validateElseIfPart)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, VariableState::intersect));
    }

    protected Map<STVarDeclaration, VariableState> validateElseIfPart(STElseIfPart statement) {
        this.validateFeatureReferences((EObject)statement.getCondition());
        return this.validateSubStatements((List<? extends STStatement>)statement.getStatements());
    }

    protected Map<STVarDeclaration, VariableState> validateElsePart(STElsePart statement) {
        if (statement != null) {
            return this.validateSubStatements((List<? extends STStatement>)statement.getStatements());
        }
        return this.variables;
    }

    protected void validateStatement(STCaseStatement statement) {
        this.validateFeatureReferences((EObject)statement.getSelector());
        this.variables = Stream.concat(Stream.of(this.validateElsePart(statement.getElse())), statement.getCases().stream().map(this::validateCasePart)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, VariableState::intersect));
    }

    protected Map<STVarDeclaration, VariableState> validateCasePart(STCaseCases statement) {
        statement.getConditions().forEach(this::validateFeatureReferences);
        return this.validateSubStatements((List<? extends STStatement>)statement.getStatements());
    }

    protected void validateStatement(STForStatement statement) {
        this.validateFeatureReferences((EObject)statement.getVariable());
        this.validateFeatureReferences((EObject)statement.getFrom());
        this.validateFeatureReferences((EObject)statement.getTo());
        this.validateFeatureReferences((EObject)statement.getBy());
        this.validateSubStatements((List<? extends STStatement>)statement.getStatements()).forEach((key, value) -> {
            VariableState variableState = this.variables.merge((STVarDeclaration)key, (VariableState)((Object)value), VariableState::intersect);
        });
        STCoreUtil.getFeaturePath((STExpression)statement.getVariable()).stream().findFirst().filter(STVarDeclaration.class::isInstance).ifPresent(controlVariable -> {
            VariableState variableState = this.variables.put((STVarDeclaration)controlVariable, VariableState.UNDEFINED_AFTER_FOR);
        });
    }

    protected void validateStatement(STWhileStatement statement) {
        this.validateFeatureReferences((EObject)statement.getCondition());
        this.validateSubStatements((List<? extends STStatement>)statement.getStatements()).forEach((key, value) -> {
            VariableState variableState = this.variables.merge((STVarDeclaration)key, (VariableState)((Object)value), VariableState::intersect);
        });
        this.validateFeatureReferences((EObject)statement.getCondition());
    }

    protected void validateStatement(STRepeatStatement statement) {
        this.validateSubStatements((List<? extends STStatement>)statement.getStatements()).forEach((key, value) -> {
            VariableState variableState = this.variables.merge((STVarDeclaration)key, (VariableState)((Object)value), VariableState::intersect);
        });
        this.validateFeatureReferences((EObject)statement.getCondition());
    }

    protected void validateFeatureReferences(EObject container) {
        if (container != null) {
            EcoreUtil2.eAllOfType((EObject)container, STFeatureExpression.class).forEach(this::validateFeatureReference);
        }
    }

    protected void validateFeatureReference(STFeatureExpression expression) {
        this.validateAccess(expression.getFeature(), STCoreUtil.getAccessMode((STExpression)expression), (EObject)expression);
    }

    protected void validateAccess(INamedElement feature, AccessMode mode, EObject context) {
        switch (mode) {
            case READ: {
                this.validateReadAccess(feature, context);
                break;
            }
            case WRITE: {
                this.validateWriteAccess(feature, context);
                break;
            }
            case READ_WRITE: {
                this.validateReadAccess(feature, context);
                this.validateWriteAccess(feature, context);
                break;
            }
        }
    }

    protected void validateReadAccess(INamedElement feature, EObject context) {
        if (this.variables.get(feature) == VariableState.UNDEFINED_AFTER_FOR) {
            this.acceptor.acceptWarning(MessageFormat.format(Messages.STCoreControlFlowValidator_VariableUndefinedAfterForLoop, feature.getName()), context, null, -1, "org.eclipse.fordiac.ide.structuredtextcore.forControlVariableUndefined", new String[0]);
        }
    }

    protected void validateWriteAccess(INamedElement feature, EObject context) {
        if (feature instanceof STVarDeclaration) {
            STVarDeclaration stVarDeclaration = (STVarDeclaration)feature;
            this.variables.put(stVarDeclaration, VariableState.DEFINED);
        }
    }

    public static enum VariableState {
        DEFINED,
        UNDEFINED_AFTER_FOR;


        public VariableState intersect(VariableState other) {
            return VariableState.values()[this.ordinal() | other.ordinal()];
        }
    }
}

