/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ConnectionHelper;
import org.eclipse.fordiac.ide.model.dataimport.MappingTargetCreator;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationChannel;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationMappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.resource.TypeImportDiagnostic;
import org.eclipse.fordiac.ide.model.systemconfiguration.CommunicationConfigurationDetails;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.CommandStack;

public class SystemImporter
extends CommonElementImporter {
    private final Map<Resource, Map<String, FBNetworkElement>> resFBNElementMapping = new HashMap<Resource, Map<String, FBNetworkElement>>();
    private final List<FBNetworkElement> mappedFBs = new ArrayList<FBNetworkElement>();
    private final List<ConnectionHelper.ConnectionBuilder<Connection>> brokenConnections = new ArrayList<ConnectionHelper.ConnectionBuilder<Connection>>();

    public SystemImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    public SystemImporter(IFile systemfile) {
        super(systemfile);
    }

    @Override
    public AutomationSystem getElement() {
        return (AutomationSystem)super.getElement();
    }

    @Override
    public void loadElement() throws IOException, XMLStreamException, TypeImportException {
        long start = System.nanoTime();
        super.loadElement();
        this.finalizeMappingModel();
        long elapsed = System.nanoTime() - start;
        FordiacLogHelper.logInfo((String)("System \"" + this.getElement().getName() + "\" load time: " + elapsed / 1000000L + "ms"));
    }

    @Override
    protected LibraryElement createRootModelElement() {
        return SystemImporter.createAutomationSystem();
    }

    public static AutomationSystem createAutomationSystem() {
        AutomationSystem system = LibraryElementFactory.eINSTANCE.createAutomationSystem();
        system.setCommandStack(new CommandStack());
        SystemConfiguration sysConf = LibraryElementFactory.eINSTANCE.createSystemConfiguration();
        system.setSystemConfiguration(sysConf);
        return system;
    }

    @Override
    protected String getStartElementName() {
        return "System";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        SystemConfiguration sysConf = this.getElement().getSystemConfiguration();
        return name -> {
            switch (name) {
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "Application": {
                    this.parseApplication(this.getElement());
                    break;
                }
                case "Device": {
                    sysConf.getDevices().add((Object)this.parseDevice());
                    break;
                }
                case "Mapping": {
                    this.parseMapping();
                    break;
                }
                case "Segment": {
                    sysConf.getSegments().add((Object)this.parseSegment());
                    break;
                }
                case "Link": {
                    this.parseLink(sysConf);
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(this.getElement());
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    private Segment parseSegment() throws TypeImportException, XMLStreamException {
        String type;
        Segment segment = LibraryElementFactory.eINSTANCE.createSegment();
        this.readNameCommentAttributes(segment);
        this.getXandY(segment);
        String dx1 = this.getAttributeValue("dx1");
        if (dx1 != null) {
            segment.setWidth(Double.parseDouble(dx1));
        }
        if ((type = this.getAttributeValue("Type")) != null) {
            segment.setTypeEntry(this.addDependency(this.getTypeLibrary().getSegmentTypeEntry(type)));
            SystemImporter.parseCommunication(segment);
        }
        this.parseSegmentNodeChildren(segment);
        return segment;
    }

    private void parseSegmentNodeChildren(Segment segment) throws XMLStreamException, TypeImportException {
        this.processChildren("Segment", name -> {
            if ("Attribute".equals(name)) {
                if (this.isColorAttributeNode()) {
                    this.parseColor(segment);
                } else {
                    this.parseGenericAttributeNode(segment);
                }
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            if ("Parameter".equals(name)) {
                segment.getVarDeclarations().add((Object)this.parseParameter());
                this.proceedToEndElementNamed("Parameter");
                return true;
            }
            return false;
        });
    }

    private static void parseCommunication(Segment segment) {
        CommunicationConfigurationDetails commConfig;
        String typeName = segment.getFullTypeName();
        if (typeName != null && (commConfig = CommunicationConfigurationDetails.getCommConfigUiFromExtensionPoint(typeName, "id")) != null) {
            CommunicationConfiguration config = commConfig.createModel((List<VarDeclaration>)segment.getVarDeclarations());
            segment.setCommunication(config);
        }
    }

    private void parseLink(SystemConfiguration sysConf) throws XMLStreamException, TypeImportException {
        String commResource = this.getAttributeValue("CommResource");
        String comment = this.getAttributeValue("Comment");
        String segmentName = this.getAttributeValue("SegmentName");
        Segment segment = sysConf.getSegmentNamed(segmentName);
        Device device = sysConf.getDeviceNamed(commResource);
        if (segment != null && device != null) {
            Link link = LibraryElementFactory.eINSTANCE.createLink();
            link.setComment(comment);
            segment.getOutConnections().add((Object)link);
            device.getInConnections().add((Object)link);
            this.processChildren("Link", name -> {
                if ("Attribute".equals(name)) {
                    this.parseGenericAttributeNode(link);
                    this.proceedToEndElementNamed("Attribute");
                    return true;
                }
                return false;
            });
            sysConf.getLinks().add((Object)link);
        }
        this.proceedToEndElementNamed("Link");
    }

    private Device parseDevice() throws TypeImportException, XMLStreamException {
        Device device = LibraryElementFactory.eINSTANCE.createDevice();
        this.readNameCommentAttributes(device);
        this.getXandY(device);
        this.parseDeviceType(device);
        this.parseDeviceNodeChildren(device);
        return device;
    }

    private void parseDeviceType(Device device) {
        DeviceTypeEntry entry;
        String typeName = this.getAttributeValue("Type");
        if (typeName != null && (entry = this.addDependency(this.getTypeLibrary().getDeviceTypeEntry(typeName))) != null) {
            device.setTypeEntry(entry);
            SystemImporter.createParameters(device);
        }
    }

    private void parseMapping() throws XMLStreamException {
        FBNetworkElement toElement;
        String fromValue = this.getAttributeValue("From");
        String toValue = this.getAttributeValue("To");
        FBNetworkElement fromElement = this.findMappingTargetFromName(fromValue);
        FBNetworkElement fBNetworkElement = toElement = fromElement instanceof CommunicationChannel ? this.findMappingTargetFromName(toValue, fromElement) : this.findMappingToElement(fromValue, toValue, fromElement);
        if (fromElement != null && toElement != null) {
            this.getElement().getMapping().add((Object)SystemImporter.createMappingEntry(toElement, fromElement));
        }
        this.proceedToEndElementNamed("Mapping");
    }

    private FBNetworkElement findMappingToElement(String fromValue, String toValue, FBNetworkElement fromElement) {
        int devResSeperator = toValue.indexOf(46);
        if (devResSeperator == -1) {
            this.getErrors().add(new TypeImportDiagnostic("Wrong to mapping string", fromValue + "->" + toValue, this.getLineNumber()));
            return null;
        }
        Device dev = this.getElement().getDeviceNamed(toValue.substring(0, devResSeperator));
        if (dev == null) {
            this.getErrors().add(new TypeImportDiagnostic("Device missing in mapping", fromValue + "->" + toValue, this.getLineNumber()));
            return null;
        }
        int resFBSeperator = toValue.indexOf(46, devResSeperator + 1);
        String resName = resFBSeperator == -1 ? toValue.substring(devResSeperator + 1) : toValue.substring(devResSeperator + 1, resFBSeperator);
        Resource res = dev.getResourceNamed(resName);
        if (res == null) {
            this.getErrors().add(new TypeImportDiagnostic("Resource missing in mapping", fromValue + "->" + toValue, this.getLineNumber()));
            return null;
        }
        String targetFBName = resFBSeperator == -1 ? fromValue : toValue.substring(resFBSeperator + 1);
        Map<String, FBNetworkElement> fbNetworkElementMap = this.resFBNElementMapping.get(res);
        if (fbNetworkElementMap == null) {
            return null;
        }
        FBNetworkElement fbNetworkElement = fbNetworkElementMap.get(targetFBName);
        if (fbNetworkElement == null && fromElement != null) {
            FBNetworkElement mappingTarget = MappingTargetCreator.createMappingTarget(res, fromElement, targetFBName);
            if (mappingTarget != null) {
                this.mappedFBs.add(fromElement);
                fbNetworkElementMap.put(targetFBName, mappingTarget);
            }
            return mappingTarget;
        }
        return fbNetworkElement;
    }

    private static Mapping createMappingEntry(FBNetworkElement toElement, FBNetworkElement fromElement) {
        Mapping mapping = LibraryElementFactory.eINSTANCE.createMapping();
        mapping.setFrom(fromElement);
        mapping.setTo(toElement);
        toElement.setMapping(mapping);
        fromElement.setMapping(mapping);
        return mapping;
    }

    private FBNetworkElement findMappingTargetFromName(String targetName, FBNetworkElement copyCommunication) {
        Segment segment;
        ArrayDeque<String> parts;
        if (targetName != null && (parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")))).size() >= 2 && (segment = this.getElement().getSystemConfiguration().getSegmentNamed((String)parts.getFirst())) != null) {
            CommunicationMappingTarget channel;
            parts.pollFirst();
            String windowName = (String)parts.pollFirst();
            Optional<CommunicationMappingTarget> findWindow = segment.getCommunication().getMappingTargets().stream().filter(c -> c.getName().equals(windowName)).findFirst();
            CommunicationMappingTarget communicationMappingTarget = channel = findWindow.isPresent() ? findWindow.get() : null;
            if (channel != null) {
                CommunicationChannel comm = LibraryElementFactory.eINSTANCE.createCommunicationChannel();
                comm.setName(copyCommunication.getName());
                comm.setPosition((Position)EcoreUtil.copy((EObject)copyCommunication.getPosition()));
                comm.setTypeEntry(copyCommunication.getTypeEntry());
                comm.setInterface(copyCommunication.getType().getInterfaceList().copy());
                channel.getMappedElements().add((Object)comm);
                return comm;
            }
        }
        return null;
    }

    private FBNetworkElement findMappingTargetFromName(String targetName) {
        Application application;
        ArrayDeque<String> parts;
        if (targetName != null && (parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")))).size() >= 2 && (application = this.getElement().getApplicationNamed((String)parts.getFirst())) != null) {
            parts.pollFirst();
            return SystemImporter.findMappingTargetInFBNetwork(application.getFBNetwork(), parts);
        }
        return null;
    }

    private static FBNetworkElement findMappingTargetInFBNetwork(FBNetwork nw, Deque<String> parts) {
        FBNetworkElement element;
        if (nw != null && (element = nw.getElementNamed(parts.pollFirst())) != null) {
            if (parts.isEmpty()) {
                return element;
            }
            if (element instanceof SubApp) {
                SubApp subApp = (SubApp)element;
                SystemImporter.findMappingTargetInFBNetwork(subApp.getSubAppNetwork(), parts);
            }
        }
        return null;
    }

    private void parseDeviceNodeChildren(Device device) throws TypeImportException, XMLStreamException {
        this.processChildren("Device", name -> {
            switch (name) {
                case "Attribute": {
                    this.parseDeviceAttribute(device);
                    break;
                }
                case "Parameter": {
                    VarDeclaration parameter = this.parseParameter();
                    if (parameter == null) break;
                    VarDeclaration devParam = SystemImporter.getParamter((EList<VarDeclaration>)device.getVarDeclarations(), parameter.getName());
                    if (devParam != null) {
                        devParam.getAttributes().addAll((Collection)parameter.getAttributes());
                        devParam.setValue(parameter.getValue());
                        break;
                    }
                    parameter.setIsInput(true);
                    device.getVarDeclarations().add((Object)parameter);
                    break;
                }
                case "Resource": {
                    HashMap<String, FBNetworkElement> fbNetworkElementMap = new HashMap<String, FBNetworkElement>();
                    Resource resource = this.parseResource(fbNetworkElementMap);
                    device.getResource().add((Object)resource);
                    this.resFBNElementMapping.put(resource, fbNetworkElementMap);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }

    private void parseDeviceAttribute(Device device) throws XMLStreamException, TypeImportException {
        if (this.isColorAttributeNode()) {
            this.parseColor(device);
        } else if (this.isProfileAttribute()) {
            this.parseProfile(device);
        } else {
            this.parseGenericAttributeNode(device);
        }
        this.proceedToEndElementNamed("Attribute");
    }

    @Override
    protected void parseResourceNetwork(Map<String, FBNetworkElement> fbNetworkElementMap, Resource resource, FBNetwork fbNetwork) throws TypeImportException, XMLStreamException {
        ResDevFBNetworkImporter resNetworkImporter = new ResDevFBNetworkImporter(this, fbNetwork, (EList<VarDeclaration>)resource.getVarDeclarations(), fbNetworkElementMap);
        resNetworkImporter.parseFBNetwork("FBNetwork");
        this.brokenConnections.addAll(resNetworkImporter.getBrokenConnections());
    }

    private boolean isColorAttributeNode() {
        String name = this.getAttributeValue("Name");
        return "Color".equals(name);
    }

    private void parseColor(ColorizableElement colElement) {
        Color color = LibraryElementFactory.eINSTANCE.createColor();
        String value = this.getAttributeValue("Value");
        if (value != null) {
            String[] colors = value.split(",");
            color.setRed(Integer.parseInt(colors[0]));
            color.setGreen(Integer.parseInt(colors[1]));
            color.setBlue(Integer.parseInt(colors[2]));
            colElement.setColor(color);
        }
    }

    private void parseApplication(AutomationSystem automationSystem) throws TypeImportException, XMLStreamException {
        Application application = LibraryElementFactory.eINSTANCE.createApplication();
        automationSystem.getApplication().add((Object)application);
        this.readNameCommentAttributes(application);
        this.processChildren("Application", name -> {
            switch (name) {
                case "Attribute": {
                    this.parseGenericAttributeNode(application);
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                case "SubAppNetwork": {
                    SubAppNetworkImporter supAppImporter = new SubAppNetworkImporter(this);
                    application.setFBNetwork(supAppImporter.getFbNetwork());
                    supAppImporter.parseFBNetwork("SubAppNetwork");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }

    private void finalizeMappingModel() {
        this.generateMappedFBConnections();
        this.repairBrokenConnections();
    }

    private void generateMappedFBConnections() {
        for (FBNetworkElement fbnEl : this.mappedFBs) {
            FBNetworkElement srcResFb = fbnEl.getOpposite();
            Resource res = fbnEl.getResource();
            fbnEl.getInterface().getOutputs().flatMap(ie -> ie.getOutputConnections().stream()).filter(con -> con.getDestinationElement().getResource() == res).forEach(con -> res.getFBNetwork().addConnection(SystemImporter.createResourceCon(srcResFb, con)));
        }
    }

    private void repairBrokenConnections() {
        this.brokenConnections.forEach(ConnectionHelper.ConnectionBuilder::repair);
    }

    private static Connection createResourceCon(FBNetworkElement srcResFB, Connection con) {
        FBNetworkElement dstResFB = con.getDestinationElement().getOpposite();
        Connection resCon = (Connection)EcoreUtil.copy((EObject)con);
        resCon.setSource(srcResFB.getOutput(con.getSource().getName()));
        resCon.setDestination(dstResFB.getInput(con.getDestination().getName()));
        return resCon;
    }
}

