/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.helpers.BlockInstanceFactory;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;

public final class MappingTargetCreator {
    private MappingTargetCreator() {
        throw new UnsupportedOperationException("Utility class shall not be instantated!");
    }

    public static FBNetworkElement createMappingTarget(Resource res, FBNetworkElement srcElement, String targetFBName) {
        FBNetworkElement created = MappingTargetCreator.createFBNetworkElement(srcElement);
        if (created != null) {
            if (srcElement.getTypeEntry() != null) {
                created.setTypeEntry(srcElement.getTypeEntry());
            }
            created.setInterface(InterfaceListCopier.copy(srcElement.getInterface(), true, true));
            created.setPosition((Position)EcoreUtil.copy((EObject)srcElement.getPosition()));
            if (srcElement instanceof ConfigurableFB) {
                ConfigurableFB srcConfFB = (ConfigurableFB)srcElement;
                ((ConfigurableFB)created).setDataType(srcConfFB.getDataType());
            }
            created.setName(MappingTargetCreator.extractTargetFBName(targetFBName));
            res.getFBNetwork().getNetworkElements().add((Object)created);
        }
        return created;
    }

    private static FBNetworkElement createFBNetworkElement(FBNetworkElement srcElement) {
        FBNetworkElement fBNetworkElement = srcElement;
        Objects.requireNonNull(fBNetworkElement);
        FBNetworkElement fBNetworkElement2 = fBNetworkElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FB.class, TypedSubApp.class, UntypedSubApp.class}, (Object)fBNetworkElement2, n)) {
            case 0 -> {
                FB fb = (FB)fBNetworkElement2;
                yield BlockInstanceFactory.createFBInstanceForTypeEntry((FBTypeEntry)fb.getTypeEntry());
            }
            case 1 -> {
                TypedSubApp typedSubapp = (TypedSubApp)fBNetworkElement2;
                yield LibraryElementFactory.eINSTANCE.createTypedSubApp();
            }
            case 2 -> {
                UntypedSubApp untypedSubapp = (UntypedSubApp)fBNetworkElement2;
                yield LibraryElementFactory.eINSTANCE.createUntypedSubApp();
            }
            default -> null;
        };
    }

    private static String extractTargetFBName(String targetFBName) {
        int separator = targetFBName.lastIndexOf(46);
        if (separator != -1) {
            return targetFBName.substring(separator + 1);
        }
        return targetFBName;
    }
}

