/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;

public class StructDataConnectionCreateCommand
extends DataConnectionCreateCommand {
    private ChangeStructCommand changeStructCommand;

    public StructDataConnectionCreateCommand(FBNetwork parent) {
        super(parent);
    }

    @Override
    protected boolean canExecuteConType() {
        IInterfaceElement source = this.getSource();
        IInterfaceElement target = this.getDestination();
        if (StructDataConnectionCreateCommand.isStructPin(source) && StructDataConnectionCreateCommand.isStructPin(target)) {
            return LinkConstraints.canExistDataConnection((IInterfaceElement)this.getSource(), (IInterfaceElement)this.getDestination(), (FBNetwork)this.getParent(), null);
        }
        return false;
    }

    public boolean canRedo() {
        return true;
    }

    @Override
    public void execute() {
        IInterfaceElement source = this.getSource();
        IInterfaceElement target = this.getDestination();
        DataType dataType = source.getType();
        if (dataType instanceof StructuredType) {
            StructuredType sourceVar = (StructuredType)dataType;
            DataType dataType2 = target.getType();
            if (dataType2 instanceof StructuredType) {
                StructuredType targetVar = (StructuredType)dataType2;
                if (!sourceVar.getName().equals(targetVar.getName())) {
                    if (StructDataConnectionCreateCommand.isUnconfiguredStructManipulatorDefPin(source)) {
                        this.changeStructCommand = new ChangeStructCommand((StructManipulator)source.getFBNetworkElement(), (DataType)targetVar);
                        this.changeStructCommand.execute();
                        this.setSource(this.changeStructCommand.getNewMux().getInterfaceElement(this.getSource().getName()));
                    } else if (StructDataConnectionCreateCommand.isUnconfiguredStructManipulatorDefPin(target)) {
                        this.changeStructCommand = new ChangeStructCommand((StructManipulator)target.getFBNetworkElement(), (DataType)sourceVar);
                        this.changeStructCommand.execute();
                        this.setDestination(this.changeStructCommand.getNewMux().getInterfaceElement(this.getDestination().getName()));
                    }
                }
            }
        }
        super.execute();
    }

    @Override
    public void undo() {
        super.undo();
        if (this.changeStructCommand != null) {
            this.changeStructCommand.undo();
        }
    }

    @Override
    public void redo() {
        if (this.changeStructCommand != null) {
            this.changeStructCommand.redo();
        }
        super.redo();
    }

    private static boolean isStructPin(IInterfaceElement pin) {
        VarDeclaration varDecl;
        return pin instanceof VarDeclaration && !(varDecl = (VarDeclaration)pin).isArray() && varDecl.getType() instanceof StructuredType;
    }

    private static boolean isUnconfiguredStructManipulatorDefPin(IInterfaceElement pin) {
        return AbstractConnectionCreateCommand.isStructManipulatorDefPin(pin) && IecTypes.GenericTypes.ANY_STRUCT == pin.getType();
    }
}

