/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterFBCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public class CreateInterfaceElementCommand
extends CreationCommand
implements ScopedCommand {
    private IInterfaceElement newInterfaceElement;
    private final String name;
    private final DataType dataType;
    private final boolean isInput;
    private final boolean isInOut;
    private boolean switchOpposite;
    private final int index;
    private final String arraySize;
    private final String value;
    private AdapterFBCreateCommand adapterCreateCmd;
    private final InterfaceList targetInterfaceList;

    public CreateInterfaceElementCommand(IInterfaceElement copySrc, boolean isInput, InterfaceList targetInterfaceList, int index) {
        this(copySrc.getType(), copySrc.getName(), targetInterfaceList, isInput, index);
        this.newInterfaceElement = (IInterfaceElement)EcoreUtil.copy((EObject)copySrc);
    }

    public CreateInterfaceElementCommand(DataType dataType, String name, InterfaceList interfaceList, boolean isInput, boolean isInOut, String arraySize, int index) {
        this.isInput = isInput;
        this.isInOut = isInOut;
        this.switchOpposite = false;
        this.dataType = dataType;
        this.index = index;
        this.targetInterfaceList = interfaceList;
        this.name = name != null && CreateInterfaceElementCommand.isValidName(name) ? name : CreateInterfaceElementCommand.getNameProposal(dataType, isInput);
        this.arraySize = arraySize;
        this.value = "";
    }

    public CreateInterfaceElementCommand(DataType dataType, String name, InterfaceList interfaceList, boolean isInput, String arraySize, int index) {
        this(dataType, name, interfaceList, isInput, false, arraySize, index);
    }

    public CreateInterfaceElementCommand(DataType dataType, String name, InterfaceList interfaceList, boolean isInput, int index) {
        this(dataType, name, interfaceList, isInput, null, index);
    }

    public CreateInterfaceElementCommand(DataType dataType, InterfaceList interfaceList, boolean isInput, int index) {
        this(dataType, CreateInterfaceElementCommand.getNameProposal(dataType, isInput), interfaceList, isInput, index);
    }

    private static boolean isValidName(String name) {
        return !IdentifierVerifier.verifyIdentifier((String)name).isPresent();
    }

    private static String getNameProposal(DataType dataType, boolean isInput) {
        if (dataType instanceof EventType) {
            return isInput ? "EI1" : "EO1";
        }
        if (dataType instanceof AdapterType) {
            return isInput ? "SOCKET1" : "PLUG1";
        }
        return isInput ? "DI1" : "DO1";
    }

    protected InterfaceList getInterfaceList() {
        return this.targetInterfaceList;
    }

    public boolean canExecute() {
        return (this.isValidCopySource() || this.canCreateValidNewElement()) && this.targetInterfaceList != null;
    }

    private boolean canCreateValidNewElement() {
        return this.dataType != null;
    }

    private boolean isValidCopySource() {
        return this.newInterfaceElement != null && this.newInterfaceElement.getType() != null;
    }

    protected EList<? extends IInterfaceElement> getInterfaceListContainer() {
        if (this.dataType instanceof EventType) {
            return this.isInput ? this.targetInterfaceList.getEventInputs() : this.targetInterfaceList.getEventOutputs();
        }
        if (this.dataType instanceof AdapterType) {
            return this.isInput ? this.targetInterfaceList.getSockets() : this.targetInterfaceList.getPlugs();
        }
        return this.isInOut ? (this.switchOpposite ? this.targetInterfaceList.getOutMappedInOutVars() : this.targetInterfaceList.getInOutVars()) : (this.isInput ? this.targetInterfaceList.getInputVars() : this.targetInterfaceList.getOutputVars());
    }

    public void execute() {
        if (this.newInterfaceElement == null) {
            this.createNewInterfaceElement();
        } else {
            this.finalizeCopyInterfaceElement();
        }
        this.createValue();
        this.createAdapterFBCreateCommand();
        this.insertElement();
        this.newInterfaceElement.setName(NameRepository.createUniqueName((INamedElement)this.newInterfaceElement, (String)this.name));
        if (!this.isInput && this.isInOut) {
            this.switchOpposite = true;
            this.newInterfaceElement = ((VarDeclaration)this.newInterfaceElement).getInOutVarOpposite();
        }
        if (this.adapterCreateCmd != null) {
            this.adapterCreateCmd.execute();
        }
    }

    private void createValue() {
        IInterfaceElement iInterfaceElement = this.newInterfaceElement;
        if (iInterfaceElement instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)iInterfaceElement;
            if (this.isInput || this.isInOut) {
                varDecl.setValue(LibraryElementFactory.eINSTANCE.createValue());
                varDecl.getValue().setValue(this.value);
            }
        }
    }

    private void finalizeCopyInterfaceElement() {
        this.newInterfaceElement.setIsInput(this.isInput);
    }

    private void createNewInterfaceElement() {
        if (this.dataType instanceof EventType) {
            this.newInterfaceElement = LibraryElementFactory.eINSTANCE.createEvent();
        } else if (this.dataType instanceof AdapterType) {
            this.newInterfaceElement = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        } else {
            VarDeclaration varDeclaration = LibraryElementFactory.eINSTANCE.createVarDeclaration();
            ArraySizeHelper.setArraySize((VarDeclaration)varDeclaration, (String)this.arraySize);
            this.newInterfaceElement = varDeclaration;
        }
        this.newInterfaceElement.setIsInput(this.isInput || this.isInOut);
        this.newInterfaceElement.setType(this.dataType);
    }

    public void redo() {
        this.insertElement();
        if (!this.isInput && this.isInOut) {
            this.switchOpposite = true;
            this.newInterfaceElement = ((VarDeclaration)this.newInterfaceElement).getInOutVarOpposite();
        }
        if (this.adapterCreateCmd != null) {
            this.adapterCreateCmd.redo();
        }
    }

    public void undo() {
        if (this.switchOpposite) {
            this.switchOpposite = false;
            this.newInterfaceElement = ((VarDeclaration)this.newInterfaceElement).getInOutVarOpposite();
        }
        this.getInterfaceListContainer().remove((Object)this.newInterfaceElement);
        if (this.adapterCreateCmd != null && this.adapterCreateCmd.canExecute()) {
            this.adapterCreateCmd.undo();
        }
    }

    private void insertElement() {
        int insertionPos;
        EList<? extends IInterfaceElement> temp = this.getInterfaceListContainer();
        int n = insertionPos = this.index == -1 ? temp.size() : this.index;
        if (insertionPos > temp.size()) {
            temp.add((Object)this.newInterfaceElement);
        } else {
            temp.add(insertionPos, (Object)this.newInterfaceElement);
        }
    }

    private void createAdapterFBCreateCommand() {
        if (this.dataType instanceof AdapterType) {
            FBType fbType;
            int xyPos = 10;
            EObject eObject = this.targetInterfaceList.eContainer();
            this.adapterCreateCmd = new AdapterFBCreateCommand(10, 10, (AdapterDeclaration)this.newInterfaceElement, eObject instanceof FBType ? (fbType = (FBType)eObject) : null);
        }
    }

    public IInterfaceElement getCreatedElement() {
        return this.newInterfaceElement;
    }

    protected int getIndex() {
        return this.index;
    }

    public InterfaceList getTargetInterfaceList() {
        return this.targetInterfaceList;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.targetInterfaceList != null) {
            if (this.targetInterfaceList.eContainer() != null) {
                return Set.of(this.targetInterfaceList.eContainer());
            }
            return Set.of(this.targetInterfaceList);
        }
        return Set.of();
    }
}

