/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.editor;

import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.fordiac.ide.gef.dialogs.VariableDialog;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class EvaluatorVariableValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable variable, Shell shell) {
        if (variable instanceof EvaluatorDebugVariable) {
            EvaluatorDebugVariable evaluatorDebugVariable = (EvaluatorDebugVariable)variable;
            if (EvaluatorVariableValueEditor.isStructuredVariable(evaluatorDebugVariable)) {
                EvaluatorVariableValueEditor.openVariableDialog(evaluatorDebugVariable, shell);
            } else {
                EvaluatorVariableValueEditor.openInputDialog(evaluatorDebugVariable, shell);
            }
            return true;
        }
        return false;
    }

    protected static void openVariableDialog(EvaluatorDebugVariable variable, Shell shell) {
        Optional value = VariableDialog.open((Shell)shell, (String)Messages.EvaluatorVariableValueEditor_Title, (Variable)variable.getInternalVariable());
        if (value.isPresent()) {
            try {
                variable.setValue((String)value.get());
            }
            catch (DebugException e) {
                ErrorDialog.openError(null, null, null, (IStatus)Status.error((String)e.getLocalizedMessage(), (Throwable)e));
            }
        }
    }

    protected static void openInputDialog(EvaluatorDebugVariable variable, Shell shell) {
        InputDialog inputDialog = new InputDialog(shell, Messages.EvaluatorVariableValueEditor_Title, MessageFormat.format(Messages.EvaluatorVariableValueEditor_Message, variable.getName()), variable.getValue().getValueString(), input -> EvaluatorVariableValueEditor.validateInput((IVariable)variable, input));
        if (inputDialog.open() == 0) {
            String newValue = inputDialog.getValue();
            try {
                variable.setValue(newValue);
            }
            catch (DebugException e) {
                ErrorDialog.openError(null, null, null, (IStatus)Status.error((String)e.getLocalizedMessage(), (Throwable)e));
            }
        }
    }

    protected static String validateInput(IVariable variable, String input) {
        try {
            if (variable.verifyValue(input)) {
                return null;
            }
        }
        catch (DebugException exception) {
            return Messages.EvaluatorVariableValueEditor_Exception;
        }
        return Messages.EvaluatorVariableValueEditor_Invalid;
    }

    protected static boolean isStructuredVariable(EvaluatorDebugVariable evaluatorDebugVariable) {
        INamedElement type = evaluatorDebugVariable.getInternalVariable().getType();
        return type instanceof StructuredType || type instanceof ArrayType;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        return false;
    }
}

