/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class AddFBBookMark
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FBNetworkElement element = AddFBBookMark.getSelectedFBElement(event);
        if (element != null) {
            String description = AddFBBookMark.getDescription(element, event);
            IResource file = AddFBBookMark.getFile(element);
            if (description != null && file != null) {
                CreateMarkersOperation op = new CreateMarkersOperation("org.eclipse.core.resources.bookmark", ErrorMarkerBuilder.createErrorMarkerBuilder((String)description).setSeverity(0).setPriority(1).setTarget((EObject)element).getAttributes(), file, Messages.AddFBBookMark_AddBookmark);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event)));
                }
                catch (ExecutionException e) {
                    FordiacLogHelper.logError((String)"Could not create bookmark", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private static String getDescription(FBNetworkElement element, ExecutionEvent event) {
        InputDialog descriptiondialog = new InputDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), MessageFormat.format(Messages.AddFBBookMark_AddBookMarkTitle, element.getName()), Messages.AddFBBookMark_EnterBookmarkName, element.getName(), null){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button okButton = this.getOkButton();
                okButton.setText(Messages.AddFBBookMark_AddBookmark);
            }
        };
        if (descriptiondialog.open() != 1) {
            String description = descriptiondialog.getValue();
            if (!(description = description.trim()).isEmpty()) {
                return description;
            }
        }
        return null;
    }

    private static IResource getFile(FBNetworkElement element) {
        EObject container = EcoreUtil.getRootContainer((EObject)element);
        if (container instanceof LibraryElement) {
            return ((LibraryElement)container).getTypeEntry().getFile();
        }
        return null;
    }

    private static FBNetworkElement getSelectedFBElement(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            Object selObj = ((StructuredSelection)selection).getFirstElement();
            if (selObj instanceof EditPart) {
                selObj = ((EditPart)selObj).getModel();
            }
            if (selObj instanceof FBNetworkElement) {
                return (FBNetworkElement)selObj;
            }
        }
        return null;
    }
}

