# frozen_string_literal: true

require 'spec_helper'

require_migration!

RSpec.describe ScheduleFixingNamespaceIdsOfVulnerabilityReads, feature_category: :vulnerability_management do
  let(:batched_migration) { described_class::MIGRATION }

  it 'schedules a new batched migration' do
    reversible_migration do |migration|
      migration.before -> {
        expect(batched_migration).not_to have_scheduled_batched_migration
      }

      migration.after -> {
        expect(batched_migration).to have_scheduled_batched_migration(
          table_name: :vulnerability_reads,
          column_name: :vulnerability_id,
          interval: 2.minutes,
          batch_size: 10_000,
          sub_batch_size: 100
        )
      }
    end
  end
end
