#Nos situamos en el directorio de trabajo
setwd("D:/Asignaturas/Curso R")

#Cargamos el paquete MASS
library(MASS)

#AJUSTE DE UNA POISSON A LOS DATOS SOBRE LAS MUERTES POR COCES DE CABALLOS

#Cargamos los datos
load("DatosMuertesCoces.rda")
#Cmo se llama la hoja de datos?
objects()#Se llama Datos.muertes
#Cmo se llama la variable?
names(Datos.muertes)#Se llama Muertes
Datos.muertes$Muertes

#Ajustamos una Poisson
ajuste.poisson<-fitdistr(Datos.muertes$Muertes,"Poisson")
ajuste.poisson
lambda<-ajuste.poisson$estimate

#Comparamos las frecuencias observadas con las esperadas segn ese modelo
hist(Datos.muertes$Muertes,breaks=-0.5:4.5,main="",xlab="N de muertes",ylab="Frecuencias")
lines(0:4,200*dpois(0:4,lambda))

#AJUSTE DE UNA GEOMTRICA A LOS DATOS SOBRE LOS TIEMPOS ENTRE PAQUETES

#Empezamos borrando todo lo anterior
rm(list=ls(all=TRUE))
#Cargamos los datos
load("trafico.telem.rda")
#Cmo se llaman los datos?
objects()#La hoja de datos se llama trafico.telem
#Cmo se llama la variable?
names(Datos.trafico)#Se llama tiempos.entre.paquetes

#Ajustamos una geomtrica
ajuste.geom<-fitdistr(Datos.trafico$tiempos.entre.paquetes,"geometric")
ajuste.geom
p<-ajuste.geom$estimate

#Comparamos las frecuencias observadas con las esperadas segn el modelo
min(Datos.trafico$tiempos.entre.paquetes)
max(Datos.trafico$tiempos.entre.paquetes)
hist(Datos.trafico$tiempos.entre.paquetes,breaks=-0.5:32.5,freq=TRUE,main="",xlab="Tiempos entre paquetes",ylab="Frecuencias")
lines(0:32,250*dgeom(0:32,p))

#AJUSTE DE UNA BINOMIAL NEGATIVA A LOS DATOS SOBRE LOS TIEMPOS ENTRE PAQUETES

#Los datos ya estn cargados

#Ajustamos una binomial negativa
ajuste.binoneg<-fitdistr(Datos.trafico$tiempos.entre.paquetes,"negative binomial")
ajuste.binoneg#Observad que no da la estimacin de la probabilidad, sino de la media
a<-ajuste.binoneg$estimate[1]
mu<-ajuste.binoneg$estimate[2]
p<-a/(a+mu)

#Comparamos las frecuencias observadas con las esperadas segn el modelo
hist(Datos.trafico$tiempos.entre.paquetes,breaks=-0.5:32.5,freq=TRUE,main="",xlab="Tiempos entre paquetes",ylab="Frecuencias")
lines(0:32,250*dnbinom(0:32,a,p))

#AJUSTE DE UNA EXPONENCIAL A LOS DATOS SOBRE TIEMPOS DE FALLO

#Borramos todo lo anterior y cargamos los datos
rm(list=ls(all=TRUE))
load("tiempos.fallo.rda")
#Nombre de la hoja de datos y de la variable?
objects()#La hoja de datos se llama Datos.tiempos.fallo
names(Datos.tiempos.fallo)

#Ajustamos una exponencial
ajuste.exp<-fitdistr(Datos.tiempos.fallo$Aos,"exponential")
ajuste.exp
lambda<-ajuste.exp$estimate

#Comparamos el histograma con la funcin de densidad
hist(Datos.tiempos.fallo$Aos,breaks=18,freq=FALSE,main="",xlab="Aos",ylab="Densidad")
lines(0:100/10,dexp(0:100/10,lambda))
#No cierres el grfico!

#AJUSTE DE UNA GAMMA A LOS DATOS SOBRE TIEMPOS DE FALLO

#Los datos ya estn cargados

#Ajustamos una Gamma
ajuste.gamma<-fitdistr(Datos.tiempos.fallo$Aos,"gamma")
ajuste.gamma
a<-ajuste.gamma$estimate[1]
lambda2<-ajuste.gamma$estimate[2]

#Comparamos el histograma con la funcin de densidad y con el anterior ajuste
lines(0:100/10,dgamma(0:100/10,a,lambda2),"p")

#AJUSTE DE LOS DATOS SOBRE LOS TIEMPOS QUE TARDAN EN HACER UNA TAREA MEDIANTE UNA DISTRIBUCIN NORMAL

#Borramos todo lo anterior y cargamos los datos
rm(list=ls(all=TRUE))
load("operarios.tarea.rda")
#Nombre de la hoja de datos y de la variable?
objects()#La hoja de datos se llama muestra
names(muestra)#La variable se llama tiempos

#Ajustamos la normal
ajuste.normal<-fitdistr(muestra$tiempo,"normal")
ajuste.normal
mu<-ajuste.normal$estimate[1]
sigma<-ajuste.normal$estimate[2]

#Comparamos el histograma con la densidad normal ajustada
hist(muestra$tiempos,breaks=13,freq=FALSE,main="",xlab="Tiempos",ylab="Densidad")
lines(350:550/10,dnorm(350:550/10,mu,sigma))