#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Akademia Ekonomiczna we Wrocawiu
#*  
#*  Funkcja do ksiki:
#*  "Statystyczna analiza wielowymiarowa z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# utilities(u, Lj) - funkcja obliczajca wszystkie uytecznoci czstkowe poziomw (kodowanie quasi-eksperymentalne - sum contrasts)
# u - uytecznoci czstkowe (parametry) poziomw atrybutw (liczba parametrw jest rwna liczbie zmiennych sztucznych)
# Lj - liczba poziomw j-tego atrybutu (wektor Lj o dugoci rwnej liczbie atrybutw zawiera liczby poziomw kadego atrybutu)
# wywoanie - ul <- utilities (u, Lj)

utilities <- function(u, Lj)
{
   m <- length(Lj)   #liczba atrybutw
   L <- sum(Lj)      #czna liczba poziomw
   p <- length(u)    #liczba parametrw (z wyrazem wolnym)
   b <- vector("numeric", p-1)  #wektor parametrw bez wyrazu wolnego
   ul <- vector("numeric", L)   #uytecznoci czstkowe poziomw atrybutw z poziomami odniesienia
   for(i in 1:(p-1)) {b[i] <- u[i+1]}
   i <- 0
   h <- 1
   for(j in 1:m)
   {
      tu <- 0
      l <- Lj[j]-1
      for (k in 1:l)
      {
         i <- i+1
         ul[i] <- b[h]
         tu <- tu+ul[i]
         h <- h+1
      }
      i <- i+1
      ul[i] <- -tu
   }
   return(ul)
}