/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import dag.DagLevel;
import dag.DagUtil;
import dag.HighCapacityDagLevel;
import dag.LowCapacityDagLevel;
import java.util.Arrays;
import vcf.HapsMarker;

public class MergeableDagLevel {
    private MergeableDagLevel nextLevel = null;
    private MergeableDagLevel prevLevel = null;
    private final int levelIndex;
    private final int nAlleles;
    private final int nHaps;
    private final float[] weights;
    private int[][] outEdges;
    private int[] child2FirstInEdge;
    private int[] inEdge2NextInEdge;
    private int[] parentNodes;
    private int[] childNodes;
    private int[] symbols;
    private float[] counts;
    private int[] child2FirstHap;
    private int[] hap2NextHap;

    private static float[] defaultWeights(HapsMarker hapsMarker) {
        float[] fArray = new float[hapsMarker.nHaps()];
        Arrays.fill(fArray, 1.0f);
        return fArray;
    }

    public MergeableDagLevel(HapsMarker hapsMarker) {
        this(hapsMarker, MergeableDagLevel.defaultWeights(hapsMarker));
    }

    public MergeableDagLevel(HapsMarker hapsMarker, float[] fArray) {
        this.checkParameters(hapsMarker, fArray);
        this.prevLevel = null;
        this.nextLevel = null;
        this.levelIndex = 0;
        this.nAlleles = hapsMarker.marker().nAlleles();
        this.nHaps = hapsMarker.nHaps();
        this.weights = (float[])fArray.clone();
        this.allocateAndInitializeArrays(this.nAlleles, this.nHaps);
        this.fillArrays(hapsMarker, fArray);
    }

    public MergeableDagLevel(MergeableDagLevel mergeableDagLevel, HapsMarker hapsMarker) {
        this.checkParameters(mergeableDagLevel, hapsMarker);
        this.prevLevel = mergeableDagLevel;
        this.nextLevel = null;
        this.levelIndex = mergeableDagLevel.index() + 1;
        this.nAlleles = hapsMarker.marker().nAlleles();
        this.nHaps = hapsMarker.nHaps();
        this.weights = mergeableDagLevel.weights;
        this.allocateAndInitializeArrays(this.nAlleles, this.nHaps);
        this.fillArrays(mergeableDagLevel, hapsMarker, this.weights);
    }

    private void checkParameters(HapsMarker hapsMarker, float[] fArray) {
        if (fArray.length != hapsMarker.nHaps()) {
            String string = "data.nHaps()=" + hapsMarker.nHaps() + " != weights.length=" + fArray.length;
            throw new IllegalArgumentException(string);
        }
    }

    private void checkParameters(MergeableDagLevel mergeableDagLevel, HapsMarker hapsMarker) {
        if (mergeableDagLevel.nextLevel != null) {
            throw new IllegalArgumentException("parent.nextLevel!=null");
        }
        if (mergeableDagLevel.nHaps() != hapsMarker.nHaps()) {
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private void allocateAndInitializeArrays(int n, int n2) {
        this.outEdges = new int[n][n2];
        this.child2FirstInEdge = new int[n2];
        this.inEdge2NextInEdge = new int[n2];
        this.parentNodes = new int[n2];
        this.childNodes = new int[n2];
        this.symbols = new int[n2];
        this.counts = new float[n2];
        this.child2FirstHap = new int[n2];
        this.hap2NextHap = new int[n2];
        for (int[] nArray : this.outEdges) {
            Arrays.fill(nArray, -1);
        }
        Arrays.fill(this.child2FirstInEdge, -1);
        Arrays.fill(this.inEdge2NextInEdge, -1);
        Arrays.fill(this.parentNodes, -1);
        Arrays.fill(this.childNodes, -1);
        Arrays.fill(this.symbols, -1);
        Arrays.fill(this.child2FirstHap, -1);
        Arrays.fill(this.hap2NextHap, -1);
    }

    private void fillArrays(HapsMarker hapsMarker, float[] fArray) {
        int n = 0;
        int n2 = 0;
        int n3 = hapsMarker.nHaps();
        for (int i = 0; i < n3; ++i) {
            int n4 = hapsMarker.allele(i);
            float f = fArray[i];
            int n5 = this.outEdges[n4][n];
            if (n5 == -1) {
                this.addEdge(n, n4, f, n2++, i);
                continue;
            }
            assert (n5 == this.childNodes[n5]);
            int n6 = this.childNodes[n5];
            int n7 = n5;
            this.counts[n7] = this.counts[n7] + f;
            this.hap2NextHap[i] = this.child2FirstHap[n6];
            this.child2FirstHap[n6] = i;
        }
        if ((double)n2 < 0.75 * (double)this.nHaps) {
            this.reduceEdgeArrayLengths(n2);
        }
    }

    private void fillArrays(MergeableDagLevel mergeableDagLevel, HapsMarker hapsMarker, float[] fArray) {
        int n = 0;
        int n2 = mergeableDagLevel.child2FirstHap.length;
        for (int i = 0; i < n2; ++i) {
            if (mergeableDagLevel.child2FirstHap[i] < 0) continue;
            int n3 = mergeableDagLevel.child2FirstHap[i];
            while (n3 != -1) {
                int n4 = hapsMarker.allele(n3);
                float f = fArray[n3];
                int n5 = this.outEdges[n4][i];
                if (n5 == -1) {
                    this.addEdge(i, n4, f, n++, n3);
                } else {
                    assert (n5 == this.childNodes[n5]);
                    int n6 = this.childNodes[n5];
                    int n7 = n5;
                    this.counts[n7] = this.counts[n7] + f;
                    this.hap2NextHap[n3] = this.child2FirstHap[n6];
                    this.child2FirstHap[n6] = n3;
                }
                n3 = mergeableDagLevel.hap2NextHap[n3];
            }
        }
        if ((double)n < 0.75 * (double)this.nHaps) {
            this.reduceEdgeArrayLengths(n);
        }
        mergeableDagLevel.removeHaplotypeIndices();
    }

    private void addEdge(int n, int n2, float f, int n3, int n4) {
        int n5 = n3;
        this.outEdges[n2][n] = n3;
        this.child2FirstInEdge[n5] = n3;
        this.parentNodes[n3] = n;
        this.childNodes[n3] = n5;
        this.symbols[n3] = n2;
        this.counts[n3] = f;
        this.child2FirstHap[n5] = n4;
    }

    private void reduceEdgeArrayLengths(int n) {
        this.child2FirstInEdge = Arrays.copyOf(this.child2FirstInEdge, n);
        this.inEdge2NextInEdge = Arrays.copyOf(this.inEdge2NextInEdge, n);
        this.parentNodes = Arrays.copyOf(this.parentNodes, n);
        this.childNodes = Arrays.copyOf(this.childNodes, n);
        this.symbols = Arrays.copyOf(this.symbols, n);
        this.counts = Arrays.copyOf(this.counts, n);
    }

    private void removeHaplotypeIndices() {
        this.child2FirstHap = null;
        this.hap2NextHap = null;
    }

    public MergeableDagLevel setPreviousToNull() {
        MergeableDagLevel mergeableDagLevel = this.prevLevel;
        this.prevLevel = null;
        return mergeableDagLevel;
    }

    public void setNextLevel(MergeableDagLevel mergeableDagLevel) {
        if (mergeableDagLevel.prevLevel != this) {
            throw new IllegalArgumentException("nextLevel.previousLevel!=this");
        }
        this.nextLevel = mergeableDagLevel;
    }

    public MergeableDagLevel previous() {
        return this.prevLevel;
    }

    public MergeableDagLevel next() {
        return this.nextLevel;
    }

    public boolean hasSibling(int n) {
        int n2 = this.prevLevel.child2FirstInEdge[n];
        while (n2 >= 0) {
            int n3 = this.prevLevel.parentNodes[n2];
            int n4 = 0;
            int n5 = this.prevLevel.nAlleles;
            for (int i = 0; i < n5; ++i) {
                if (this.prevLevel.outEdges[i][n3] < 0) continue;
                ++n4;
            }
            if (n4 > 1) {
                return true;
            }
            n2 = this.prevLevel.inEdge2NextInEdge[n2];
        }
        return false;
    }

    public DagLevel toDagLevel() {
        float[] fArray = DagUtil.removeValues(this.counts, 0.0f);
        int[] nArray = DagUtil.removeValues(this.symbols, -1);
        int[] nArray2 = DagUtil.removeValues(this.parentNodes, -1);
        int[] nArray3 = DagUtil.removeValues(this.childNodes, -1);
        if (fArray.length <= 65535) {
            char[] cArray = MergeableDagLevel.toCharArray(nArray);
            char[] cArray2 = MergeableDagLevel.rankedCharValues(nArray2);
            char[] cArray3 = MergeableDagLevel.rankedCharValues(nArray3);
            return new LowCapacityDagLevel(cArray2, cArray3, cArray, fArray);
        }
        int[] nArray4 = MergeableDagLevel.rankedIntValues(nArray2);
        int[] nArray5 = MergeableDagLevel.rankedIntValues(nArray3);
        return new HighCapacityDagLevel(nArray4, nArray5, nArray, fArray);
    }

    private static char[] toCharArray(int[] nArray) {
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            if (nArray[i] < 0 || nArray[i] > 65535) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    private static char[] rankedCharValues(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("array.length==0");
        }
        int[] nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        if (nArray2[0] < 0) {
            throw new IllegalArgumentException(String.valueOf(nArray2[0]));
        }
        int n = nArray2[nArray2.length - 1] + 1;
        int[] nArray3 = new int[n];
        int n2 = 0;
        nArray3[nArray2[0]] = n2++;
        for (int i = 1; i < nArray2.length; ++i) {
            if (nArray2[i] == nArray2[i - 1]) continue;
            nArray3[nArray2[i]] = n2++;
        }
        if (n2 - 1 >= 65535) {
            String string = "Array has more than (Character.MAX_VALUE + 1) values";
            throw new IllegalArgumentException(string);
        }
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)nArray3[nArray[i]];
        }
        return cArray;
    }

    private static int[] rankedIntValues(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("array.length==0");
        }
        int[] nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        if (nArray2[0] < 0) {
            throw new IllegalArgumentException(String.valueOf(nArray2[0]));
        }
        int n = nArray2[nArray2.length - 1] + 1;
        int[] nArray3 = new int[n];
        int n2 = 0;
        nArray3[nArray2[0]] = n2++;
        for (int i = 1; i < nArray2.length; ++i) {
            if (nArray2[i] == nArray2[i - 1]) continue;
            nArray3[nArray2[i]] = n2++;
        }
        int[] nArray4 = new int[nArray.length];
        for (int i = 0; i < nArray4.length; ++i) {
            nArray4[i] = nArray3[nArray[i]];
        }
        return nArray4;
    }

    public void mergeParentNodes(int n, int n2) {
        if (!this.isParentNode(n)) {
            String string = "invalid parent node: " + n;
            throw new IllegalArgumentException(string);
        }
        if (!this.isParentNode(n2)) {
            String string = "invalid parent node: " + n2;
            throw new IllegalArgumentException(string);
        }
        this.prevLevel.mergeChildNodes(n, n2);
        this.mergeParentNodes2(n, n2);
    }

    private void mergeParentNodes2(int n, int n2) {
        for (int i = 0; i < this.nAlleles; ++i) {
            int n3 = this.outEdges[i][n];
            int n4 = this.outEdges[i][n2];
            if (n4 < 0) continue;
            if (n3 == -1) {
                this.changeParent(n4, n);
                continue;
            }
            int n5 = this.childNode(n3);
            int n6 = this.childNode(n4);
            this.mergeEdges(n3, n4);
            if (this.nextLevel == null) continue;
            this.nextLevel.mergeParentNodes2(n5, n6);
        }
    }

    private void mergeChildNodes(int n, int n2) {
        int n3 = -1;
        int n4 = this.child2FirstInEdge[n2];
        while (n4 != -1) {
            assert (this.childNodes[n4] == n2);
            this.childNodes[n4] = n;
            n3 = n4;
            n4 = this.inEdge2NextInEdge[n4];
        }
        if (n3 != -1) {
            this.inEdge2NextInEdge[n3] = this.child2FirstInEdge[n];
            this.child2FirstInEdge[n] = this.child2FirstInEdge[n2];
            this.child2FirstInEdge[n2] = -1;
        }
    }

    private void changeParent(int n, int n2) {
        int n3 = this.parentNodes[n];
        int n4 = this.symbols[n];
        assert (this.outEdges[n4][n3] == n);
        assert (this.outEdges[n4][n2] == -1);
        this.outEdges[n4][n3] = -1;
        this.outEdges[n4][n2] = n;
        this.parentNodes[n] = n2;
    }

    private void mergeEdges(int n, int n2) {
        assert (this.symbols[n] == this.symbols[n2]);
        assert (this.counts[n2] > 0.0f);
        int n3 = n;
        this.counts[n3] = this.counts[n3] + this.counts[n2];
        if (this.nextLevel == null) {
            this.mergeHaplotypes(this.childNodes[n], this.childNodes[n2]);
        }
        int n4 = this.parentNodes[n2];
        int n5 = this.childNodes[n2];
        int n6 = this.symbols[n2];
        assert (this.inEdge2NextInEdge[this.child2FirstInEdge[n5]] == -1);
        this.outEdges[n6][n4] = -1;
        this.child2FirstInEdge[n5] = -1;
        this.counts[n2] = 0.0f;
        this.parentNodes[n2] = -1;
        this.childNodes[n2] = -1;
        this.symbols[n2] = -1;
    }

    private void mergeHaplotypes(int n, int n2) {
        int n3 = this.child2FirstHap[n2];
        while (this.hap2NextHap[n3] != -1) {
            n3 = this.hap2NextHap[n3];
        }
        this.hap2NextHap[n3] = this.child2FirstHap[n];
        this.child2FirstHap[n] = this.child2FirstHap[n2];
        this.child2FirstHap[n2] = -1;
    }

    public int index() {
        return this.levelIndex;
    }

    public int nHaps() {
        return this.nHaps;
    }

    public int nAlleles() {
        return this.nAlleles;
    }

    public float edgeCount(int n) {
        return this.counts[n];
    }

    public float nodeCount(int n) {
        float f = 0.0f;
        for (int i = 0; i < this.nAlleles; ++i) {
            if (this.outEdges[i][n] < 0) continue;
            f += this.edgeCount(this.outEdges[i][n]);
        }
        return f;
    }

    public int[] parentNodeArray() {
        int[] nArray = DagUtil.removeValues(this.parentNodes, -1);
        Arrays.sort(nArray);
        assert (nArray.length > 0);
        int n = 1;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            ++n;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        nArray2[n2++] = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            nArray2[n2++] = nArray[i];
        }
        assert (n2 == nArray2.length);
        return nArray2;
    }

    public int parentNode(int n) {
        return this.parentNodes[n];
    }

    public int childNode(int n) {
        return this.childNodes[n];
    }

    public int outEdge(int n, int n2) {
        return this.outEdges[n2][n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append(Const.nl);
        stringBuilder.append("[ MergeableDagLevel: marker=");
        stringBuilder.append(this.levelIndex);
        stringBuilder.append(Const.nl);
        int n = this.nHaps();
        for (int i = 0; i < n; ++i) {
            if (this.parentNodes[i] == -1) continue;
            stringBuilder.append("edge=");
            stringBuilder.append(i);
            stringBuilder.append(" parent=");
            stringBuilder.append(this.parentNodes[i]);
            stringBuilder.append(" child=");
            stringBuilder.append(this.childNodes[i]);
            stringBuilder.append(" symbol=");
            stringBuilder.append(this.symbols[i]);
            stringBuilder.append(" count=");
            stringBuilder.append(this.counts[i]);
            stringBuilder.append(Const.nl);
        }
        stringBuilder.append("previous=");
        stringBuilder.append(this.prevLevel != null);
        stringBuilder.append(" next=");
        stringBuilder.append(this.nextLevel != null);
        stringBuilder.append(Const.nl);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    private boolean isParentNode(int n) {
        if (this.prevLevel != null) {
            return this.prevLevel.child2FirstInEdge[n] >= 0;
        }
        for (int i = 0; i < this.nAlleles; ++i) {
            if (this.outEdges[i][n] == -1) continue;
            return true;
        }
        return false;
    }
}

