/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.SelectFunctions;
import dmLab.array.saver.Array2ADX;
import dmLab.classifier.Classifier;
import dmLab.classifier.Params;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.experiment.classification.ClassificationParams;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.mcfsEngine.MCFSFinalCV;
import dmLab.mcfs.mcfsEngine.framework.MCFSClassic;
import dmLab.mcfs.mcfsEngine.framework.MCFSFramework;
import dmLab.mcfs.mcfsEngine.framework.MCFSPermutation;
import dmLab.utils.ArrayUtils;
import dmLab.utils.FileUtils;
import dmLab.utils.GeneralUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.dataframe.DataFrame;
import dmLab.utils.helpers.MinMax;
import dmLab.utils.statFunctions.StatFunctions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.zip.ZipOutputStream;

public final class MCFSExperiment
implements Runnable {
    private MCFSFramework mcfs;
    private MCFSParams myParams;
    private Random random;
    private ArrayUtils arrayUtils;
    private int topRankingSize = 0;

    /*
     * WARNING - void declaration
     */
    public MCFSExperiment(MCFSParams mcfsParams) {
        void var1_1;
        if (mcfsParams.verbose) {
            System.out.println("MCFSExperiment Params: \n" + ((Params)mcfsParams).toString());
        }
        this.random = new Random(mcfsParams.seed);
        this.arrayUtils = new ArrayUtils(this.random);
        this.myParams = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        if (this.myParams.mode == 2) {
            void var3_5;
            Object object;
            MCFSParams mcfsParamsP1 = this.myParams.clone();
            this.myParams.clone().buildID = false;
            mcfsParamsP1.finalRuleset = false;
            mcfsParamsP1.finalCV = false;
            mcfsParamsP1.saveResultFiles = false;
            mcfsParamsP1.zipResult = false;
            mcfsParamsP1.savePrunedData = false;
            mcfsParamsP1.minTopRankingSize = 0.05f;
            mcfsParamsP1.cutoffMethod = "contrast";
            mcfsParamsP1.phase = 1;
            mcfsParamsP1.filesufix_RI = MCFSParams.FILESUFIX_RI_PHASE_1;
            System.out.println("****************************************************");
            System.out.println("*** Running Phase I - Initial MCFS-ID filtering  ***");
            Object tmpArray = this.start(mcfsParamsP1);
            if (tmpArray == null) {
                return;
            }
            this.mcfs.clearArrays();
            if (mcfsParamsP1.verbose) {
                System.out.println(GeneralUtils.getMemStatus("G"));
            }
            AttributesRI ri_phase1 = this.mcfs.globalStats.getAttrImportances()[0];
            Object object2 = new File(mcfsParamsP1.resFilesPATH + File.separator + mcfsParamsP1.getExperimentName() + "_" + ri_phase1.label + "_" + mcfsParamsP1.filesufix_RI);
            FileUtils.saveString(((File)object2).getAbsolutePath(), ri_phase1.toString());
            File input_phase2_file = new File(mcfsParamsP1.tmpPATH + File.separator + FileUtils.dropFileExtension(new File(mcfsParamsP1.inputFileName)) + ".adx");
            BufferedWriter fileWriter = FileUtils.openFileWriter(new File(input_phase2_file.getAbsolutePath()));
            Object object3 = fileWriter;
            Object object4 = tmpArray;
            tmpArray = new Array2ADX();
            ((Array2ADX)tmpArray).toWriter$5a1c9387((FArray)object4, (BufferedWriter)object3);
            FileUtils.closeFileWriter(fileWriter);
            MCFSParams mcfsParamsP2 = this.myParams.clone();
            this.myParams.clone().inputFilesPATH = input_phase2_file.getAbsoluteFile().getParent();
            mcfsParamsP2.inputFileName = input_phase2_file.getName();
            mcfsParamsP2.minTopRankingSize = 0.0f;
            mcfsParamsP2.zipResult = false;
            mcfsParamsP2.phase = 2;
            mcfsParamsP2.filesufix_RI = MCFSParams.FILESUFIX_RI_PHASE_2;
            System.out.println("***************************************************");
            System.out.println("*** Running Phase II - Final MCFS-ID filtering  ***");
            this.start(mcfsParamsP2);
            this.mcfs.clearArrays();
            if (mcfsParamsP2.verbose) {
                System.out.println(GeneralUtils.getMemStatus("G"));
            }
            object4 = this;
            Object ri_phase2 = ((MCFSExperiment)object4).mcfs.globalStats.getAttrImportances()[0];
            DataFrame df_ri_phase32 = ri_phase1.toDataFrame(AttributesRI.getMeasuresNamesBasic());
            DataFrame df_ri_phase2 = ((AttributesRI)ri_phase2).toDataFrame(AttributesRI.getMeasuresNamesBasic());
            object3 = df_ri_phase2;
            object4 = df_ri_phase32;
            int df_ri_phase32 = ((DataFrame)object4).rows();
            object2 = new boolean[df_ri_phase32];
            int n = ((DataFrame)object3).getColIdx(AttributesRI.ATTRIBUTE_LABEL);
            int n2 = ((DataFrame)object4).getColIdx("RI");
            ((DataFrame)object3).setKeyColumn(n);
            for (int i = 0; i < df_ri_phase32; ++i) {
                object = ((DataFrame)object4).get(i, n).toString();
                if (((String)object).startsWith(MCFSParams.CONTRAST_ATTR_NAME)) {
                    object2[i] = false;
                    continue;
                }
                object2[i] = true;
                if (((DataFrame)object3).getRowIdx(object) < 0) continue;
                ((DataFrame)object4).set(i, n2, Float.valueOf(-1.0f));
            }
            DataFrame dataFrame = ((DataFrame)object4).filterRows((boolean[])object2);
            ((DataFrame)object4).filterRows((boolean[])object2).separator = ",";
            df_ri_phase32 = dataFrame.rows();
            object = dataFrame.getColumnNumeric(n2);
            object2 = ((DataFrame)object3).getColumnNumeric(n2);
            object4 = ArrayUtils.getMinMax((float[])object, false);
            object2 = ArrayUtils.getMinMax((float[])object2, false);
            boolean bl = false;
            float f = ((MinMax)object2).minValue * 0.999f;
            float f2 = ((MinMax)object4).minValue;
            Object object5 = object;
            MinMax minMax = ArrayUtils.getMinMax((float[])object5, false);
            for (int i = 0; i < ((Object)object5).length; ++i) {
                if (!(object5[i] >= 0.0f)) continue;
                object5[i] = (object5[i] - minMax.minValue) / (minMax.maxValue - minMax.minValue);
                object5[i] = object5[i] * (f - f2) + f2;
            }
            for (int i = 0; i < df_ri_phase32; ++i) {
                String string = dataFrame.get(i, n).toString();
                int n3 = ((DataFrame)object3).getRowIdx(string);
                if (n3 < 0) {
                    dataFrame.set(i, n2, Float.valueOf((float)object5[i]));
                    continue;
                }
                dataFrame.set(i, 0, ((DataFrame)object3).getRow(n3));
            }
            DataFrame ri_final = dataFrame;
            ri_phase2 = new File(mcfsParamsP2.resFilesPATH + File.separator + mcfsParamsP2.getExperimentName() + "_" + ((AttributesRI)ri_phase2).label + "_" + MCFSParams.FILESUFIX_RI);
            FileUtils.saveString(((File)ri_phase2).getAbsolutePath(), var3_5.toString());
            if (this.myParams.zipResult) {
                void var2_2;
                MCFSExperiment.zipResult((MCFSParams)var2_2);
            }
        } else {
            MCFSExperiment mCFSExperiment = this;
            mCFSExperiment.start(mCFSExperiment.myParams);
        }
        File tmpdir = new File(this.myParams.tmpPATH);
        if (tmpdir.exists()) {
            void var1_1;
            FileUtils.deleteDir((File)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FArray start(MCFSParams mcfsParams) {
        void var1_1;
        void var2_2;
        Object cutoffValues;
        if (mcfsParams.verbose) {
            System.out.println("MCFSExperiment.start() Params: \n" + ((Params)mcfsParams).toString());
        }
        long start = System.currentTimeMillis();
        if (!((Params)mcfsParams).check(null)) {
            return null;
        }
        DataFrame permutationRIValues = null;
        ArrayList<Float> maxPermutationRI = new ArrayList<Float>();
        ArrayList<Float> maxPermutationID = new ArrayList<Float>();
        ArrayList<String> permFiles = new ArrayList<String>();
        if (mcfsParams.cutoffMethod.equalsIgnoreCase("permutations")) {
            MCFSParams cutoffParams = mcfsParams.clone();
            for (int i = 0; i < cutoffParams.cutoffPermutations; ++i) {
                System.out.println("***************************************************");
                System.out.println("*** MCFS-ID Cutoff Permutation Experiment #" + (i + 1) + "/" + cutoffParams.cutoffPermutations + " ***");
                System.out.println("***************************************************");
                this.mcfs = new MCFSPermutation(this.random);
                this.mcfs.chartTitle = "MCFS-ID Progress - Permutation Experiment #" + (i + 1);
                this.mcfs.experimentName = "perm_" + (i + 1) + "_" + cutoffParams.getExperimentName();
                permFiles.add(new File(mcfsParams.resFilesPATH + File.separator + this.mcfs.experimentName + "__" + mcfsParams.filesufix_RI).getAbsolutePath());
                cutoffParams.saveResultFiles = false;
                cutoffParams.zipResult = false;
                if (!this.mcfs.run(cutoffParams)) {
                    return null;
                }
                AttributesRI cutoff_RI = this.mcfs.globalStats.getAttrImportances()[0];
                if (permutationRIValues == null) {
                    permutationRIValues = MCFSExperiment.createPermutationResult(this.mcfs.mcfsArrays.sourceArray, cutoffParams);
                }
                AttributesRI attributesRI = cutoff_RI;
                permutationRIValues.setColumn(i + 1, attributesRI.getImportanceValues(attributesRI.mainMeasureIdx));
                AttributesRI attributesRI2 = cutoff_RI;
                float[] minMax = attributesRI2.getMinMaxImportances(attributesRI2.mainMeasureIdx);
                maxPermutationRI.add(Float.valueOf(minMax[1]));
                if (this.mcfs.globalStats.getAttrConnections() != null) {
                    maxPermutationID.add(Float.valueOf(this.mcfs.globalStats.getAttrConnections().getMaxID()));
                }
                System.out.println("");
            }
        }
        System.out.println("**************************");
        System.out.println("*** MCFS-ID Experiment ***");
        System.out.println("**************************");
        this.mcfs = new MCFSClassic(this.random);
        this.mcfs.chartTitle = "MCFS-ID Progress - Real Data";
        if (!this.mcfs.run(mcfsParams)) {
            return null;
        }
        String experimentName = this.mcfs.experimentName;
        AttributesRI importancesClassic = this.mcfs.globalStats.getAttrImportances()[0];
        if (permutationRIValues != null) {
            int mainMeasureIndex = importancesClassic.mainMeasureIdx;
            DataFrame p_values = MCFSExperiment.calc_pValues$662b6a5a(permutationRIValues, importancesClassic.getImportanceValues(mainMeasureIndex));
            permutationRIValues.cbind(p_values);
            FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_PERMUTATIONS, permutationRIValues.toString());
            System.out.println("*** Calculation of cutoff RI (based on permutations) ***");
            float[] minMaxRI = importancesClassic.getMinMaxImportances(mainMeasureIndex);
            System.out.println("Max RI (raw data) = " + minMaxRI[1]);
            System.out.println("Max RI (after permutations) = " + Arrays.toString(maxPermutationRI.toArray()));
            double cutoffRI = MCFSExperiment.getCutoff(mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationRI.toArray()));
            Ranking topRanking = importancesClassic.getTopRanking(mainMeasureIndex, (float)cutoffRI);
            this.topRankingSize = 0;
            if (topRanking != null) {
                this.topRankingSize = topRanking.size();
            }
            System.out.println("Cutoff RI (based on permutations) = " + GeneralUtils.formatFloat(cutoffRI, 7));
            System.out.println("Important attributes (based on permutations) = " + this.topRankingSize);
            double cutoffID = Double.NaN;
            if (!maxPermutationID.isEmpty()) {
                System.out.println("*** Calculation of cutoff ID ***");
                cutoffID = MCFSExperiment.getCutoff(mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationID.toArray()));
                System.out.println("Cutoff ID (based on permutations)  = " + GeneralUtils.formatFloat(cutoffID, 7));
            }
            DataFrame cutoff = this.mcfs.globalStats.getCutoff().getCutoffTable();
            cutoff = cutoff.excludeRows(new int[]{cutoff.rows() - 1});
            Object cutoffRow = new DataFrame(1, cutoff);
            int lastRowIdx = ((DataFrame)cutoffRow).rows() - 1;
            ((DataFrame)cutoffRow).set(lastRowIdx, ((DataFrame)cutoffRow).getColIdx("method"), "permutations");
            ((DataFrame)cutoffRow).set(lastRowIdx, ((DataFrame)cutoffRow).getColIdx("minRI"), cutoffRI);
            ((DataFrame)cutoffRow).set(lastRowIdx, ((DataFrame)cutoffRow).getColIdx("size"), this.topRankingSize);
            ((DataFrame)cutoffRow).set(lastRowIdx, ((DataFrame)cutoffRow).getColIdx("minID"), cutoffID);
            cutoff.rbind((DataFrame)cutoffRow);
            this.mcfs.globalStats.getCutoff().setCutoffTable(cutoff);
            this.mcfs.globalStats.getCutoff().addMeanValue(importancesClassic);
            FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_CUTOFF, this.mcfs.globalStats.getCutoff().toString());
            if (mcfsParams.verbose) {
                Object[] s = new String[1];
                s = permFiles.toArray(s);
                System.out.println("deleting files: " + Arrays.toString(s));
            }
            FileUtils.deleteFiles(permFiles);
            String topRankingMethod = this.mcfs.globalStats.getCutoff().getMethod(mcfsParams.cutoffMethod);
            this.topRankingSize = (int)this.mcfs.globalStats.getCutoff().getCutoffValue(topRankingMethod);
            cutoffRow = importancesClassic.getTopRankingSize(mainMeasureIndex, this.topRankingSize);
            System.out.println("*** Final Important attributes (based on " + topRankingMethod + ") = " + ((Ranking)cutoffRow).size());
            if (mcfsParams.verbose) {
                System.out.println("Saving topRanking file...");
            }
            FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_TOPRANKING, ((Ranking)cutoffRow).toString());
        }
        if (mcfsParams.finalCV) {
            int topRankingSize = Math.max((int)this.mcfs.globalStats.getCutoff().getCutoffValue(mcfsParams.cutoffMethod), 4);
            MCFSFinalCV simpleCV = this.mcfs.mcfsArrays.sourceArray.isTargetNominal() ? new MCFSFinalCV(new int[]{Classifier.J48, Classifier.RF, Classifier.NB, Classifier.SVM, Classifier.KNN, Classifier.LOGISTIC, Classifier.RIPPER}, this.random) : new MCFSFinalCV(new int[]{Classifier.M5}, this.random);
            cutoffValues = MCFSExperiment.getCutoffValues(new int[]{topRankingSize});
            System.out.println("");
            System.out.println("*** Running CV experiment on input data limited to the top " + Arrays.toString((int[])cutoffValues) + " attributes ***");
            DataFrame res = simpleCV.run(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], (int[])cutoffValues, mcfsParams.finalCVfolds, mcfsParams.finalCVSetSize, mcfsParams.finalCVRepetitions);
            if (mcfsParams.saveResultFiles) {
                FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_CV_RESULT, res.toString());
                int cmatrixIdx = ArrayUtils.indexOf((int[])cutoffValues, topRankingSize);
                if (cmatrixIdx != -1 && simpleCV.j48ConfMatrix[cmatrixIdx] != null) {
                    FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_MATRIX_TOP, simpleCV.j48ConfMatrix[cmatrixIdx].toString(false, true, false, ","));
                }
            }
        }
        int topRankingSize = Math.max((int)this.mcfs.globalStats.getCutoff().getCutoffValue(mcfsParams.cutoffMethod), 2);
        cutoffValues = this.mcfs.mcfsArrays.sourceArray;
        int sourceArrayColNumber = ((Array)cutoffValues).attributes.length - 1;
        int minTopRankingValue = (int)((float)sourceArrayColNumber * mcfsParams.minTopRankingSize);
        if (topRankingSize < minTopRankingValue) {
            String s = "Warning! Number of top attributes from Phase I equals to " + topRankingSize + " (" + GeneralUtils.formatFloat(100.0 * (double)topRankingSize / (double)sourceArrayColNumber, 1) + "%). Phase II will use " + minTopRankingValue + " (" + GeneralUtils.formatFloat(100.0 * (double)mcfsParams.minTopRankingSize, 1) + "%) of top attributes.";
            System.err.println(s);
            topRankingSize = minTopRankingValue;
        }
        int[] topRankingColIdx = SelectFunctions.getColumnsIdx$e342baa(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], topRankingSize);
        int[] rowIdx = ArrayUtils.seq(0, ((Array)this.mcfs.mcfsArrays.sourceArray).rowsNumber());
        if (mcfsParams.finalRuleset && this.mcfs.mcfsArrays.sourceArray.isTargetNominal()) {
            System.out.println("");
            System.out.println("*** Building final RIPPER ruleset on top " + topRankingSize + " attributes ***");
            FArray ripperArray = this.mcfs.mcfsArrays.sourceArray.cloneByIdx(topRankingColIdx, this.arrayUtils.randomSelectValues(rowIdx, mcfsParams.finalCVSetSize));
            ClassificationBody classification = new ClassificationBody(this.random);
            classification.setParameters(new ClassificationParams());
            classification.classParams.verbose = false;
            classification.classParams.saveClassifier = false;
            classification.classParams.savePredictionResult = false;
            classification.classParams.repetitions = 1;
            classification.classParams.model = Classifier.RIPPER;
            classification.initClassifier();
            FArray fArray = ripperArray;
            classification.runTrainTest(fArray, fArray);
            String ripperResult = classification.classifier.toString(false) + "\n";
            classification.initClassifier();
            classification.classParams.folds = mcfsParams.finalCVfolds;
            classification.classParams.repetitions = mcfsParams.finalCVRepetitions;
            classification.runCV(ripperArray);
            ripperResult = ripperResult + "RIPPER CV Result (10 folds repeated " + mcfsParams.finalCVRepetitions + " times)\n" + classification.predResult.toString();
            System.out.println(classification.classifier.getPredResult().confusionMatrix.statsToString(2, false));
            if (mcfsParams.saveResultFiles) {
                FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_RULESET, ripperResult);
            }
        }
        FArray prunedArray = null;
        if (mcfsParams.phase == 1 | mcfsParams.savePrunedData) {
            prunedArray = this.mcfs.mcfsArrays.sourceArray.cloneByIdx(topRankingColIdx, rowIdx);
        }
        if (mcfsParams.saveResultFiles & mcfsParams.savePrunedData) {
            if (prunedArray == null) {
                prunedArray = this.mcfs.mcfsArrays.sourceArray.cloneByIdx(topRankingColIdx, rowIdx);
            }
            if (mcfsParams.verbose) {
                System.out.println("*** Saving pruned data ***");
                System.out.println("Saving File: " + mcfsParams.resFilesPATH + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".adh");
                System.out.println("Saving File: " + mcfsParams.resFilesPATH + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".csv");
            }
            FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".adh", prunedArray.toADH());
            FileUtils.saveString(mcfsParams.resFilesPATH + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".csv", prunedArray.toCSV());
        }
        if (mcfsParams.saveResultFiles && mcfsParams.zipResult) {
            if (mcfsParams.verbose) {
                System.out.println("*** Zipping result files ***");
            }
            MCFSExperiment.zipResult(mcfsParams);
        }
        long l = System.currentTimeMillis();
        float experimentTime = (float)(l - var2_2) / 1000.0f;
        System.out.println("*** MCFS-ID Processing is done. Time: " + GeneralUtils.timeIntervalFormat(experimentTime) + " ***");
        if (var1_1.verbose) {
            System.out.println(GeneralUtils.getMemStatus("G"));
        }
        System.out.println();
        return prunedArray;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame createPermutationResult(FArray inputArrray, MCFSParams mcfsParams) {
        void var3_4;
        FArray fArray;
        void var2_2;
        void var1_1;
        String[] colNames = new String[mcfsParams.cutoffPermutations + 1];
        short[] colTypes = new short[colNames.length];
        colNames[0] = "attribute";
        colTypes[0] = 0;
        for (int i = 1; i < colNames.length; ++i) {
            colNames[i] = "perm_" + i;
            colTypes[i] = 1;
        }
        FArray i = inputArrray;
        DataFrame permResult = new DataFrame(i.attributes.length - 1, colNames.length);
        permResult.setColNames((String[])var1_1);
        permResult.setColTypes((short[])var2_2);
        permResult.setColumn(0, fArray.getColNames(false));
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static double getCutoff(double alpha, double[] values) {
        void var0_1;
        void var2_2;
        void var3_3;
        double pValue = StatFunctions.andersonDarlingNormTest(values);
        System.out.println("Anderson-Darling normality test p-value = " + GeneralUtils.formatFloat((double)var3_3, 7));
        double[] confidence = StatFunctions.getConfidenceInterval(alpha, (double[])var2_2);
        System.out.println("Confidence Interval: " + GeneralUtils.formatFloat(confidence[0], 7) + " ; " + GeneralUtils.formatFloat(confidence[1], 7));
        return (double)var0_1[1];
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getCutoffValues(int[] cutoffValues) {
        int[] nArray;
        Integer[] integerArray;
        void var1_1;
        Arrays.sort(cutoffValues);
        HashSet<Integer> vset = new HashSet<Integer>();
        for (int i = 0; i < cutoffValues.length; ++i) {
            vset.add(cutoffValues[0]);
        }
        vset.removeAll(Arrays.asList(0));
        Integer[] tmpArray = new Integer[1];
        tmpArray = vset.toArray(tmpArray);
        cutoffValues = ArrayUtils.Integer2int(tmpArray);
        Arrays.sort(cutoffValues);
        vset.add(Math.round((float)cutoffValues[0] * 0.75f));
        vset.add(Math.round((float)cutoffValues[0] * 0.5f));
        vset.add(Math.round((float)cutoffValues[0] * 0.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.5f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 2.0f));
        integerArray = (Integer[])var1_1.toArray(integerArray);
        cutoffValues = ArrayUtils.Integer2int(integerArray);
        Arrays.sort(cutoffValues);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame calc_pValues$662b6a5a(DataFrame permutationRIValues, float[] valuesRI) {
        void var2_2;
        void var1_1;
        DataFrame dataFrame;
        String[] colNames = permutationRIValues.getColNames();
        boolean[] colNamesMask = new boolean[colNames.length];
        int permNumber = 0;
        for (int i = 0; i < colNames.length; ++i) {
            if (colNames[i].startsWith("perm_")) {
                colNamesMask[i] = true;
                ++permNumber;
                continue;
            }
            colNamesMask[i] = false;
        }
        float[] mean = new float[permutationRIValues.rows()];
        float[] normality_p = new float[permutationRIValues.rows()];
        float[] ttest_p = new float[permutationRIValues.rows()];
        for (int i = 0; i < permutationRIValues.rows(); ++i) {
            Object[] row = permutationRIValues.getRow(i);
            double[] permRI = new double[permNumber];
            int currPermIdx = 0;
            for (int j = 0; j < row.length; ++j) {
                if (!colNamesMask[j]) continue;
                permRI[currPermIdx++] = ((Float)row[j]).floatValue();
            }
            mean[i] = (float)MathUtils.mean(permRI);
            normality_p[i] = (float)StatFunctions.andersonDarlingNormTest(permRI);
            ttest_p[i] = (float)StatFunctions.tTestOneSample(permRI, valuesRI[i]);
        }
        DataFrame p_values = new DataFrame(dataFrame.rows(), 4);
        p_values.setColNames(new String[]{"mean", "RI_norm", "normality_test_p", "t_test_p"});
        p_values.setColTypes(new short[]{1, 1, 1, 1});
        p_values.setColumn(0, mean);
        p_values.setColumn(1, (float[])var1_1);
        p_values.setColumn(2, (float[])var2_2);
        p_values.setColumn(3, ttest_p);
        return p_values;
    }

    /*
     * WARNING - void declaration
     */
    private static void zipResult(MCFSParams mcfsParams) {
        String experimentName = mcfsParams.getExperimentName();
        String[] files = MCFSParams.getAllResultFileName(experimentName);
        try {
            void var1_1;
            MCFSParams mCFSParams;
            void var3_3;
            int i;
            FileOutputStream fos = new FileOutputStream(mcfsParams.resFilesPATH + File.separator + experimentName + ".zip");
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (i = 0; i < files.length; ++i) {
                FileUtils.addFileToZip(mcfsParams.resFilesPATH + File.separator + files[i], zos);
            }
            FileUtils.addFileToZip(mcfsParams.resFilesPATH + File.separator + experimentName + ".run", zos);
            zos.close();
            var3_3.close();
            for (i = 0; i < files.length; ++i) {
                FileUtils.deleteFile(mcfsParams.resFilesPATH + File.separator + files[i]);
            }
            FileUtils.deleteFile(mCFSParams.resFilesPATH + File.separator + (String)var1_1 + ".run");
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }
}

