/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.neural;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import weka.core.RevisionHandler;

public abstract class NeuralConnection
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -286208828571059163L;
    public static final int UNCONNECTED = 0;
    public static final int PURE_INPUT = 1;
    public static final int PURE_OUTPUT = 2;
    public static final int INPUT = 4;
    public static final int OUTPUT = 8;
    public static final int CONNECTED = 16;
    protected NeuralConnection[] m_inputList;
    protected NeuralConnection[] m_outputList;
    protected int[] m_inputNums;
    protected int[] m_outputNums;
    protected int m_numInputs;
    protected int m_numOutputs;
    protected double m_unitValue;
    protected double m_unitError;
    protected boolean m_weightsUpdated;
    protected String m_id;
    protected int m_type;
    protected double m_x;
    protected double m_y;

    public NeuralConnection(String id) {
        this.m_id = id;
        this.m_inputList = new NeuralConnection[0];
        this.m_outputList = new NeuralConnection[0];
        this.m_inputNums = new int[0];
        this.m_outputNums = new int[0];
        this.m_numInputs = 0;
        this.m_numOutputs = 0;
        this.m_unitValue = Double.NaN;
        this.m_unitError = Double.NaN;
        this.m_weightsUpdated = false;
        this.m_x = 0.0;
        this.m_y = 0.0;
        this.m_type = 0;
    }

    public String getId() {
        return this.m_id;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int t) {
        this.m_type = t;
    }

    public abstract void reset();

    public abstract double outputValue(boolean var1);

    public abstract double errorValue(boolean var1);

    public abstract void saveWeights();

    public abstract void restoreWeights();

    public double weightValue(int n) {
        return 1.0;
    }

    public void updateWeights(double l, double m) {
        if (!this.m_weightsUpdated) {
            int noa = 0;
            while (noa < this.m_numInputs) {
                this.m_inputList[noa].updateWeights(l, m);
                ++noa;
            }
            this.m_weightsUpdated = true;
        }
    }

    public NeuralConnection[] getInputs() {
        return this.m_inputList;
    }

    public NeuralConnection[] getOutputs() {
        return this.m_outputList;
    }

    public int[] getInputNums() {
        return this.m_inputNums;
    }

    public int[] getOutputNums() {
        return this.m_outputNums;
    }

    public double getX() {
        return this.m_x;
    }

    public double getY() {
        return this.m_y;
    }

    public void setX(double x) {
        this.m_x = x;
    }

    public void setY(double y) {
        this.m_y = y;
    }

    public boolean onUnit(Graphics g, int x, int y, int w, int h) {
        int m = (int)(this.m_x * (double)w);
        int c = (int)(this.m_y * (double)h);
        return x <= m + 10 && x >= m - 10 && y <= c + 10 && y >= c - 10;
    }

    public void drawNode(Graphics g, int w, int h) {
        if ((this.m_type & 8) == 8) {
            g.setColor(Color.orange);
        } else {
            g.setColor(Color.red);
        }
        g.fillOval((int)(this.m_x * (double)w) - 9, (int)(this.m_y * (double)h) - 9, 19, 19);
        g.setColor(Color.gray);
        g.fillOval((int)(this.m_x * (double)w) - 5, (int)(this.m_y * (double)h) - 5, 11, 11);
    }

    public void drawHighlight(Graphics g, int w, int h) {
        this.drawNode(g, w, h);
        g.setColor(Color.yellow);
        g.fillOval((int)(this.m_x * (double)w) - 5, (int)(this.m_y * (double)h) - 5, 11, 11);
    }

    public void drawInputLines(Graphics g, int w, int h) {
        g.setColor(Color.black);
        int px = (int)(this.m_x * (double)w);
        int py = (int)(this.m_y * (double)h);
        int noa = 0;
        while (noa < this.m_numInputs) {
            g.drawLine((int)(this.m_inputList[noa].getX() * (double)w), (int)(this.m_inputList[noa].getY() * (double)h), px, py);
            ++noa;
        }
    }

    public void drawOutputLines(Graphics g, int w, int h) {
        g.setColor(Color.black);
        int px = (int)(this.m_x * (double)w);
        int py = (int)(this.m_y * (double)h);
        int noa = 0;
        while (noa < this.m_numOutputs) {
            g.drawLine(px, py, (int)(this.m_outputList[noa].getX() * (double)w), (int)(this.m_outputList[noa].getY() * (double)h));
            ++noa;
        }
    }

    protected boolean connectInput(NeuralConnection i, int n) {
        int noa = 0;
        while (noa < this.m_numInputs) {
            if (i == this.m_inputList[noa]) {
                return false;
            }
            ++noa;
        }
        if (this.m_numInputs >= this.m_inputList.length) {
            this.allocateInputs();
        }
        this.m_inputList[this.m_numInputs] = i;
        this.m_inputNums[this.m_numInputs] = n;
        ++this.m_numInputs;
        return true;
    }

    protected void allocateInputs() {
        NeuralConnection[] temp1 = new NeuralConnection[this.m_inputList.length + 15];
        int[] temp2 = new int[this.m_inputNums.length + 15];
        int noa = 0;
        while (noa < this.m_numInputs) {
            temp1[noa] = this.m_inputList[noa];
            temp2[noa] = this.m_inputNums[noa];
            ++noa;
        }
        this.m_inputList = temp1;
        this.m_inputNums = temp2;
    }

    protected boolean connectOutput(NeuralConnection o, int n) {
        int noa = 0;
        while (noa < this.m_numOutputs) {
            if (o == this.m_outputList[noa]) {
                return false;
            }
            ++noa;
        }
        if (this.m_numOutputs >= this.m_outputList.length) {
            this.allocateOutputs();
        }
        this.m_outputList[this.m_numOutputs] = o;
        this.m_outputNums[this.m_numOutputs] = n;
        ++this.m_numOutputs;
        return true;
    }

    protected void allocateOutputs() {
        NeuralConnection[] temp1 = new NeuralConnection[this.m_outputList.length + 15];
        int[] temp2 = new int[this.m_outputNums.length + 15];
        int noa = 0;
        while (noa < this.m_numOutputs) {
            temp1[noa] = this.m_outputList[noa];
            temp2[noa] = this.m_outputNums[noa];
            ++noa;
        }
        this.m_outputList = temp1;
        this.m_outputNums = temp2;
    }

    protected boolean disconnectInput(NeuralConnection i, int n) {
        int loc = -1;
        boolean removed = false;
        do {
            loc = -1;
            int noa = 0;
            while (noa < this.m_numInputs) {
                if (i == this.m_inputList[noa] && (n == -1 || n == this.m_inputNums[noa])) {
                    loc = noa;
                    break;
                }
                ++noa;
            }
            if (loc < 0) continue;
            noa = loc + 1;
            while (noa < this.m_numInputs) {
                this.m_inputList[noa - 1] = this.m_inputList[noa];
                this.m_inputNums[noa - 1] = this.m_inputNums[noa];
                this.m_inputList[noa - 1].changeOutputNum(this.m_inputNums[noa - 1], noa - 1);
                ++noa;
            }
            --this.m_numInputs;
            removed = true;
        } while (n == -1 && loc != -1);
        return removed;
    }

    public void removeAllInputs() {
        int noa = 0;
        while (noa < this.m_numInputs) {
            this.m_inputList[noa].disconnectOutput(this, -1);
            ++noa;
        }
        this.m_inputList = new NeuralConnection[0];
        this.setType(this.getType() & 0xFFFFFFFB);
        if (this.getNumOutputs() == 0) {
            this.setType(this.getType() & 0xFFFFFFEF);
        }
        this.m_inputNums = new int[0];
        this.m_numInputs = 0;
    }

    protected void changeInputNum(int n, int v) {
        if (n >= this.m_numInputs || n < 0) {
            return;
        }
        this.m_inputNums[n] = v;
    }

    protected boolean disconnectOutput(NeuralConnection o, int n) {
        int loc = -1;
        boolean removed = false;
        do {
            loc = -1;
            int noa = 0;
            while (noa < this.m_numOutputs) {
                if (o == this.m_outputList[noa] && (n == -1 || n == this.m_outputNums[noa])) {
                    loc = noa;
                    break;
                }
                ++noa;
            }
            if (loc < 0) continue;
            noa = loc + 1;
            while (noa < this.m_numOutputs) {
                this.m_outputList[noa - 1] = this.m_outputList[noa];
                this.m_outputNums[noa - 1] = this.m_outputNums[noa];
                this.m_outputList[noa - 1].changeInputNum(this.m_outputNums[noa - 1], noa - 1);
                ++noa;
            }
            --this.m_numOutputs;
            removed = true;
        } while (n == -1 && loc != -1);
        return removed;
    }

    public void removeAllOutputs() {
        int noa = 0;
        while (noa < this.m_numOutputs) {
            this.m_outputList[noa].disconnectInput(this, -1);
            ++noa;
        }
        this.m_outputList = new NeuralConnection[0];
        this.m_outputNums = new int[0];
        this.setType(this.getType() & 0xFFFFFFF7);
        if (this.getNumInputs() == 0) {
            this.setType(this.getType() & 0xFFFFFFEF);
        }
        this.m_numOutputs = 0;
    }

    protected void changeOutputNum(int n, int v) {
        if (n >= this.m_numOutputs || n < 0) {
            return;
        }
        this.m_outputNums[n] = v;
    }

    public int getNumInputs() {
        return this.m_numInputs;
    }

    public int getNumOutputs() {
        return this.m_numOutputs;
    }

    public static boolean connect(NeuralConnection s, NeuralConnection t) {
        if (s == null || t == null) {
            return false;
        }
        NeuralConnection.disconnect(s, t);
        if (s == t) {
            return false;
        }
        if ((t.getType() & 1) == 1) {
            return false;
        }
        if ((s.getType() & 2) == 2) {
            return false;
        }
        if ((s.getType() & 1) == 1 && (t.getType() & 2) == 2) {
            return false;
        }
        if ((t.getType() & 2) == 2 && t.getNumInputs() > 0) {
            return false;
        }
        if ((t.getType() & 2) == 2 && (s.getType() & 8) == 8) {
            return false;
        }
        if (!s.connectOutput(t, t.getNumInputs())) {
            return false;
        }
        if (!t.connectInput(s, s.getNumOutputs() - 1)) {
            s.disconnectOutput(t, t.getNumInputs());
            return false;
        }
        if ((s.getType() & 1) == 1) {
            t.setType(t.getType() | 4);
        } else if ((t.getType() & 2) == 2) {
            s.setType(s.getType() | 8);
        }
        t.setType(t.getType() | 0x10);
        s.setType(s.getType() | 0x10);
        return true;
    }

    public static boolean disconnect(NeuralConnection s, NeuralConnection t) {
        if (s == null || t == null) {
            return false;
        }
        boolean stat1 = s.disconnectOutput(t, -1);
        boolean stat2 = t.disconnectInput(s, -1);
        if (stat1 && stat2) {
            if ((s.getType() & 1) == 1) {
                t.setType(t.getType() & 0xFFFFFFFB);
            } else if ((t.getType() & 2) == 2) {
                s.setType(s.getType() & 0xFFFFFFF7);
            }
            if (s.getNumInputs() == 0 && s.getNumOutputs() == 0) {
                s.setType(s.getType() & 0xFFFFFFEF);
            }
            if (t.getNumInputs() == 0 && t.getNumOutputs() == 0) {
                t.setType(t.getType() & 0xFFFFFFEF);
            }
        }
        return stat1 && stat2;
    }
}

