/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropLoopSet
extends Propagator<Variable> {
    private final GraphVar g;
    private final SetVar loops;

    public PropLoopSet(GraphVar graph, SetVar loops) {
        super(new Variable[]{graph, loops}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.loops = loops;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        ISet nodes = this.g.getPotentialNodes();
        ISetIterator iSetIterator = nodes.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getMandatorySuccessorsOf(i).contains(i)) {
                this.loops.force(i, this);
                continue;
            }
            if (!this.g.getPotentialSuccessorsOf(i).contains(i)) {
                this.loops.remove(i, this);
                continue;
            }
            if (this.loops.getLB().contains(i)) {
                this.g.enforceEdge(i, i, this);
                continue;
            }
            if (this.loops.getUB().contains(i)) continue;
            this.g.removeEdge(i, i, this);
        }
        iSetIterator = this.loops.getUB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (nodes.contains(i)) continue;
            this.loops.remove(i, this);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        ISetIterator iSetIterator = this.loops.getLB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getPotentialSuccessorsOf(i).contains(i)) continue;
            return ESat.FALSE;
        }
        iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (!this.g.getMandatorySuccessorsOf(i).contains(i) || this.loops.getUB().contains(i)) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

