/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.models.ModelModel;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class ModelBuilder
extends JDialog
implements ActionListener,
KeyListener,
MouseListener {
    protected JPanel varPanel;
    protected JScrollPane varScroller;
    protected JList varList;
    protected JPanel modelPanel;
    protected JButton contrasts;
    protected JButton poly;
    protected JButton more;
    protected JList outcomes;
    protected JScrollPane outcomeScroller;
    protected JPanel outcomePanel;
    protected JButton threeWay;
    protected JButton twoWay;
    protected JSeparator sep1;
    protected JButton in;
    protected JSeparator sep;
    protected JButton minus;
    protected JButton factorial;
    protected JButton interaction;
    protected JButton addMain;
    protected JButton remove;
    protected JList modelTerms;
    protected HelpButton help;
    protected OkayCancelPanel okayCancelPanel;
    protected JScrollPane modelScroller;
    protected DefaultListModel modelTermsModel;
    protected ModelModel model;

    public ModelBuilder(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
    }

    public ModelBuilder(JDialog jDialog, ModelModel modelModel) {
        super(jDialog);
        this.initGUI();
        this.setModel(modelModel);
    }

    public ModelBuilder(ModelModel modelModel) {
        this.initGUI();
        this.setModel(modelModel);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(916, 73, 7, 12, 0, 0, 2, 2));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.okayCancelPanel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.okayCancelPanel, new AnchorConstraint(927, 12, 7, 547, 0, 2, 2, 0));
            this.okayCancelPanel.setPreferredSize(new Dimension(350, 28));
            this.okayCancelPanel.getApproveButton().setText("Continue");
            this.varPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.varPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.varPanel, new AnchorConstraint(233, 365, 872, 20, 1, 1, 1, 1));
            this.varPanel.setBorder(BorderFactory.createTitledBorder("Variables"));
            this.varPanel.setPreferredSize(new Dimension(215, 302));
            this.varScroller = new JScrollPane();
            this.varPanel.add((Component)this.varScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.varList = new JList();
            this.varScroller.setViewportView(this.varList);
            this.varList.setModel(defaultListModel);
            this.modelPanel = new JPanel();
            borderLayout = new BorderLayout();
            this.modelPanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.modelPanel, new AnchorConstraint(233, 994, 872, 487, 1, 1, 1, 1));
            this.modelPanel.setBorder(BorderFactory.createTitledBorder("Model"));
            this.modelPanel.setPreferredSize(new Dimension(315, 302));
            this.modelScroller = new JScrollPane();
            this.modelPanel.add((Component)this.modelScroller, "Center");
            this.modelTermsModel = new DefaultListModel();
            this.modelTerms = new JList();
            this.modelScroller.setViewportView(this.modelTerms);
            this.modelTerms.setModel(this.modelTermsModel);
            this.modelTerms.addKeyListener(this);
            this.modelTerms.addMouseListener(this);
            this.modelTerms.setSelectionMode(2);
            this.remove = new JButton();
            this.getContentPane().add((Component)this.remove, new AnchorConstraint(869, 814, 916, 674, 1, 1, 0, 0));
            this.remove.setText("Remove");
            this.remove.setPreferredSize(new Dimension(87, 22));
            this.remove.addActionListener(this);
            this.addMain = new IconButton("/icons/edit_add_24.png", "Add main effect", null, "+");
            this.getContentPane().add((Component)this.addMain, new AnchorConstraint(383, 457, 459, 399, 1, 1, 0, 0));
            this.addMain.addActionListener(this);
            this.addMain.setPreferredSize(new Dimension(36, 36));
            this.sep = new JSeparator();
            this.getContentPane().add((Component)this.sep, new AnchorConstraint(472, 478, 485, 377, 1, 1, 0, 0));
            this.sep.setPreferredSize(new Dimension(63, 6));
            this.interaction = new IconButton("/icons/colon_24.png", "Add interaction effect", null, ":");
            this.getContentPane().add((Component)this.interaction, new AnchorConstraint(485, 457, 561, 399, 1, 1, 0, 0));
            this.interaction.setPreferredSize(new Dimension(36, 36));
            this.interaction.addActionListener(this);
            this.factorial = new IconButton("/icons/interaction_24.png", "Add factorial interaction", null, "*");
            this.getContentPane().add((Component)this.factorial, new AnchorConstraint(561, 457, 637, 399, 1, 1, 0, 0));
            this.factorial.setPreferredSize(new Dimension(36, 36));
            this.factorial.addActionListener(this);
            this.minus = new IconButton("/icons/edit_minus_24.png", "Add minus effect", null, "-");
            this.getContentPane().add((Component)this.minus, new AnchorConstraint(637, 457, 713, 399, 1, 1, 0, 0));
            this.minus.setPreferredSize(new Dimension(36, 36));
            this.minus.addActionListener(this);
            this.in = new IconButton("/icons/in_24.png", "Add Nested term", null, "in");
            this.getContentPane().add((Component)this.in, new AnchorConstraint(713, 457, 789, 399, 1, 1, 0, 0));
            this.in.setPreferredSize(new Dimension(36, 36));
            this.in.addActionListener(this);
            this.sep1 = new JSeparator();
            this.getContentPane().add((Component)this.sep1, new AnchorConstraint(366, 478, 371, 375, 1, 1, 0, 0));
            this.sep1.setPreferredSize(new Dimension(64, 2));
            this.twoWay = new JButton();
            this.getContentPane().add((Component)this.twoWay, new AnchorConstraint(248, 478, 294, 375, 1, 1, 0, 0));
            this.twoWay.setText("2-way");
            this.twoWay.setFont(new Font("Dialog", 0, 10));
            this.twoWay.setPreferredSize(new Dimension(64, 22));
            this.twoWay.addActionListener(this);
            this.threeWay = new JButton();
            this.getContentPane().add((Component)this.threeWay, new AnchorConstraint(307, 478, 354, 375, 1, 1, 0, 0));
            this.threeWay.setText("3-way");
            this.threeWay.setFont(new Font("Dialog", 0, 10));
            this.threeWay.setPreferredSize(new Dimension(64, 22));
            this.threeWay.addActionListener(this);
            this.outcomePanel = new JPanel();
            borderLayout = new BorderLayout();
            this.outcomePanel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.outcomePanel, new AnchorConstraint(13, 994, 233, 487, 1, 1, 1, 1));
            this.outcomePanel.setBorder(BorderFactory.createTitledBorder("Outcomes"));
            this.outcomePanel.setPreferredSize(new Dimension(315, 104));
            this.outcomeScroller = new JScrollPane();
            this.outcomePanel.add((Component)this.outcomeScroller, "Center");
            defaultListModel = new DefaultListModel();
            this.outcomes = new JList();
            this.outcomeScroller.setViewportView(this.outcomes);
            this.outcomes.setModel(defaultListModel);
            this.outcomes.addMouseListener(this);
            this.more = new JButton();
            this.getContentPane().add((Component)this.more, new AnchorConstraint(70, 259, 195, 58, 2, 0, 0, 2));
            this.more.setText("Specify");
            this.more.setPreferredSize(new Dimension(103, 22));
            this.more.addActionListener(this);
            this.poly = new JButton();
            this.getContentPane().add((Component)this.poly, new AnchorConstraint(802, 478, 848, 375, 1, 1, 0, 0));
            this.poly.setText("poly");
            this.poly.setPreferredSize(new Dimension(64, 22));
            this.poly.addActionListener(this);
            this.contrasts = new JButton();
            this.getContentPane().add((Component)this.contrasts, new AnchorConstraint(31, 259, 113, 58, 2, 0, 0, 2));
            this.contrasts.setText("Contrasts");
            this.contrasts.setPreferredSize(new Dimension(103, 22));
            this.setTitle("Model Builder");
            this.setSize(630, 507);
            this.contrasts.setVisible(false);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(ModelModel modelModel) {
        int n;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        String string = "";
        for (n = 0; n < modelModel.numericVars.getSize(); ++n) {
            string = !modelModel.numericVars.getElementAt(n).equals(RController.makeValidVariableName((String)((String)modelModel.numericVars.getElementAt(n)))) ? "`" + modelModel.numericVars.getElementAt(n) + "`" : (String)modelModel.numericVars.getElementAt(n);
            if (((REXPLogical)Deducer.timedEval("is.numeric(" + modelModel.data + "$" + string + ")")).isFALSE()[0]) {
                string = "as.numeric(" + string + ")";
            }
            defaultListModel.addElement(string);
        }
        for (n = 0; n < modelModel.factorVars.getSize(); ++n) {
            string = !modelModel.factorVars.getElementAt(n).equals(RController.makeValidVariableName((String)((String)modelModel.factorVars.getElementAt(n)))) ? "`" + modelModel.factorVars.getElementAt(n) + "`" : (String)modelModel.factorVars.getElementAt(n);
            if (((REXPLogical)Deducer.timedEval("is.factor(" + modelModel.data + "$" + string + ")")).isFALSE()[0]) {
                string = "as.factor(" + string + ")";
            }
            defaultListModel.addElement(string);
        }
        this.varList.setModel(defaultListModel);
        DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        for (int i = 0; i < modelModel.outcomes.getSize(); ++i) {
            string = (String)modelModel.outcomes.getElementAt(i);
            defaultListModel2.addElement(string);
        }
        this.outcomes.setModel(defaultListModel2);
        if (modelModel.terms.size() > 0) {
            this.modelTermsModel = modelModel.terms;
            this.modelTerms.setModel(this.modelTermsModel);
        } else {
            DefaultListModel defaultListModel3 = new DefaultListModel();
            for (int i = 0; i < defaultListModel.size(); ++i) {
                defaultListModel3.addElement(defaultListModel.elementAt(i));
            }
            this.modelTermsModel = defaultListModel3;
            this.modelTerms.setModel(this.modelTermsModel);
        }
        this.model = modelModel;
    }

    public void updateModel() {
        this.model.terms = this.modelTermsModel;
        this.model.outcomes = (DefaultListModel)this.outcomes.getModel();
    }

    public void editSelectedTerm() {
        String string = JOptionPane.showInputDialog(this.modelTerms, "Edit term", this.modelTerms.getSelectedValue());
        if (string != null) {
            if (this.modelTerms.getSelectedIndex() >= 0) {
                this.modelTermsModel.setElementAt(string, this.modelTerms.getSelectedIndex());
            } else {
                this.modelTermsModel.addElement(string);
            }
        }
    }

    public void editSelectedOutcome() {
        String string;
        if (this.outcomes.getSelectedIndex() >= 0 && (string = JOptionPane.showInputDialog(this.outcomes, "Edit  outcome term", this.outcomes.getSelectedValue())) != null) {
            ((DefaultListModel)this.outcomes.getModel()).setElementAt(string, this.outcomes.getSelectedIndex());
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int[] nArray;
        if ((keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) && (nArray = this.modelTerms.getSelectedIndices()) != null) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.modelTermsModel.remove(nArray[i]);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == this.modelTerms) {
            this.editSelectedTerm();
        } else if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == this.outcomes) {
            this.editSelectedOutcome();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "+") {
            Object[] objectArray = this.varList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.modelTermsModel.contains(objectArray[i])) continue;
                this.modelTermsModel.addElement((String)objectArray[i]);
            }
        } else if (string == "Remove") {
            int[] nArray = this.modelTerms.getSelectedIndices();
            if (nArray != null) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.modelTermsModel.remove(nArray[i]);
                }
            }
        } else if (string == ":") {
            Object[] objectArray = this.varList.getSelectedValues();
            if (objectArray == null || objectArray.length < 2) {
                JOptionPane.showMessageDialog(null, "Interaction (\":\") requires at least two variables.\nPlease select two or more variables");
                return;
            }
            String string2 = (String)objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + ":" + objectArray[i];
            }
            if (!this.modelTermsModel.contains(string2)) {
                this.modelTermsModel.addElement(string2);
            }
        } else if (string == "*") {
            Object[] objectArray = this.varList.getSelectedValues();
            if (objectArray == null || objectArray.length < 2) {
                JOptionPane.showMessageDialog(null, "Factorial interaction (\"*\") requires at least two variables.\nPlease select two or more variables");
                return;
            }
            String string3 = (String)objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = string3 + "*" + objectArray[i];
            }
            if (!this.modelTermsModel.contains(string3)) {
                this.modelTermsModel.addElement(string3);
            }
        } else if (string == "-") {
            Object[] objectArray = this.varList.getSelectedValues();
            if (objectArray == null || objectArray.length < 1) {
                JOptionPane.showMessageDialog(null, "Please select at least one variable");
                return;
            }
            String string4 = (String)objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                string4 = string4 + ":" + objectArray[i];
            }
            string4 = "-" + string4;
            if (!this.modelTermsModel.contains(string4)) {
                this.modelTermsModel.addElement(string4);
            }
        } else if (string == "2-way" || string == "3-way") {
            Object[] objectArray = this.varList.getSelectedValues();
            if (objectArray == null || objectArray.length < (string == "3-way" ? 3 : 2)) {
                JOptionPane.showMessageDialog(null, "Two way interactions require two or more variables.\nThree way interactions require three or more");
                return;
            }
            String string5 = (String)objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                string5 = string5 + "+" + objectArray[i];
            }
            string5 = "(" + string5 + ")^" + (string == "3-way" ? 3 : 2);
            if (!this.modelTermsModel.contains(string5)) {
                this.modelTermsModel.addElement(string5);
            }
        } else if (string == "in") {
            Object[] objectArray = this.varList.getSelectedValues();
            if (objectArray == null || objectArray.length != 2) {
                JOptionPane.showMessageDialog(null, "Please select two variables");
                return;
            }
            int n = JOptionPane.showOptionDialog(this.in, "Nesting", "Nesting", 2, 3, null, new String[]{objectArray[0] + " %in% " + objectArray[1], objectArray[1] + " %in% " + objectArray[0]}, null);
            String string6 = n == 0 ? objectArray[0] + " %in% " + objectArray[1] : objectArray[1] + " %in% " + objectArray[0];
            if (!this.modelTermsModel.contains(string6)) {
                this.modelTermsModel.addElement(string6);
            }
        } else if (string == "poly") {
            Object[] objectArray = this.varList.getSelectedValues();
            if (objectArray == null || objectArray.length != 1) {
                if (objectArray != null) {
                    this.varList.setSelectedIndices(new int[]{this.varList.getSelectedIndex()});
                }
                return;
            }
            String string7 = JOptionPane.showInputDialog(this.poly, "Polynomial Order", "Orthoginal Polynomials", 3);
            int n = 1;
            try {
                n = Integer.parseInt(string7);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.poly, "Invalid Order\nOrder must be a positive integer");
                return;
            }
            if (n < 1) {
                JOptionPane.showMessageDialog(this.poly, "Invalid Order\nOrder must be a positive integer");
                return;
            }
            String string8 = "poly(" + objectArray[0] + "," + n + ")";
            if (!this.modelTermsModel.contains(string8)) {
                this.modelTermsModel.addElement(string8);
            }
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Continue") {
            this.done();
        } else if (string == "Reset") {
            this.reset();
        } else if (string == "Specify") {
            this.specify();
        }
    }

    public void specify() {
    }

    public void done() {
    }

    public void reset() {
    }
}

