## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----rlnorm-plot--------------------------------------------------------------
library(tidychangepoint)

## -----------------------------------------------------------------------------
x <- segment(DataCPSim, method = "pelt")
class(x)

## -----------------------------------------------------------------------------
changepoints(x)

## -----------------------------------------------------------------------------
augment(x)

## -----------------------------------------------------------------------------
tidy(x)

## -----------------------------------------------------------------------------
glance(x)

## ----pelt-plot----------------------------------------------------------------
plot(x)

## -----------------------------------------------------------------------------
fitness(x)

## -----------------------------------------------------------------------------
x |>
  as.segmenter() |>
  str()

## -----------------------------------------------------------------------------
x |>
  as.model() |>
  str()

