/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.R;

import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.DataTable;
import eu.kliegr.ac1.rule.AttributeNotFoundException;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.parsers.ArulesParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class Rinterface {
    private static final Logger LOGGER = Logger.getLogger(Rinterface.class.getName());
    Data data = new Data();
    ArrayList<Rule> rules;
    ArrayList<AttributeType> att_types;
    String targetColName;
    String IDcolumnName;

    public Rinterface(String[] att_types, String targetColName, String IDcolumnName, String loglevel) throws Exception {
        System.gc();
        ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
        this.setLoggerLevelGlobaly(Level.parse(loglevel));
        for (String atttype : att_types) {
            attributeTypes.add(AttributeType.valueOf(atttype));
        }
        if (IDcolumnName.isEmpty()) {
            IDcolumnName = null;
        }
        this.att_types = attributeTypes;
        this.targetColName = targetColName;
        this.IDcolumnName = IDcolumnName;
        LOGGER.info("Init finished");
    }

    public void addDataFrame(Object[] dataFrame, String[] cNames) throws Exception {
        if (this.data.getDataTable() != null) {
            throw new Exception("DataTable already set");
        }
        LOGGER.info("addDataFrame");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "attTypes:{0}", this.att_types.stream().map(i -> i.toString()).collect(Collectors.joining(", ")));
            LOGGER.log(Level.FINE, "cnames:{0}", Arrays.toString(cNames));
        }
        DataTable dataTable = this.data.newDataTable(cNames, this.targetColName, this.att_types, this.IDcolumnName);
        int columns = dataFrame.length;
        LOGGER.log(Level.FINE, "columns:{0}", columns);
        if (columns > 0) {
            int rows = ((String[])dataFrame[0]).length;
            LOGGER.log(Level.FINE, "rows:{0}", rows);
            for (int i2 = 0; i2 < rows; ++i2) {
                String[] row = new String[columns];
                for (int j = 0; j < columns; ++j) {
                    row[j] = ((String[])dataFrame[j])[i2];
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "col:''{0}''value:''{1}'' atttype:''{2}''", new Object[]{cNames[j], row[j], this.att_types.get(j)});
                }
                LOGGER.log(Level.FINE, "Row length:{0}", row.length);
                dataTable.addTransaction(row);
                continue;
            }
        }
        LOGGER.info("addDataFrame finished");
    }

    private void setLoggerLevelGlobaly(Level level) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.setLevel(level);
        for (Handler h : rootLogger.getHandlers()) {
            h.setLevel(level);
        }
    }

    public String[] testFrame2() {
        String[] df = new String[]{"rule 1", "confidence 1", "support 1"};
        return df;
    }

    public void testFrame3() {
    }

    public String[][] _getRules() {
        String[][] df = new String[3][2];
        df[0][0] = "rule 1";
        df[1][0] = "confidence 1";
        df[2][0] = "support 1";
        df[0][1] = "rule 1";
        df[1][1] = "confidence 1";
        df[2][1] = "support 1";
        return df;
    }

    public void addRuleFrame(Object[] dataFrame) throws AttributeNotFoundException, Exception {
        if (this.rules != null) {
            throw new Exception("Rules already added");
        }
        try {
            this.rules = new ArrayList();
            LOGGER.info("addRuleFrame");
            int columns = dataFrame.length;
            LOGGER.log(Level.FINE, "Columns={0}", dataFrame.length);
            ArulesParser parser = new ArulesParser(this.data);
            if (columns > 0) {
                int rows = ((String[])dataFrame[0]).length;
                for (int i = 0; i < rows; ++i) {
                    String rule = ((String[])dataFrame[0])[i];
                    double confidence = dataFrame[2] instanceof double[] ? ((double[])dataFrame[2])[i] : (double)((int[])dataFrame[2])[i];
                    double support = dataFrame[1] instanceof double[] ? ((double[])dataFrame[1])[i] : (double)((int[])dataFrame[1])[i];
                    LOGGER.log(Level.INFO, "Rule  {0}, confidence={1} support={2}", new Object[]{rule, confidence, support});
                    Rule r = parser.parseRule(rule, (float)confidence, (float)support, i);
                    LOGGER.info(r.toString());
                    this.rules.add(r);
                }
            }
            LOGGER.info("addRuleFrame finished");
        }
        catch (Exception e) {
            LOGGER.severe(e.toString());
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

