## ----include = FALSE----------------------------------------------------------
library(knitr)
opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(rmarkdown.html_vignette.check_title = FALSE)

## ----setup--------------------------------------------------------------------
library(groupedHyperframe.random)

## ----echo = FALSE, results = 'asis'-------------------------------------------
c(
  '', 'Forward pipe operator', '`?base::pipeOp` introduced in `R` 4.1.0', 
  '`CRAN`, `R`', 'The Comprehensive R Archive Network', 'https://cran.r-project.org',
  '`coords`', '$x$- and $y$-coordinates', '`spatstat.geom:::ppp`',
  '`diag`', 'Diagonal matrix', '`base::diag`',
  '`groupedHyperframe`', 'Grouped hyper data frame', '`groupedHyperframe::as.groupedHyperframe`',
  '`hypercolumns`, `hyperframe`', '(Hyper columns of) hyper data frame', '`spatstat.geom::hyperframe`',
  '`marks`, `marked`', '(Having) mark values', '`spatstat.geom::is.marked`',
  '`pmax`', 'Parallel maxima', '`base::pmax`',
  '`ppp`, `ppp.object`', 'Point pattern', '`spatstat.geom::ppp.object`',
  '`recycle`', 'Recycling', 'https://r4ds.had.co.nz/vectors.html#scalars-and-recycling-rules',  
  '`rlnorm`', 'Log normal random variable', '`stats::rlnorm`', 
  '`rMatClust`', 'Matern\'s cluster process', '`spatstat.random::rMatClust`',
  '`rmvnorm_`', 'Multivariate normal random variable', '`groupedHyperframe.random::rmvnorm_`; `MASS::mvrnorm`',
  '`rnbinom`', 'Negative binomial random variable', '`stats::rnbinom`',
  '`rpoispp`', 'Poisson point pattern', '`spatstat.random::rpoispp`',
#  '`rStrauss`', 'Strauss process', '`spatstat.random::rStrauss`',
  '`superimpose`', 'Superimpose', '`spatstat.geom::superimpose`',
  '`var`, `cor`, `cov`', 'Variance, correlation, covariance', '`stats::var`, `stats::cor`, `stats::cov`'
) |>
  matrix(nrow = 3L, dimnames = list(c('Term / Abbreviation', 'Description', 'Reference'), NULL)) |>
  t.default() |>
  as.data.frame.matrix() |> 
  kable()

## -----------------------------------------------------------------------------
set.seed(125); r = .rppp(rMatClust(kappa = c(10, 5), mu = c(8, 4), scale = c(.15, .06)))
# plot(r) # suppressed for aesthetics

## -----------------------------------------------------------------------------
set.seed(125); r1 = .rppp(
  rMatClust(kappa = c(10, 5), mu = c(8, 4), scale = c(.15, .06)), 
  rlnorm(meanlog = c(3, 5), sdlog = c(.4, .2)),
  rnbinom(size = 4, prob = .3) # shorter parameter recycled
)

## -----------------------------------------------------------------------------
set.seed(62); r2 = .rppp(
  rpoispp(lambda = c(3, 6)),
  rlnorm(meanlog = c(3, 5), sdlog = c(.4, .2)),
  rnbinom(size = c(4, 6), prob = c(.3, .1))
)

## -----------------------------------------------------------------------------
spatstat.geom::superimpose(r1, r2)

## -----------------------------------------------------------------------------
(p = data.frame(kappa = c(3,2), scale = c(.4,.2), mu = c(10,5), 
                meanlog = c(3,5), sdlog = c(.4,.2)))

## -----------------------------------------------------------------------------
set.seed(39); (p. = rmvnorm_(n = 3L, mu = p, Sigma = list(
  kappa = .2^2, scale = .05^2, mu = .5^2, 
  meanlog = .1^2, sdlog = .01^2)) |> 
    within.list(expr = {
      kappa = pmax(kappa, 1 + .Machine$double.eps)
      mu = pmax(mu, 1 + .Machine$double.eps)
      scale = pmax(scale, .Machine$double.eps)
      sdlog = pmax(sdlog, .Machine$double.eps)
    }))

## -----------------------------------------------------------------------------
set.seed(37); (n = sample.int(n = 4L, size = 3L, replace = TRUE)) 

## -----------------------------------------------------------------------------
set.seed(76); (r = p. |> 
  with.default(expr = {
    grouped_rppp(
      rMatClust(kappa = kappa, scale = scale, mu = mu), 
      rlnorm(meanlog = meanlog, sdlog = sdlog),
      n = n
    )
  }))

