## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(Sys.getenv("NOT_CRAN"), "true")
)

## ----setup, warning=FALSE-----------------------------------------------------
# library(fwtraits)
# library(ggplot2)

## ----data---------------------------------------------------------------------
# data("speciesdata")
# 
# set.seed(1135)
# speciesdata$abund <- rnorm(n = nrow(speciesdata), 4.3, 1.2)
# 
# #species with geographical coordinates
# 
# geospdata <- speciesdata |>
#   sf::st_as_sf(coords = c('decimalLongitude', 'decimalLatitude'),
#                crs = sf::st_crs(4326))
# 

## ----retrievedata-------------------------------------------------------------
# 
# fishtraits <- fw_fetchdata(data = speciesdata,
#                          ecoparams = c('rheophily habitat', 'spawning habitat',
#                                        'feeding diet adult'),
#                          taxonomic_column = 'scientificName',
#                          organismgroup = 'fi')

## ----commputefdindies---------------------------------------------------------
# 
# #fd indices calculated when abundance  is provided.
# 
# fdindices <- fw_fdcompute(fwdata = fishtraits,
#                         sitesdata = speciesdata,
#                         sites = 'waterBody',
#                         species = 'scientificName',
#                         abund = 'abund',
#                         FD = TRUE)
# head(fdindices, 3)
# 
# #functional richness only: when abundance is not provided.
# fdric<- fw_fdcompute(fwdata = fishtraits,
#                         sitesdata = speciesdata,
#                         sites = 'waterBody',
#                         species = 'scientificName',
#                         FD = TRUE)
# head(fdric, 3)

## ----commputefdspatial--------------------------------------------------------
# 
# #fd indices calculated when abundance  is provided.
# 
# geofdind <- fw_fdcompute(fwdata = fishtraits,
#                         sitesdata = geospdata,
#                         species = 'scientificName',
#                         abund = 'abund',
#                         FD = TRUE)
# head(geofdind, 3)
# 
# #functional richness only: when abundance is not provided.
# geofd <- fw_fdcompute(fwdata = fishtraits,
#                         sitesdata = geospdata,
#                         species = 'scientificName',
#                         FD = TRUE)
# head(geofd, 3)

## ----viz, fig.width = 7, fig.height= 4, fig.align='center', warning=FALSE-----
# 
# df <- fdindices |> tidyr::gather('fdind', "vals", -site)
# 
# ggplot(data = df, aes(site, vals, fill = fdind))+
#   geom_bar(stat = 'identity')+
#   scale_fill_viridis_d()+
#   theme(legend.position = "none",
#         axis.text.x = element_text(angle = 45, hjust = 1, size = 7))+
#   facet_wrap(~fdind, scales ='free_y')+
#   scale_y_continuous(expand = expansion(mult = c(0, 0.1)))+
#   labs(x='sites', y='FD indices')
# 
# #Functional richness
# 
# dffric <- fdric |> tidyr::gather('fdind', "vals", -site)
# 
# ggplot(data = dffric, aes(site, vals, fill = fdind))+
#   geom_bar(stat = 'identity')+
#   scale_fill_viridis_d()+
#   theme(legend.position = "none",
#         axis.text.x = element_text(angle = 45, hjust = 1, size = 7))+
#   facet_wrap(~fdind, scales ='free_y')+
#   scale_y_continuous(expand = expansion(mult = c(0, 0.1)))+
#   labs(x='Sites', y='FD indices')
# 

## ----cmwmeans-----------------------------------------------------------------
# cwmdata <- fw_fdcompute(fwdata = fishtraits,
#                         sitesdata = speciesdata,
#                         sites = 'waterBody',
#                         species = 'scientificName',
#                         abund = 'abund',
#                         FD = FALSE)
# head(cwmdata, 3)

## ----cwmeansnodummy-----------------------------------------------------------
# cwmdata2 <- fw_fdcompute(fwdata = fishtraits,
#                         sitesdata = speciesdata,
#                         sites = 'waterBody',
#                         species = 'scientificName',
#                         abund = 'abund',
#                         FD = FALSE, dummy = FALSE)
# head(cwmdata2, 3)

