/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import java.util.Arrays;
import org.chocosolver.util.tools.ArrayUtils;

public class SmallestEnclosingCircle {
    int[] pointsArray;
    double[][] coordinates;
    int[] shuffledPoints;
    double centerX;
    double centerY;
    double radius;

    public SmallestEnclosingCircle(int[] pointsArray, double[][] coordinates) {
        this.coordinates = coordinates;
        this.init(pointsArray);
    }

    public void init(int[] pointsArray) {
        this.pointsArray = pointsArray;
        this.shuffledPoints = Arrays.copyOf(pointsArray, pointsArray.length);
        ArrayUtils.randomPermutations(this.shuffledPoints, System.currentTimeMillis());
        double[] minidisk = SmallestEnclosingCircle.minidisk(this.shuffledPoints, this.coordinates);
        if (minidisk.length > 0) {
            this.centerX = minidisk[0];
            this.centerY = minidisk[1];
            this.radius = minidisk[2];
        }
    }

    public double[] addPoint(double[] pi) {
        int nbPoints = this.pointsArray.length + 1;
        if (nbPoints == 1) {
            double[] center = pi;
            return new double[]{center[0], center[1], 0.0};
        }
        if (nbPoints == 2) {
            System.out.println("YOYOYO");
            double[] p1 = this.coordinates[this.pointsArray[0]];
            double[] p2 = pi;
            double[] center = SmallestEnclosingCircle.midpoint(p1, p2);
            return new double[]{center[0], center[1], SmallestEnclosingCircle.distance(p1, p2) / 2.0};
        }
        if (SmallestEnclosingCircle.distance(this.getCenter(), pi) > this.radius) {
            double[] p1 = this.coordinates[this.shuffledPoints[0]];
            double[] center = SmallestEnclosingCircle.midpoint(p1, pi);
            double r = SmallestEnclosingCircle.distance(p1, pi) / 2.0;
            for (int j = 1; j < this.shuffledPoints.length; ++j) {
                double[] pj = this.coordinates[this.shuffledPoints[j]];
                if (!(SmallestEnclosingCircle.distance(center, pj) > r)) continue;
                double[] circle = SmallestEnclosingCircle.b_minidisk_two(this.coordinates, this.shuffledPoints, pi, j);
                center[0] = circle[0];
                center[1] = circle[1];
                r = circle[2];
            }
            return new double[]{center[0], center[1], r};
        }
        return new double[]{this.centerX, this.centerY, this.radius};
    }

    public double[] getCenter() {
        return new double[]{this.centerX, this.centerY};
    }

    private static final double[] minidisk(int[] pointsArray, double[][] coordinates) {
        int nbPoints = pointsArray.length;
        if (nbPoints == 0) {
            return new double[0];
        }
        if (nbPoints == 1) {
            double[] center = coordinates[pointsArray[0]];
            return new double[]{center[0], center[1], 0.0};
        }
        if (nbPoints == 2) {
            int i = pointsArray[0];
            int j = pointsArray[1];
            double[] p1 = coordinates[i];
            double[] p2 = coordinates[j];
            double[] center = SmallestEnclosingCircle.midpoint(p1, p2);
            return new double[]{center[0], center[1], SmallestEnclosingCircle.distance(p1, p2) / 2.0};
        }
        double[] p1 = coordinates[pointsArray[0]];
        double[] p2 = coordinates[pointsArray[1]];
        double[] center = SmallestEnclosingCircle.midpoint(p1, p2);
        double r = SmallestEnclosingCircle.distance(p1, p2) / 2.0;
        for (int i = 2; i < pointsArray.length; ++i) {
            double[] pi = coordinates[pointsArray[i]];
            if (!(SmallestEnclosingCircle.distance(center, pi) > r)) continue;
            double[] circle = SmallestEnclosingCircle.b_minidisk_one(coordinates, pointsArray, i);
            center[0] = circle[0];
            center[1] = circle[1];
            r = circle[2];
        }
        return new double[]{center[0], center[1], r};
    }

    private static final double[] b_minidisk_one(double[][] coordinates, int[] shuffled, int i) {
        double[] p1 = coordinates[shuffled[0]];
        double[] pi = coordinates[shuffled[i]];
        double[] center = SmallestEnclosingCircle.midpoint(p1, pi);
        double r = SmallestEnclosingCircle.distance(p1, pi) / 2.0;
        for (int j = 1; j < i; ++j) {
            double[] pj = coordinates[shuffled[j]];
            if (!(SmallestEnclosingCircle.distance(center, pj) > r)) continue;
            double[] circle = SmallestEnclosingCircle.b_minidisk_two(coordinates, shuffled, pi, j);
            center[0] = circle[0];
            center[1] = circle[1];
            r = circle[2];
        }
        return new double[]{center[0], center[1], r};
    }

    private static final double[] b_minidisk_two(double[][] coordinates, int[] shuffled, double[] pi, int j) {
        double[] pj = coordinates[shuffled[j]];
        double[] center = SmallestEnclosingCircle.midpoint(pi, pj);
        double r = SmallestEnclosingCircle.distance(pi, pj) / 2.0;
        for (int k = 0; k < j; ++k) {
            double[] pk = coordinates[shuffled[k]];
            if (!(SmallestEnclosingCircle.distance(center, pk) > r)) continue;
            double[] circle = SmallestEnclosingCircle.circumcircle(pi, pj, pk);
            center[0] = circle[0];
            center[1] = circle[1];
            r = circle[2];
        }
        return new double[]{center[0], center[1], r};
    }

    public static final double[] vector(double[] p1, double[] p2) {
        return new double[]{p1[0] + p2[0], p1[1] + p2[1]};
    }

    public static final double[] midpoint(double[] p1, double[] p2) {
        double[] v = SmallestEnclosingCircle.vector(p1, p2);
        return new double[]{v[0] / 2.0, v[1] / 2.0};
    }

    public static final double distance(double[] p1, double[] p2) {
        return Math.sqrt(Math.pow(p1[0] - p2[0], 2.0) + Math.pow(p1[1] - p2[1], 2.0));
    }

    public static final double[] circumcircle(double[] a, double[] b, double[] c) {
        double d = 2.0 * (a[0] * (b[1] - c[1]) + b[0] * (c[1] - a[1]) + c[0] * (a[1] - b[1]));
        double cx = ((Math.pow(a[0], 2.0) + Math.pow(a[1], 2.0)) * (b[1] - c[1]) + (Math.pow(b[0], 2.0) + Math.pow(b[1], 2.0)) * (c[1] - a[1]) + (Math.pow(c[0], 2.0) + Math.pow(c[1], 2.0)) * (a[1] - b[1])) / d;
        double cy = ((Math.pow(a[0], 2.0) + Math.pow(a[1], 2.0)) * (c[0] - b[0]) + (Math.pow(b[0], 2.0) + Math.pow(b[1], 2.0)) * (a[0] - c[0]) + (Math.pow(c[0], 2.0) + Math.pow(c[1], 2.0)) * (b[0] - a[0])) / d;
        double cr = SmallestEnclosingCircle.distance(new double[]{cx, cy}, a);
        return new double[]{cx, cy, cr};
    }
}

