main_ui_two_mean_size <- function(test_type) {
  withMathJax(
    tagList(
      h4("Result"),
      tags$div(
        style = "font-size: 24px; font-weight: bold;",
        textOutput("result")
      ),
      hr(),
      switch(test_type,
             "2-side" = tagList(
               h4("Calculate Sample Size Needed to Compare 2 Means: 2-Sample, 2-Sided Equality"),
               p("This calculator is useful for tests concerning whether the means of two groups are different. Suppose the two groups are 'A' and 'B', and we collect a sample from both groups -- i.e. we have two samples. We perform a two-sample test to determine whether the mean in group A, \\(\\mu_A\\), is different from the mean in group B, \\(\\mu_B\\). The hypotheses are"),
               p("$$H_0:\\mu_A-\\mu_B=0$$"),
               p("$$H_1:\\mu_A-\\mu_B\\neq0$$"),
               p("where the ratio between the sample sizes of the two groups is"),
               p("$$\\kappa=\\frac{n_A}{n_B}$$"),
               h4("Formulas"),
               p("This calculator uses the following formulas to compute sample size and power, respectively:"),
               p("$$ n_A=\\kappa n_B \\;\\text{ and }\\; n_B=\\left(1+\\frac{1}{\\kappa}\\right) \\left(\\sigma\\frac{z_{1-\\alpha/2}+z_{1-\\beta}}{\\mu_A-\\mu_B}\\right)^2$$"),
               p("$$1-\\beta= \\Phi\\left(z-z_{1-\\alpha/2}\\right)+\\Phi\\left(-z-z_{1-\\alpha/2}\\right) \\quad ,\\quad z=\\frac{\\mu_A-\\mu_B}{\\sigma\\sqrt{\\frac{1}{n_A}+\\frac{1}{n_B}}}$$"),
               p("where"),
               p("\\(\\kappa=n_A/n_B\\) is the matching ratio"),
               p("\\(\\sigma\\) is standard deviation"),
               p("\\(\\Phi\\) is the standard Normal distribution function"),
               p("\\(\\Phi^{-1}\\) is the standard Normal quantile function"),
               p("\\(\\alpha\\) is Type I error"),
               p("\\(\\beta\\) is Type II error, meaning \\(1 - \\beta\\) is power")
             ),
             "1-side" = tagList(
               h4("Calculate Sample Size Needed to Compare 2 Means: 2-Sample, 1-Sided"),
               p("This calculator is useful for tests concerning whether the means of two groups are different. Suppose the two groups are 'A' and 'B', and we collect a sample from both groups -- i.e. we have two samples. We perform a two-sample test to determine whether the mean in group A, \\(\\mu_A\\), is different from the mean in group B, \\(\\mu_B). The hypotheses are"),
               p("$$H_0:\\mu_A=\\mu_B$$"),
               p("$$H_1:\\mu_A\\lt \\mu_B$$"),
               p("or"),
               p("$$H_0:\\mu_A=\\mu_B$$"),
               p("$$H_1:\\mu_A\\gt \\mu_B$$"),
               p("where the ratio between the sample sizes of the two groups is"),
               p("$$\\kappa=\\frac{n_B}{n_A}$$"),
               h4("Formulas"),
               p("This calculator uses the following formulas to compute sample size and power, respectively:"),
               p("$$n_A=\\left(\\sigma_A^2+\\sigma_B^2/\\kappa\\right)\\left(\\frac{z_{1-\\alpha}+z_{1-\\beta}}{\\mu_A-\\mu_B}\\right)^2$$"),
               p("$$n_B=\\kappa n_A$$"),
               p("$$1-\\beta=\\Phi\\left(\\frac{|\\mu_A-\\mu_B|\\sqrt{n_A}}{\\sqrt{\\sigma_A^2+\\sigma_B^2/\\kappa}}-z_{1-\\alpha}\\right)$$"),
               p("where"),
               p("\\(\\kappa=n_A/n_B\\) is the matching ratio"),
               p("\\(\\sigma\\) is standard deviation"),
               p("\\(\\sigma_A\\) is standard deviation of Group \"A\""),
               p("\\(\\sigma_B\\) is standard deviation of Group \"B\""),
               p("\\(\\Phi\\) is the standard Normal distribution function"),
               p("\\(\\Phi^{-1}\\) is the standard Normal quantile function"),
               p("\\(\\alpha\\) is Type I error"),
               p("\\(\\beta\\) is Type II error, meaning \\(1 - \\beta\\) is power")
             ),
             "non-inferiority" = tagList(
               h4("Calculate Sample Size Needed to Compare 2 Means: 2-Sample Non-Inferiority or Superiority"),
               p("This calculator is useful for the types of tests known as non-inferiority and superiority tests. Whether the null hypothesis represents 'non-inferiority' or 'superiority' depends on the context and whether the non-inferiority/superiority margin, \\(\\delta\\), is positive or negative. In this setting, we wish to test whether the mean in group 'A', \\(\\mu_A\\), is non-inferior/superior to the mean in group 'B', \\(\\mu_B\\). We collect a sample from both groups, and thus will conduct a two-sample test. The idea is that statistically significant differences between the means may not be of interest unless the difference is greater than a threshold, \\(\\delta\\). This is particularly popular in clinical studies, where the margin is chosen based on clinical judgement and subject-domain knowledge. The hypotheses to test are"),
               p("$$H_0:\\mu_A-\\mu_B\\le\\delta$$"),
               p("$$H_1:\\mu_A-\\mu_B>\\delta$$"),
               p("where \\(\\delta\\) is the superiority or non-inferiority margin and the ratio between the sample sizes of the two groups is"),
               p("$$\\kappa=\\frac{n_A}{n_B}$$"),
               h4("Formulas"),
               p("This calculator uses the following formulas to compute sample size and power, respectively:"),
               p("$$ n_A=\\kappa n_B \\;\\text{ and }\\; n_B=\\left(1+\\frac{1}{\\kappa}\\right) \\left(\\sigma\\frac{z_{1-\\alpha}+z_{1-\\beta}}{\\mu_A-\\mu_B-\\delta}\\right)^2$$"),
               p("$$1-\\beta= \\Phi\\left(z-z_{1-\\alpha}\\right)+\\Phi\\left(-z-z_{1-\\alpha}\\right) \\quad ,\\quad z=\\frac{\\mu_A-\\mu_B-\\delta}{\\sigma\\sqrt{\\frac{1}{n_A}+\\frac{1}{n_B}}}$$"),
               p("where"),
               p("\\(\\kappa=n_A/n_B\\) is the matching ratio"),
               p("\\(\\sigma\\) is standard deviation"),
               p("\\(\\Phi\\) is the standard Normal distribution function"),
               p("\\(\\Phi^{-1}\\) is the standard Normal quantile function"),
               p("\\(\\alpha\\) is Type I error"),
               p("\\(\\beta\\) is Type II error, meaning \\(1 - \\beta\\) is power"),
               p("\\(\\delta\\) ins the testing margin")
             ),
             "equivalence" = tagList(
               h4("Calculate Sample Size Needed to Compare 2 Means: 2-Sample Equivalence"),
               p("This calculator is useful when we wish to test whether the means of two groups are equivalent, without concern of which group's mean is larger. Suppose we collect a sample from a group 'A' and a group 'B'; that is we collect two samples, and will conduct a two-sample test. For example, we may wish to test whether a new product is equivalent to an existing, industry standard product. Here, the 'burden of proof', so to speak, falls on the new product; that is, equivalence is actually represented by the alternative, rather than the null hypothesis."),
               p("$$H_0:|\\mu_A-\\mu_B|\\ge\\delta$$"),
               p("$$H_1:|\\mu_A-\\mu_B|<\\delta$$"),
               p("where \\(\\delta\\) is the superiority or non-inferiority margin and the ratio between the sample sizes of the two groups is"),
               p("$$\\kappa=\\frac{n_1}{n_2}$$"),
               h4("Formulas"),
               p("This calculator uses the following formulas to compute sample size and power, respectively:"),
               p("$$ n_A=\\kappa n_B \\;\\text{ and }\\; n_B=\\left(1+\\frac{1}{\\kappa}\\right) \\left(\\sigma\\frac{z_{1-\\alpha}+z_{1-\\beta/2}}{|\\mu_A-\\mu_B|-\\delta}\\right)^2$$"),
               p("$$1-\\beta= 2\\left[\\Phi\\left(z-z_{1-\\alpha}\\right)+\\Phi\\left(-z-z_{1-\\alpha}\\right)\\right]-1 \\quad ,\\quad z=\\frac{|\\mu_A-\\mu_B|-\\delta}{\\sigma\\sqrt{\\frac{1}{n_A}+\\frac{1}{n_B}}}$$"),
               p("where"),
               p("\\(\\kappa=n_A/n_B\\) is the matching ratio"),
               p("\\(\\sigma\\) is standard deviation"),
               p("\\(\\Phi\\) is the standard Normal distribution function"),
               p("\\(\\Phi^{-1}\\) is the standard Normal quantile function"),
               p("\\(\\alpha\\) is Type I error"),
               p("\\(\\beta\\) is Type II error, meaning \\(1 - \\beta\\) is power"),
               p("\\(\\delta\\) ins the testing margin")
             )
      )
    )
  )
}
