% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_tarball.R
\name{extract_tarball}
\alias{extract_tarball}
\title{Extract tarball of a package into temp directory and return path to extracted
package}
\usage{
extract_tarball(tarball)
}
\arguments{
\item{tarball}{Full path to local tarball of an R package.}
}
\value{
Path to extracted version of package (in \code{tempdir()}).
}
\description{
Extract tarball of a package into temp directory and return path to extracted
package
}
\examples{
\dontrun{
tarball <- "magrittr_2.0.1.tar.gz"
u <- paste0 (
    "https://cran.r-project.org/src/contrib/",
    tarball
)
f <- file.path (tempdir (), tarball)
download.file (u, f)
path <- extract_tarball (f)
}
}
\concept{misc}
