/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo;

public class TimeLimit {
    private double tl;
    private TimeLimit parent;

    public TimeLimit(double tl) {
        if (tl < 0.0) {
            throw new IllegalArgumentException();
        }
        this.tl = tl;
    }

    private TimeLimit(TimeLimit parent, double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.tl = parent.getRemainingTime() * fraction;
    }

    public void spend(double time) {
        this.tl -= time;
        if (this.parent != null) {
            this.parent.spend(time);
        }
    }

    public TimeLimit subLimit(double fraction) {
        return new TimeLimit(this, fraction);
    }

    public double getRemainingTime() {
        return this.tl;
    }
}

