/**
 * SciAnimator - Scientific Image Animator Plugin for jQuery
 *
 * Copyright (c) 2010 Brent Ertz
 * Released under the MIT license.
 * http://github.com/brentertz/scianimator
*/
(function(e){var c={CONTROLS_ALL:"all",CONTROLS_NONE:"none",DIRECTION_FORWARD:0,DIRECTION_REVERSE:1,LOOP_MODE_NONE:"none",LOOP_MODE_LOOP:"loop",LOOP_MODE_SWEEP:"sweep",PLAY_MODE_STOPPED:0,PLAY_MODE_PLAYING:1,POSITION_TOP:0,POSITION_BOTTOM:1};e.fn.scianimator=function(g){if(b[g]){return b[g].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof g==="object"||!g){return b.init.apply(this,arguments)}else{e.error("Method "+g+" does not exist on jQuery.scianimator")}}};e.fn.scianimator.defaults={autoRefresh:false,keyboard:true,debug:false,images:[],controlContainer:null,controlPosition:c.POSITION_BOTTOM,controls:c.CONTROLS_ALL,defaultFrame:0,delay:250,delayStep:50,delayMin:25,delayMax:5000,dwellMultiplier:2,theme:"light",width:null,utf8:true,loopMode:c.LOOP_MODE_LOOP,labels:{text:{first:"First",previous:"Previous",play:"Play",stop:"Stop",next:"Next",last:"Last",loop:{tip:"Click to toggle loop mode",loop:"Loop",sweep:"Sweep",none:"None"},speed:{speed:"Speed",down:"-",up:"+"},navigator:{tip:"Click to go to frame; &lt;ctrl&gt;+click to enable/disable frame."},status:{preload:"Preloading images...",refresh:"Refreshing images from source..."}},utf8:{first:"|&#8592;",previous:"&#8592;",play:"&#9658;",stop:"&#9632;",next:"&#8594;",last:"&#8594;|"}}};var d={};var b={init:function(g){d=e.extend(true,{},e.fn.scianimator.defaults,g);a("init");return this.each(function(){var i=e(this);var h=i.data("scianimator");e(this).data("scianimator",{id:i[0].id,target:i,image:null,animationTimer:null,autoRefreshTimer:null,playMode:c.PLAY_MODE_STOPPED,frames:[],currentFrame:d.defaultFrame,firstFrame:0,lastFrame:null,disabledFrames:[],direction:c.DIRECTION_FORWARD,dwell:0,settings:d,controls:{}});i.scianimator("loadImages","preload").scianimator("container").scianimator("image").scianimator("controls").scianimator("calculateDwell")})},destroy:function(){a("destroy");return this.each(function(){var h=e(this);var g=h.data("scianimator");e(window).unbind(".scianimator");h.removeData("scianimator");window.clearTimeout(g.animationTimer);h.remove()})},drawImage:function(j){a("drawImage");var i=e(this);var g=i.data("scianimator");j=parseInt(j,10);var h=g.frames[j];e(g.image).load(function(){a("Loaded image for frame #"+j+" : "+h.src)}).error(function(){a("Image failed to load for frame #"+j+" : "+h.src);i.scianimator("enableDisable",{frame:j,state:"disable"})}).attr("src",h.src);return i},container:function(){a("container");var h=e(this);var g=h.data("scianimator");h.addClass("scianimator");if(g.settings.theme!==undefined){h.addClass(g.settings.theme)}if(g.settings.width!==undefined){h.css("width",g.settings.width)}return h},image:function(){a("image");var i=e(this);var h=i.data("scianimator");var g=e("<img />");i.append(g[0]);h.image=g[0];if("number"===typeof h.settings.defaultFrame){i.scianimator("goto",h.settings.defaultFrame)}else{if("last"===h.settings.defaultFrame){i.scianimator("last")}else{i.scianimator("first")}}return i},controls:function(){a("controls");var k=e(this);var j=k.data("scianimator");var h=e('<div id="'+j.id+'-controls" class="scianimator controls"></div>');if(j.settings.theme!==undefined){h.addClass(j.settings.theme)}var i=e("<form></form>");var g={first:function(){var l=(j.settings.utf8)?j.settings.labels.utf8.first:j.settings.labels.text.first;return e('<a id="'+j.id+'-first" class="control first" href="#">'+l+"</a>")},previous:function(){var l=(j.settings.utf8)?j.settings.labels.utf8.previous:j.settings.labels.text.previous;return e('<a id="'+j.id+'-previous" class="control previous" href="#">'+l+"</a>")},play:function(){var l=(j.settings.utf8)?j.settings.labels.utf8.play:j.settings.labels.text.play;return e('<a id="'+j.id+'-play" class="control play" href="#">'+l+"</a>")},next:function(){var l=(j.settings.utf8)?j.settings.labels.utf8.next:j.settings.labels.text.next;return e('<a id="'+j.id+'-next" class="control next" href="#">'+l+"</a>")},last:function(){var l=(j.settings.utf8)?j.settings.labels.utf8.last:j.settings.labels.text.last;return e('<a id="'+j.id+'-last" class="control last" href="#">'+l+"</a>")},navigator:function(){var l=e('<span id="'+j.id+'-navigator" class="control navigator box"></span>');var m=j.settings.labels.text.navigator.tip;e.each(j.frames,function(n,o){l.append('<a id="'+j.id+"-navigator-"+n+'" title="'+m+'" href="#" class="control navigator">&nbsp;</a>')});return l},loop:function(){var l=(j.settings.utf8&&j.settings.labels.utf8.loop!==undefined)?j.settings.labels.utf8.loop[j.settings.loopMode]:j.settings.labels.text.loop[j.settings.loopMode];var m=j.settings.labels.text.loop.tip;return e('<a id="'+j.id+'-loop" class="control loop '+j.settings.loopMode+'" title="'+m+'" href="#">'+l+"</a>")},speed:function(){var m=(j.settings.utf8&&j.settings.labels.utf8.speed!==undefined)?j.settings.labels.utf8.speed.speed:j.settings.labels.text.speed.speed;var l=(j.settings.utf8&&j.settings.labels.utf8.speed!==undefined)?j.settings.labels.utf8.speed.up:j.settings.labels.text.speed.up;var n=(j.settings.utf8&&j.settings.labels.utf8.speed!==undefined)?j.settings.labels.utf8.speed.down:j.settings.labels.text.speed.down;return e('<span id="'+j.id+'-speed" class="control speed box"><a id="'+j.id+'-speed-down" class="control speed-down small" href="#">'+n+"</a> <label>"+m+'</label> <a id="'+j.id+'-speed-up" class="control speed-up small" href="#">'+l+"</a></span>")}};h.delegate("form","submit",function(l){l.preventDefault()}).delegate("a","click",function(l){l.preventDefault();switch(l.target.id){case j.id+"-first":k.scianimator("first");break;case j.id+"-previous":k.scianimator("previous");break;case j.id+"-play":k.scianimator("playOrStop");break;case j.id+"-next":k.scianimator("next");break;case j.id+"-last":k.scianimator("last");break;case j.id+"-loop":k.scianimator("loopMode");break;case j.id+"-speed-down":k.scianimator("speedDown");break;case j.id+"-speed-up":k.scianimator("speedUp");break}}).delegate("a.navigator","click",function(l){l.preventDefault();var n=j.id+"-navigator-";if((l.target.id).indexOf(n)!=-1){var m=parseInt((l.target.id).substring(n.length),10);if(l.metaKey){k.scianimator("enableDisable",{frame:m})}else{k.scianimator("goto",m)}}});if(e.isArray(j.settings.controls)&&j.settings.controls.length>0){e.each(j.settings.controls,function(l,m){i.append(g[m]);j.controls[m]=g[m]()[0].id})}else{if(c.CONTROLS_ALL===j.settings.controls){e.each(g,function(l,m){i.append(m);j.controls[l]=m()[0].id})}else{a("Display no controls")}}if(!e(i).is(":empty")){h.append(i);if(j.settings.controlContainer!==null){if(c.POSITION_TOP===j.settings.controlPosition){e(j.settings.controlContainer).prepend(container)}else{e(j.settings.controlContainer).append(container)}}else{if(c.POSITION_TOP===j.settings.controlPosition){k.prepend(h)}else{k.append(h)}}}if(j.settings.keyboard===true){k.scianimator("keyboard")}k.scianimator("onControlsComplete");return k},keyboard:function(){a("keyboard");var h=e(this);var g=h.data("scianimator");e(document).bind("keydown.scianimator.controls",function(i){if(i.target.tagName!="INPUT"&&i.target.tagName!="TEXTAREA"){switch(i.keyCode){case 13:case 32:h.scianimator("playOrStop");break;case 37:if(i.shiftKey){h.scianimator("first")}else{h.scianimator("previous")}break;case 39:if(i.shiftKey){h.scianimator("last")}else{h.scianimator("next")}break}}})},onControlsComplete:function(){a("onControlsComplete");var h=e(this);var g=h.data("scianimator");h.scianimator("hilightCurrent")},playOrStop:function(){a("playOrStop");var h=e(this);var g=h.data("scianimator");if(c.PLAY_MODE_PLAYING===g.playMode){h.scianimator("stop")}else{if(c.PLAY_MODE_STOPPED===g.playMode){h.scianimator("play")}}return h},play:function(){a("play");var j=e(this);var i=j.data("scianimator");i.playMode=c.PLAY_MODE_PLAYING;var h=i.settings.delay;if(c.DIRECTION_FORWARD===i.direction){if(i.currentFrame===i.firstFrame||i.currentFrame===i.lastFrame){h=i.dwell}}a("delay: "+h);i.animationTimer=self.setTimeout(function(){j.scianimator("animate")},h);var g=(i.settings.utf8)?i.settings.labels.utf8.stop:i.settings.labels.text.stop;e("#"+i.controls.play).removeClass("play").addClass("stop").html(g);return j},stop:function(){a("stop");var i=e(this);var h=i.data("scianimator");h.animationTimer=window.clearTimeout(h.animationTimer);h.playMode=c.PLAY_MODE_STOPPED;var g=(h.settings.utf8)?h.settings.labels.utf8.play:h.settings.labels.text.play;e("#"+h.controls.play).removeClass("stop").addClass("play").html(g);return i},animate:function(){a("animate");var h=e(this);var g=h.data("scianimator");if(c.DIRECTION_FORWARD===g.direction){h.scianimator("next")}else{if(c.DIRECTION_REVERSE===g.direction){h.scianimator("previous")}}if(c.PLAY_MODE_PLAYING===g.playMode){h.scianimator("play")}return h},previous:function(){a("previous");var h=e(this);var g=h.data("scianimator");g.currentFrame--;if(e.inArray(g.currentFrame,g.disabledFrames)!=-1){h.scianimator("previous");return h}a(g.firstFrame+":"+g.currentFrame+":"+g.lastFrame);if(g.currentFrame<g.firstFrame){if(c.PLAY_MODE_PLAYING===g.playMode){if(c.LOOP_MODE_LOOP===g.settings.loopMode){h.scianimator("last")}else{if(c.LOOP_MODE_SWEEP===g.settings.loopMode){g.direction=c.DIRECTION_FORWARD;h.scianimator("next")}else{if(c.LOOP_MODE_NONE===g.settings.loopMode){h.scianimator("stop")}}}}else{if(c.PLAY_MODE_STOPPED===g.playMode){h.scianimator("last")}}}else{h.scianimator("goto",g.currentFrame)}return h},next:function(){a("next");var h=e(this);var g=h.data("scianimator");g.currentFrame++;a(g.firstFrame+":"+g.currentFrame+":"+g.lastFrame);if(e.inArray(g.currentFrame,g.disabledFrames)!=-1){h.scianimator("next");return h}if(g.currentFrame>g.lastFrame){if(c.PLAY_MODE_PLAYING===g.playMode){if(c.LOOP_MODE_LOOP===g.settings.loopMode){h.scianimator("first")}else{if(c.LOOP_MODE_SWEEP===g.settings.loopMode){g.direction=c.DIRECTION_REVERSE;h.scianimator("previous")}else{if(c.LOOP_MODE_NONE===g.settings.loopMode){h.scianimator("stop")}}}}else{if(c.PLAY_MODE_STOPPED===g.playMode){h.scianimator("first")}}}else{h.scianimator("goto",g.currentFrame)}return h},first:function(){a("first");var h=e(this);var g=h.data("scianimator");h.scianimator("goto",g.firstFrame);return h},last:function(){a("last");var h=e(this);var g=h.data("scianimator");h.scianimator("goto",g.lastFrame);return h},"goto":function(i){a("goto");var h=e(this);var g=h.data("scianimator");var i=parseInt(i,10);if(i>g.lastFrame){i=g.lastFrame}else{if(i<g.firstFrame){i=g.firstFrame}}a(i);g.currentFrame=i;h.scianimator("drawImage",g.currentFrame);h.scianimator("hilightCurrent");return h},loopMode:function(){a("loop mode");var j=e(this);var i=j.data("scianimator");var g=i.settings.loopMode;if(c.LOOP_MODE_NONE===i.settings.loopMode){i.settings.loopMode=c.LOOP_MODE_LOOP}else{if(c.LOOP_MODE_LOOP===i.settings.loopMode){i.settings.loopMode=c.LOOP_MODE_SWEEP}else{if(c.LOOP_MODE_SWEEP===i.settings.loopMode){i.direction=c.DIRECTION_FORWARD;i.settings.loopMode=c.LOOP_MODE_NONE}}}var h=(i.settings.utf8&&i.settings.labels.utf8.loop!==undefined)?i.settings.labels.utf8.loop[i.settings.loopMode]:i.settings.labels.text.loop[i.settings.loopMode];e("#"+i.controls.loop).removeClass(g).addClass(i.settings.loopMode).html(h);a(i.settings.loopMode);return j},speedUp:function(){a("speed up");var h=e(this);var g=h.data("scianimator");g.settings.delay-=g.settings.delayStep;g.settings.delay=(g.settings.delay<g.settings.delayMin)?g.settings.delayMin:g.settings.delay;h.scianimator("calculateDwell");if(c.PLAY_MODE_PLAYING==g.playMode){h.scianimator("stop").scianimator("play")}a("Delay: "+g.settings.delay);return h},speedDown:function(){a("speed down");var h=e(this);var g=h.data("scianimator");g.settings.delay=(g.settings.delay<=g.settings.delayMin)?0:g.settings.delay;g.settings.delay+=g.settings.delayStep;g.settings.delay=(g.settings.delay>g.settings.delayMax)?g.settings.delayMax:g.settings.delay;h.scianimator("calculateDwell");if(c.PLAY_MODE_PLAYING==g.playMode){h.scianimator("stop").scianimator("play")}a("delay: "+g.settings.delay);return h},calculateDwell:function(){a("calculateDwell");var i=e(this);var h=i.data("scianimator");var g=h.settings.delay*h.settings.dwellMultiplier;if(g<h.settings.delayMin){g=h.settings.delayMin}if(g>h.settings.delayMax){g=h.settings.delayMax}h.dwell=g;a("dwell: "+h.dwell);return i},enableDisable:function(m){a("enableDisable");var j=m.state||"toggle";var k=e(this);var i=k.data("scianimator");var l=parseInt(m.frame,10);var g=e("#"+i.controls.navigator+"-"+l);var h=e.inArray(l,i.disabledFrames);switch(j){case"enable":if(h!=-1){a("enable: "+l);i.disabledFrames.splice(h,1);e(g).removeClass("disabled")}break;case"disable":if(h==-1){a("disable: "+l);i.disabledFrames.push(l);e(g).addClass("disabled")}break;case"toggle":default:if(h!=-1){a("enable: "+l);i.disabledFrames.splice(h,1);e(g).removeClass("disabled")}else{a("disable: "+l);i.disabledFrames.push(l);e(g).addClass("disabled")}}a("disabledFrames:"+i.disabledFrames);return k},hilightCurrent:function(){a("hilightCurrent");var i=e(this);var h=i.data("scianimator");var g=h.controls.navigator;var j=g+"-"+h.currentFrame;e("a","#"+g).removeClass("current");e("#"+j,"#"+g).addClass("current")},loadImages:function(g){a("loadImages");var j=e(this);var i=j.data("scianimator");if("preload"===g){j.scianimator("showStatus",{status:i.settings.labels.text.status.preload})}else{if("refresh"===g){j.scianimator("showStatus",{status:i.settings.labels.text.status.refresh})}}i.frames=[];var h=0;e.each(i.settings.images,function(m,l){var k=e("<img />").load(function(){if(++h===i.settings.images.length){j.scianimator("onLoadImagesComplete")}}).error(function(){a("Image failed to load for frame #"+m+" : "+l);j.scianimator("enableDisable",{frame:m,state:"disable"});if(++h===i.settings.images.length){j.scianimator("onLoadImagesComplete")}});if("refresh"===g){k.attr("src",f(l))}else{k.attr("src",l)}i.frames.push(k[0])});i.lastFrame=i.frames.length-1;return j},onLoadImagesComplete:function(){a("onLoadImagesComplete");var h=e(this);var g=h.data("scianimator");if(g.settings.autoRefresh!==false){g.autoRefreshTimer=self.setTimeout(function(){h.scianimator("refresh")},parseInt(g.settings.autoRefresh,10))}h.scianimator("hideStatus")},refresh:function(){a("refresh");var h=e(this);var g=h.data("scianimator");h.scianimator("loadImages","refresh")},showStatus:function(j){a("showStatus");var i=e(this);var h=i.data("scianimator");i.scianimator("hideStatus");var g=e('<div class="status">'+j.status+"</div>");g.hide().appendTo(i).fadeIn("slow");if(j.timeout!==undefined){self.setTimeout(function(){i.scianimator("hideStatus")},parseInt(j.timeout,10))}return i},hideStatus:function(){a("hideStatus");var h=e(this);var g=h.data("scianimator");e(".status",h).fadeOut("slow",function(){e(this).remove()});return h},listImages:function(){a("list images");var h=e(this);var g=h.data("scianimator");return g.settings.images}};function a(g){if(d.debug&&window.console&&window.console.log){window.console.log(g)}}function f(i){var h=i;var j=i.indexOf("?");var g="";if(j!=-1){h=i.substring(0,j);g=i.substring(j);g=g.replace(/[(?|&)]rand=[^&]+/g,"")}i=h+((g.length)?g+"&":g+"?");i+="rand="+Math.random();return i}})(jQuery);