## ----echo = FALSE, message = FALSE, results = 'hide', warning = FALSE---------
cat("this is hidden; general initializations.\n")

## -----------------------------------------------------------------------------
library(ANOPA)

ArringtonEtAl2002

## -----------------------------------------------------------------------------
getOption("ANOPA.zeros")

## -----------------------------------------------------------------------------
w <- anopa( {s; n} ~  Trophism * Location * Diel, ArringtonEtAl2002)

## -----------------------------------------------------------------------------
uncorrected(w)

## ----message=FALSE, warning=FALSE, fig.width=5, fig.height=5, fig.cap="**Figure 1**. The proportions in the Arrington et al. 2002 data. Error bars show difference-adjusted 95% confidence intervals."----
anopaPlot(w)

## ----message=FALSE, warning=FALSE, fig.width=5, fig.height=3, fig.cap="**Figure 1**. The proportions as a function of class and Difficulty. Error bars show difference-adjusted 95% confidence intervals."----
anopaPlot(w, ~ Trophism * Location)

## -----------------------------------------------------------------------------
e <- emProportions( w, ~ Location * Trophism | Diel  ) 
uncorrected(e)

## ----message=FALSE, warning=FALSE, fig.width=15, fig.height=5, fig.cap="**Figure 2**. The proportions with arrows highlighting the missing data"----
library(ggplot2)   # for ylab(), annotate()
library(ggh4x)     # for at_panel()
library(gridExtra) # for grid.arrange()

#Add annotations to show where missing cells are...
annotationsA <- list(
    annotate("segment", linewidth=1.25, x = 1.5, y = 0.45, xend = 1, yend = 0.15, color="green", arrow = arrow()),
    annotate("segment", linewidth=1.25, x = 1.5, y = 0.45, xend = 1, yend = 0.10, color="red", arrow = arrow()),
    annotate("segment", linewidth=1.25, x = 1.5, y = 0.45, xend = 2.8, yend = 0.25, color="red", arrow = arrow()),
    annotate("text", x = 1.5, y = 0.5, label = "No observations")
)
annotationsB <- list(
    annotate("segment", linewidth=2, x = 2.2, y = 0.08, xend = 1.95, yend = 0.04, color="red", arrow = arrow()),
    annotate("segment", linewidth=2, x = 2.2, y = 0.12, xend = 2.05, yend = 0.36, color="blue", arrow = arrow()),
    annotate("text", x = 2.0, y = 0.1, label = "Merge an imputed cell\nwith a regular cell")
)
annotationsC <- list(
    annotate("segment", linewidth=2, x = 1.4, y = 0.275, xend = 1.9, yend = 0.285, color="red", arrow = arrow()),
    annotate("segment", linewidth=2, x = 1.4, y = 0.275, xend = 2.0, yend = 0.16, color="blue", arrow = arrow()),
    annotate("text", x = 1., y = 0.275, label = "Merge an imputed cell\nwith a regular cell")
)

pla <- anopaPlot(w, ~ Trophism * Location * Diel)+  
  ylab("Proportion empty stomach") +
  lapply(annotationsA,  \(ann) {at_panel(ann, Diel == "Nocturnal")})

plb <- anopaPlot(w, ~ Diel * Trophism ) +  
  ylab("Proportion empty stomach") +
  annotationsB

plc <- anopaPlot(w, ~ Diel * Location ) +  
  ylab("Proportion empty stomach") +
  annotationsC

grid.arrange( pla, plb, plc, ncol = 3 )

## ----message=FALSE, warning=FALSE---------------------------------------------
library(psych)

options("ANOPA.zeros" = c(harmonic.mean(ArringtonEtAl2002$s), harmonic.mean(ArringtonEtAl2002$n)))

