//=================================================================================================
/*!
//  \file blaze/config/Random.h
//  \brief Configuration of the random number generator used in the Blaze library
//
//  Copyright (C) 2012-2020 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================


//*************************************************************************************************
/*!\brief Type of the random number generator of the Blaze library.
// \ingroup config
//
// This type definition represents the type of the random number generated used in the Blaze
// library. The default random number generator is the std::mt19937 mersenne-twister pseudo
// random number generator. For more information see the following reference documentation:
//
//   http://en.cppreference.com/w/cpp/numeric/random/mersenne_twister_engine
//
// \note It is possible to specify the random number generator via command line or by defining
// this symbol manually before including any Blaze header file:

   \code
   g++ ... -DBLAZE_RANDOM_NUMBER_GENERATOR=std::mt19937 ...
   \endcode

   \code
   #define BLAZE_RANDOM_NUMBER_GENERATOR std::mt19937
   #include <blaze/Blaze.h>
   \endcode
*/
#ifndef BLAZE_RANDOM_NUMBER_GENERATOR
#define BLAZE_RANDOM_NUMBER_GENERATOR std::mt19937
#endif
//*************************************************************************************************
