/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.conversions;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.TimeTz;
import com.amazon.dsi.dataengine.utilities.TimestampTz;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.conversions.ISqlConverter;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.DateTimeConverter;
import com.amazon.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class SqlDateTimeConverter
implements ISqlConverter {
    private final IColumn m_targetMeta;
    private final short m_targetType;
    private final IColumn m_sourceMeta;

    public SqlDateTimeConverter(IColumn iColumn, IColumn iColumn2) {
        this.m_targetMeta = iColumn2;
        this.m_targetType = this.m_targetMeta.getTypeMetadata().getType();
        this.m_sourceMeta = iColumn;
    }

    @Override
    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            switch (iSqlDataWrapper.getType()) {
                case 91: {
                    this.convertFromDate(iSqlDataWrapper.getDate(), conversionResult, iSqlDataWrapper, iSqlDataWrapper2);
                    break;
                }
                case 92: {
                    this.convertFromTime(iSqlDataWrapper.getTime(), conversionResult, iSqlDataWrapper, iSqlDataWrapper2);
                    break;
                }
                case 93: {
                    this.convertFromTimestamp(iSqlDataWrapper.getTimestamp(), conversionResult, iSqlDataWrapper, iSqlDataWrapper2);
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
                }
            }
        }
        return conversionResult;
    }

    private void convertFromTime(Time time, ConversionResult conversionResult, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        Calendar calendar = null;
        TimeTz timeTz = null;
        if (time instanceof TimeTz) {
            timeTz = (TimeTz)time;
            calendar = timeTz.getTimezoneCalendar();
        } else {
            calendar = Calendar.getInstance();
        }
        switch (this.m_targetType) {
            case 92: {
                Time time2 = DateTimeConverter.toTime(time, conversionResult, (int)this.m_targetMeta.getTypeMetadata().getPrecision(), calendar);
                if (null != timeTz) {
                    time2 = new TimeTz(time2, calendar);
                }
                iSqlDataWrapper2.setTime(time2);
                break;
            }
            case 93: {
                Timestamp timestamp = DateTimeConverter.toTimestamp(time, conversionResult, calendar, this.m_targetMeta.getTypeMetadata().getPrecision());
                if (null != timeTz) {
                    timestamp = new TimestampTz(timestamp, calendar);
                }
                iSqlDataWrapper2.setTimestamp(timestamp);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = DateTimeConverter.toChar(time, this.m_targetMeta.getColumnLength(), (int)this.m_sourceMeta.getTypeMetadata().getPrecision(), calendar, conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
            }
        }
    }

    private void convertFromTimestamp(Timestamp timestamp, ConversionResult conversionResult, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        switch (this.m_targetType) {
            case 93: {
                Timestamp timestamp2 = DateTimeConverter.toTimestamp(timestamp, conversionResult, this.m_targetMeta.getTypeMetadata().getPrecision());
                if (timestamp instanceof TimestampTz) {
                    timestamp2 = new TimestampTz(timestamp2, ((TimestampTz)timestamp).getTimezoneCalendar());
                }
                iSqlDataWrapper2.setTimestamp(timestamp2);
                break;
            }
            case 91: {
                Calendar calendar = null;
                calendar = timestamp instanceof TimestampTz ? ((TimestampTz)timestamp).getTimezoneCalendar() : Calendar.getInstance();
                Date date = DateTimeConverter.toDate(timestamp, calendar, conversionResult);
                iSqlDataWrapper2.setDate(date);
                break;
            }
            case 92: {
                Calendar calendar = null;
                calendar = timestamp instanceof TimestampTz ? ((TimestampTz)timestamp).getTimezoneCalendar() : Calendar.getInstance();
                Time time = DateTimeConverter.toTime(timestamp, calendar, (int)this.m_targetMeta.getTypeMetadata().getPrecision(), conversionResult);
                iSqlDataWrapper2.setTime(time);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                Calendar calendar = null;
                calendar = timestamp instanceof TimestampTz ? ((TimestampTz)timestamp).getTimezoneCalendar() : Calendar.getInstance();
                String string = DateTimeConverter.toChar(timestamp, this.m_targetMeta.getColumnLength(), (int)this.m_sourceMeta.getTypeMetadata().getPrecision(), calendar, conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
            }
        }
    }

    private void convertFromDate(Date date, ConversionResult conversionResult, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        switch (this.m_targetType) {
            case 93: {
                Timestamp timestamp = DateTimeConverter.toTimestamp(date, conversionResult, Calendar.getInstance());
                iSqlDataWrapper2.setTimestamp(timestamp);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = DateTimeConverter.toChar(iSqlDataWrapper.getDate(), this.m_targetMeta.getColumnLength(), Calendar.getInstance(), conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
            }
        }
    }
}

