/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.exceptions.DefaultParamException;
import com.amazon.dsi.exceptions.ParamAlreadyPushedException;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class PGQueryExecutor
extends PGAbstractQueryExecutor {
    private PGMessagingContext m_messagingContext;
    private String m_query;
    private PGCoreUtils.TransactionVerb m_txVerb = PGCoreUtils.TransactionVerb.NONE;

    public PGQueryExecutor(String string, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, pGClient);
        this.m_query = string;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_isDirectExecute = bl;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        if (!bl) {
            this.m_messagingContext = this.m_client.prepareStatement(string, pGJDBCStatement.getWarningListener(), false);
            this.m_messagingContext.addSocketCloseListener(this);
            this.m_contexts.add(this.m_messagingContext);
            this.m_statement.pushContexts(this.m_contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        this.m_prepareStage = false;
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        int n2 = 0;
        try {
            n2 = this.m_statement.getProperty(2).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Max rows retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        if (this.m_isDirectExecute) {
            PGCoreUtils.TransactionVerb transactionVerb = PGCoreUtils.TransactionVerb.NONE;
            Lock lock = this.m_statement.getTransactionLock();
            lock.lock();
            try {
                this.m_messagingContext = this.m_client.directExecuteExtraMetadata(this.m_query, n, n2, this.m_statement.getWarningListener(), false, this.getQueryTimeout());
                this.m_contexts.add(this.m_messagingContext);
                for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                    transactionVerb = this.m_client.getTransactionVerbOfMessage(pGMessagingContext);
                }
                if (PGCoreUtils.TransactionVerb.NONE != transactionVerb) {
                    this.m_statement.notifyTransaction(transactionVerb);
                }
            }
            finally {
                lock.unlock();
            }
            this.m_statement.pushContexts(this.m_contexts);
            for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                pGMessagingContext.addSocketCloseListener(this);
            }
        } else {
            try {
                int n3 = executionContexts.getMetadata().size();
                if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
                    --n3;
                }
                this.executePreparedStatement(this.m_messagingContext, executionContexts, n, n2, n3, this.m_txVerb);
            }
            catch (Exception exception) {
                --this.m_currentExecuteIndex;
                if (!(exception instanceof ErrorException)) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                    errorException.initCause(exception);
                    throw errorException;
                }
                throw (ErrorException)exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePreparedStatement(PGMessagingContext pGMessagingContext, ExecutionContexts executionContexts, int n, int n2, int n3, PGCoreUtils.TransactionVerb transactionVerb) throws InboundErrorMessage, ErrorException, ParamAlreadyPushedException, DefaultParamException {
        if (n3 != 0) {
            Object object;
            ArrayList<byte[][]> arrayList = new ArrayList<byte[][]>();
            Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
            while (iterator.hasNext()) {
                object = new byte[n3][];
                ExecutionContext executionContext = iterator.next();
                for (int i = 0; i < executionContext.getInputs().size(); ++i) {
                    ParameterInputValue parameterInputValue = executionContext.getInputs().get(i);
                    object[i] = PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData());
                }
                arrayList.add((byte[][])object);
            }
            if (1 == arrayList.size()) {
                this.m_client.executePreparedStatement(pGMessagingContext, n, n2, false, (byte[][])arrayList.get(0), this.getQueryTimeout());
            } else {
                object = new byte[arrayList.size()][][];
                for (int i = 0; i < ((byte[][])object).length; ++i) {
                    object[i] = (byte[])((byte[][])arrayList.get(i));
                }
                this.m_client.executePreparedStatementParameterSets(pGMessagingContext, this.m_currentExecuteIndex, (byte[][][])object);
            }
        } else {
            Lock lock = this.m_statement.getTransactionLock();
            lock.lock();
            try {
                this.m_client.executePreparedStatement(pGMessagingContext, n, n2, false, null, this.getQueryTimeout());
                transactionVerb = this.m_client.getTransactionVerbOfMessage(pGMessagingContext);
                if (PGCoreUtils.TransactionVerb.NONE != transactionVerb) {
                    pGMessagingContext.closeOperation();
                    this.m_statement.notifyTransaction(transactionVerb);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        List<ParameterMetadata> list = this.getMetadataForParameters(this.m_messagingContext);
        return (ArrayList)list;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return PGCoreUtils.parameterCounter(this.m_query);
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext pGMessagingContext) {
        return pGMessagingContext.m_parameterMetadata.size();
    }
}

