/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Stacking;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Grading
extends Stacking
implements TechnicalInformationHandler {
    static final long serialVersionUID = 5207837947890081170L;
    protected Classifier[] m_MetaClassifiers = new Classifier[0];
    protected double[] m_InstPerClass = null;

    @Override
    public String globalInfo() {
        return "Implements Grading. The base classifiers are \"graded\".\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A.K. Seewald and J. Fuernkranz");
        result.setValue(TechnicalInformation.Field.TITLE, "An Evaluation of Grading Classifiers");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Intelligent Data Analysis: 4th International Conference");
        result.setValue(TechnicalInformation.Field.EDITOR, "F. Hoffmann et al.");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.PAGES, "115-124");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Berlin/Heidelberg/New York/Tokyo");
        return result;
    }

    @Override
    protected void generateMetaLevel(Instances newData, Random random) throws Exception {
        this.m_MetaFormat = this.metaFormat(newData);
        Instances[] metaData = new Instances[this.m_Classifiers.length];
        int i = 0;
        while (i < this.m_Classifiers.length) {
            metaData[i] = this.metaFormat(newData);
            ++i;
        }
        int j = 0;
        while (j < this.m_NumFolds) {
            Instances train = newData.trainCV(this.m_NumFolds, j, random);
            Instances test = newData.testCV(this.m_NumFolds, j);
            int i2 = 0;
            while (i2 < this.m_Classifiers.length) {
                this.getClassifier(i2).buildClassifier(train);
                int k = 0;
                while (k < test.numInstances()) {
                    metaData[i2].add(this.metaInstance(test.instance(k), i2));
                    ++k;
                }
                ++i2;
            }
            ++j;
        }
        this.m_InstPerClass = new double[newData.numClasses()];
        i = 0;
        while (i < newData.numClasses()) {
            this.m_InstPerClass[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < newData.numInstances()) {
            int n = (int)newData.instance(i).classValue();
            this.m_InstPerClass[n] = this.m_InstPerClass[n] + 1.0;
            ++i;
        }
        this.m_MetaClassifiers = Classifier.makeCopies(this.m_MetaClassifier, this.m_Classifiers.length);
        i = 0;
        while (i < this.m_Classifiers.length) {
            this.m_MetaClassifiers[i].buildClassifier(metaData[i]);
            ++i;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] preds;
        int numPreds = 0;
        int numClassifiers = this.m_Classifiers.length;
        double[] predConfs = new double[numClassifiers];
        int i = 0;
        while (i < numClassifiers) {
            preds = this.m_MetaClassifiers[i].distributionForInstance(this.metaInstance(instance, i));
            predConfs[i] = this.m_MetaClassifiers[i].classifyInstance(this.metaInstance(instance, i)) == 1.0 ? preds[1] : -preds[0];
            ++i;
        }
        if (predConfs[Utils.maxIndex(predConfs)] < 0.0) {
            i = 0;
            while (i < numClassifiers) {
                predConfs[i] = 1.0 + predConfs[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < numClassifiers) {
                if (predConfs[i] < 0.0) {
                    predConfs[i] = 0.0;
                }
                ++i;
            }
        }
        preds = new double[instance.numClasses()];
        i = 0;
        while (i < instance.numClasses()) {
            preds[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < numClassifiers) {
            int idxPreds;
            int n = idxPreds = (int)this.m_Classifiers[i].classifyInstance(instance);
            preds[n] = preds[n] + predConfs[i];
            ++i;
        }
        double maxPreds = preds[Utils.maxIndex(preds)];
        int MaxInstPerClass = -100;
        int MaxClass = -1;
        int i2 = 0;
        while (i2 < instance.numClasses()) {
            if (preds[i2] == maxPreds) {
                ++numPreds;
                if (this.m_InstPerClass[i2] > (double)MaxInstPerClass) {
                    MaxInstPerClass = (int)this.m_InstPerClass[i2];
                    MaxClass = i2;
                }
            }
            ++i2;
        }
        int predictedIndex = numPreds == 1 ? Utils.maxIndex(preds) : MaxClass;
        double[] classProbs = new double[instance.numClasses()];
        classProbs[predictedIndex] = 1.0;
        return classProbs;
    }

    @Override
    public String toString() {
        if (this.m_Classifiers.length == 0) {
            return "Grading: No base schemes entered.";
        }
        if (this.m_MetaClassifiers.length == 0) {
            return "Grading: No meta scheme selected.";
        }
        if (this.m_MetaFormat == null) {
            return "Grading: No model built yet.";
        }
        String result = "Grading\n\nBase classifiers\n\n";
        int i = 0;
        while (i < this.m_Classifiers.length) {
            result = String.valueOf(result) + this.getClassifier(i).toString() + "\n\n";
            ++i;
        }
        result = String.valueOf(result) + "\n\nMeta classifiers\n\n";
        i = 0;
        while (i < this.m_Classifiers.length) {
            result = String.valueOf(result) + this.m_MetaClassifiers[i].toString() + "\n\n";
            ++i;
        }
        return result;
    }

    @Override
    protected Instances metaFormat(Instances instances) throws Exception {
        FastVector attributes = new FastVector();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (i != instances.classIndex()) {
                attributes.addElement(instances.attribute(i));
            }
            ++i;
        }
        FastVector nomElements = new FastVector(2);
        nomElements.addElement("0");
        nomElements.addElement("1");
        attributes.addElement(new Attribute("PredConf", nomElements));
        Instances metaFormat = new Instances("Meta format", attributes, 0);
        metaFormat.setClassIndex(metaFormat.numAttributes() - 1);
        return metaFormat;
    }

    protected Instance metaInstance(Instance instance, int k) throws Exception {
        double predConf;
        double[] values = new double[this.m_MetaFormat.numAttributes()];
        int idx = 0;
        int i = 0;
        while (i < instance.numAttributes()) {
            if (i != instance.classIndex()) {
                values[idx] = instance.value(i);
                ++idx;
            }
            ++i;
        }
        Classifier classifier = this.getClassifier(k);
        if (this.m_BaseFormat.classAttribute().isNumeric()) {
            throw new Exception("Class Attribute must not be numeric!");
        }
        double[] dist = classifier.distributionForInstance(instance);
        int maxIdx = 0;
        double maxVal = dist[0];
        int j = 1;
        while (j < dist.length) {
            if (dist[j] > maxVal) {
                maxVal = dist[j];
                maxIdx = j;
            }
            ++j;
        }
        values[idx] = predConf = (double)(instance.classValue() == (double)maxIdx ? 1 : 0);
        Instance metaInstance = new Instance(1.0, values);
        metaInstance.setDataset(this.m_MetaFormat);
        return metaInstance;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.13 $");
    }

    public static void main(String[] argv) {
        Grading.runClassifier(new Grading(), argv);
    }
}

