/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.Gauss;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderWithPivoting;
import jdplus.toolkit.base.core.math.matrices.decomposition.LUDecomposition;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;

public final class FastMatrix
implements Matrix.Mutable {
    private final double[] storage;
    private final int lda;
    int start;
    int nrows;
    int ncols;
    public static final FastMatrix EMPTY = new FastMatrix(Doubles.EMPTYARRAY, 0, 0);

    public static Builder builder(double[] storage) {
        return new Builder(storage);
    }

    public static FastMatrix square(int n) {
        if (n == 0) {
            return EMPTY;
        }
        double[] data = new double[n * n];
        return new FastMatrix(data, n, n);
    }

    public static FastMatrix make(int nrows, int ncols) {
        if (nrows == 0 || ncols == 0) {
            return EMPTY;
        }
        double[] data = new double[nrows * ncols];
        return new FastMatrix(data, nrows, ncols);
    }

    public static FastMatrix of(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        return new FastMatrix(matrix.toArray(), matrix.getRowsCount(), matrix.getColumnsCount());
    }

    public static FastMatrix identity(int n) {
        FastMatrix i = FastMatrix.square(n);
        i.diagonal().set(1.0);
        return i;
    }

    public static FastMatrix diagonal(DoubleSeq d) {
        FastMatrix i = FastMatrix.square(d.length());
        i.diagonal().copy(d);
        return i;
    }

    public static FastMatrix rowOf(DataBlock x) {
        return new FastMatrix(x.toArray(), 1, x.length());
    }

    public static FastMatrix columnOf(DataBlock x) {
        return new FastMatrix(x.toArray(), x.length(), 1);
    }

    public static FastMatrix internalRowOf(DataBlock x) {
        return new FastMatrix(x.getStorage(), x.getIncrement(), x.getStartPosition(), 1, x.length());
    }

    public static FastMatrix internalColumnOf(DataBlock x) {
        if (x.getIncrement() != 1) {
            throw new MatrixException("m_err_dim");
        }
        int start = x.getStartPosition();
        int n = x.length();
        return new FastMatrix(x.getStorage(), n, start, n, 1);
    }

    public FastMatrix(double[] data, int nrows, int ncols) {
        this.storage = data;
        this.nrows = nrows;
        this.ncols = ncols;
        this.start = 0;
        this.lda = nrows;
    }

    FastMatrix(int nrows, int ncols) {
        this.storage = new double[nrows * ncols];
        this.lda = nrows;
        this.start = 0;
        this.nrows = nrows;
        this.ncols = ncols;
    }

    FastMatrix(double[] x, int lda, int start, int nrows, int ncols) {
        this.storage = x;
        this.lda = lda;
        this.start = start;
        this.nrows = nrows;
        this.ncols = ncols;
    }

    public FastMatrix deepClone() {
        return new FastMatrix(this.toArray(), this.nrows, this.ncols);
    }

    public FastMatrix extract(int r0, int nr, int c0, int nc) {
        return new FastMatrix(this.storage, this.lda, this.start + r0 + c0 * this.lda, nr, nc);
    }

    public FastMatrix dropTopLeft(int nr, int nc) {
        return new FastMatrix(this.storage, this.lda, this.start + nr + nc * this.lda, this.nrows - nr, this.ncols - nc);
    }

    public FastMatrix dropBottomRight(int nr, int nc) {
        return new FastMatrix(this.storage, this.lda, this.start, this.nrows - nr, this.ncols - nc);
    }

    public boolean isFull() {
        return this.storage.length == this.nrows * this.ncols;
    }

    public boolean isDiagonal(double zero) {
        if (this.ncols != this.nrows) {
            return false;
        }
        if (this.nrows == 1) {
            return true;
        }
        DataBlock diag = this.diagonal();
        DataWindow ldiag = diag.window();
        DataWindow udiag = diag.window();
        for (int i = 1; i < this.nrows; ++i) {
            if (!ldiag.slideAndShrink(1).isZero(zero)) {
                return false;
            }
            if (udiag.slideAndShrink(this.lda).isZero(zero)) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity() {
        if (this.ncols != this.nrows) {
            return false;
        }
        if (this.nrows == 1) {
            return this.get(0, 0) == 1.0;
        }
        if (this.diagonal().anyMatch(x -> x != 1.0)) {
            return false;
        }
        DataBlock diag = this.diagonal();
        DataWindow ldiag = diag.window();
        DataWindow udiag = diag.window();
        for (int i = 1; i < this.nrows; ++i) {
            if (ldiag.slideAndShrink(1).anyMatch(x -> x != 0.0)) {
                return false;
            }
            if (!udiag.slideAndShrink(this.lda).anyMatch(x -> x != 0.0)) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonal() {
        return this.isDiagonal(0.0);
    }

    public boolean isZero(double eps) {
        return this.test(x -> Math.abs(x) <= eps);
    }

    public boolean test(DoublePredicate pred) {
        if (this.isEmpty()) {
            return true;
        }
        DataBlockIterator cols = this.columnsIterator();
        while (cols.hasNext()) {
            if (cols.next().allMatch(pred)) continue;
            return false;
        }
        return true;
    }

    public boolean isSymmetric(double eps) {
        if (this.nrows != this.ncols) {
            return false;
        }
        if (this.nrows == 1) {
            return true;
        }
        DataBlock diag = this.diagonal();
        DataWindow ldiag = diag.window();
        DataWindow udiag = diag.window();
        for (int i = 1; i < this.nrows; ++i) {
            if (ldiag.slideAndShrink(1).allMatch(udiag.slideAndShrink(this.lda), (x, y) -> Math.abs(x - y) <= eps)) continue;
            return false;
        }
        return true;
    }

    public boolean isSymmetric() {
        return this.isSymmetric(0.0);
    }

    public int lastSignificantRow() {
        if (this.isEmpty()) {
            return -1;
        }
        int r0 = this.start + this.nrows - 1;
        int r1 = r0 + this.lda * (this.ncols - 1);
        if (this.storage[r0] != 0.0 || this.storage[r1] != 0.0) {
            return this.nrows - 1;
        }
        int ncur = this.nrows - 1;
        int c = this.start;
        for (int j = 0; j < this.ncols; ++j) {
            while (ncur >= c && this.storage[ncur] == 0.0) {
                --ncur;
            }
            if (ncur < c) {
                return -1;
            }
            ncur += this.lda;
            c += this.lda;
        }
        return ncur - c;
    }

    public int lastSignificantColumn() {
        if (this.isEmpty()) {
            return -1;
        }
        int j = this.start + this.ncols * this.lda;
        for (int c = this.ncols - 1; c >= 0; --c) {
            int kmax = (j -= this.lda) + this.nrows;
            for (int k = j; k < kmax; ++k) {
                if (this.storage[k] == 0.0) continue;
                return c;
            }
        }
        return -1;
    }

    public void copyTo(double[] buffer, int pos) {
        if (this.isFull()) {
            System.arraycopy(this.storage, 0, buffer, pos, this.storage.length);
        }
        int lmax = pos + this.nrows * this.ncols;
        int l = pos;
        int i0 = this.start;
        int i1 = this.start + this.nrows;
        while (l < lmax) {
            int k = i0;
            while (k < i1) {
                buffer[l] = this.storage[k];
                ++k;
                ++l;
            }
            i0 += this.lda;
            i1 += this.lda;
        }
    }

    public double[] toArray() {
        if (this.isFull()) {
            return (double[])this.storage.clone();
        }
        double[] z = new double[this.nrows * this.ncols];
        int l = 0;
        int i0 = this.start;
        int i1 = this.start + this.nrows;
        while (l < z.length) {
            int k = i0;
            while (k < i1) {
                z[l] = this.storage[k];
                ++k;
                ++l;
            }
            i0 += this.lda;
            i1 += this.lda;
        }
        return z;
    }

    public double get(int row, int col) {
        return this.storage[this.start + row + col * this.lda];
    }

    public int getColumnsCount() {
        return this.ncols;
    }

    public int getRowsCount() {
        return this.nrows;
    }

    public double[] getStorage() {
        return this.storage;
    }

    public int getStartPosition() {
        return this.start;
    }

    public final int getLastPosition() {
        return this.start + (this.nrows - 1) + (this.ncols - 1) * this.lda;
    }

    public int getColumnIncrement() {
        return this.lda;
    }

    public DataBlock skewDiagonal(int pos) {
        int n;
        int beg;
        if (pos < 0) {
            return null;
        }
        int nmax = Math.max(this.nrows, this.ncols);
        if (pos >= nmax) {
            return null;
        }
        int inc = this.lda - 1;
        if (pos < this.nrows) {
            beg = this.start + pos;
            n = Math.min(pos + 1, this.ncols);
        } else {
            int rlast = this.nrows - 1;
            int col = pos - rlast;
            beg = this.start + rlast + this.lda * col;
            n = Math.min(this.nrows, this.ncols - col);
        }
        return DataBlock.of(this.storage, beg, beg + inc * n, inc);
    }

    public void set(Matrix.MatrixFunction fn) {
        int c = 0;
        int k = this.start;
        while (c < this.ncols) {
            int r = 0;
            int l = k;
            while (r < this.nrows) {
                this.storage[l] = fn.apply(r, c);
                ++r;
                ++l;
            }
            ++c;
            k += this.lda;
        }
    }

    public void set(double value) {
        if (this.isFull()) {
            for (int i = 0; i < this.storage.length; ++i) {
                this.storage[i] = value;
            }
        } else {
            int c = 0;
            int k = this.start;
            while (c < this.ncols) {
                int r = 0;
                int l = k;
                while (r < this.nrows) {
                    this.storage[l] = value;
                    ++r;
                    ++l;
                }
                ++c;
                k += this.lda;
            }
        }
    }

    public void set(int row, int col, double value) {
        this.storage[this.start + row + col * this.lda] = value;
    }

    public void set(int row, int col, DoubleSupplier fn) {
        this.storage[this.start + row + col * this.lda] = fn.getAsDouble();
    }

    public void add(int row, int col, double value) {
        int n = this.start + row + col * this.lda;
        this.storage[n] = this.storage[n] + value;
    }

    public void mul(int row, int col, double value) {
        int n = this.start + row + col * this.lda;
        this.storage[n] = this.storage[n] * value;
    }

    public void copy(FastMatrix B) {
        if (this.nrows != B.nrows || this.ncols != B.ncols) {
            throw new MatrixException("m_err_dim");
        }
        if (this.isFull() && B.isFull()) {
            System.arraycopy(B.storage, 0, this.storage, 0, this.storage.length);
        } else {
            int end = this.start + this.ncols * this.lda;
            int i0 = this.start;
            int i1 = this.start + this.nrows;
            int j0 = B.start;
            while (i0 < end) {
                int k = i0;
                int l = j0;
                while (k < i1) {
                    this.storage[k] = B.storage[l];
                    ++k;
                    ++l;
                }
                i0 += this.lda;
                i1 += this.lda;
                j0 += B.lda;
            }
        }
    }

    public void setAY(double a, FastMatrix Y) {
        if (this.nrows != Y.nrows || this.ncols != Y.ncols) {
            throw new MatrixException("m_err_dim");
        }
        if (a == 0.0) {
            this.set(0.0);
        } else if (a == 1.0) {
            this.copy(Y);
        } else {
            int end = this.start + this.ncols * this.lda;
            int i0 = this.start;
            int i1 = this.start + this.nrows;
            int j0 = Y.start;
            while (i0 < end) {
                int k = i0;
                int l = j0;
                while (k < i1) {
                    this.storage[k] = a * Y.storage[l];
                    ++k;
                    ++l;
                }
                i0 += this.lda;
                i1 += this.lda;
                j0 += Y.lda;
            }
        }
    }

    public void copyTranspose(FastMatrix B) {
        if (this.nrows != B.ncols || this.ncols != B.nrows) {
            throw new MatrixException("m_err_dim");
        }
        int end = this.start + this.ncols * this.lda;
        int i0 = this.start;
        int i1 = this.start + this.nrows;
        int j0 = B.start;
        while (i0 < end) {
            int k = i0;
            int l = j0;
            while (k < i1) {
                this.storage[k] = B.storage[l];
                ++k;
                l += B.lda;
            }
            i0 += this.lda;
            i1 += this.lda;
            ++j0;
        }
    }

    public FastMatrix transpose() {
        FastMatrix T2 = FastMatrix.make(this.ncols, this.nrows);
        T2.copyTranspose(this);
        return T2;
    }

    public double sum() {
        if (this.isEmpty()) {
            return 0.0;
        }
        double s = 0.0;
        if (this.isFull()) {
            for (int i = 0; i < this.storage.length; ++i) {
                s += this.storage[i];
            }
        } else {
            DataBlockIterator cols = this.columnsIterator();
            while (cols.hasNext()) {
                s += cols.next().sum();
            }
        }
        return s;
    }

    public double ssq() {
        if (this.isEmpty()) {
            return 0.0;
        }
        double s = 0.0;
        if (this.isFull()) {
            for (int i = 0; i < this.storage.length; ++i) {
                s += this.storage[i] * this.storage[i];
            }
        } else {
            DataBlockIterator cols = this.columnsIterator();
            while (cols.hasNext()) {
                s += cols.next().ssq();
            }
        }
        return s;
    }

    public double dot(FastMatrix m) {
        double p = 0.0;
        DataBlockIterator cols = this.columnsIterator();
        DataBlockIterator mcols = m.columnsIterator();
        while (cols.hasNext()) {
            p += cols.next().dot(mcols.next());
        }
        return p;
    }

    public void apply(int row, int col, DoubleUnaryOperator fn) {
        int idx = this.start + row + col * this.lda;
        this.storage[idx] = fn.applyAsDouble(this.storage[idx]);
    }

    public void apply(DoubleUnaryOperator fn) {
        if (this.isFull()) {
            for (int i = 0; i < this.storage.length; ++i) {
                this.storage[i] = fn.applyAsDouble(this.storage[i]);
            }
        } else {
            this.applyByColumns(col -> col.apply(fn));
        }
    }

    public void applyByRows(Consumer<DataBlock> fn) {
        DataBlockIterator rows = this.rowsIterator();
        while (rows.hasNext()) {
            fn.accept(rows.next());
        }
    }

    public void applyByColumns(Consumer<DataBlock> fn) {
        DataBlockIterator cols = this.columnsIterator();
        while (cols.hasNext()) {
            fn.accept(cols.next());
        }
    }

    public void applyByRows(FastMatrix M, BiConsumer<DataBlock, DataBlock> fn) {
        DataBlockIterator rows = this.rowsIterator();
        DataBlockIterator mrows = M.rowsIterator();
        while (rows.hasNext()) {
            fn.accept(rows.next(), mrows.next());
        }
    }

    public void applyByColumns(FastMatrix M, BiConsumer<DataBlock, DataBlock> fn) {
        DataBlockIterator cols = this.columnsIterator();
        DataBlockIterator mcols = M.columnsIterator();
        while (cols.hasNext()) {
            fn.accept(cols.next(), mcols.next());
        }
    }

    public Iterable<DataBlock> rows() {
        return () -> new Rows(this);
    }

    public Iterable<DataBlock> columns() {
        return () -> new Columns(this);
    }

    public void add(FastMatrix M) {
        if (this.nrows != M.nrows || this.ncols != M.ncols) {
            throw new MatrixException("m_err_dim");
        }
        if (this.isFull() && M.isFull()) {
            for (int i = 0; i < this.storage.length; ++i) {
                int n = i;
                this.storage[n] = this.storage[n] + M.storage[i];
            }
        } else {
            int end = this.start + this.ncols * this.lda;
            int i0 = this.start;
            int i1 = this.start + this.nrows;
            int j0 = M.start;
            while (i0 < end) {
                int k = i0;
                int l = j0;
                while (k < i1) {
                    int n = k++;
                    this.storage[n] = this.storage[n] + M.storage[l];
                    ++l;
                }
                i0 += this.lda;
                i1 += this.lda;
                j0 += M.lda;
            }
        }
    }

    public void addTranspose(FastMatrix M) {
        if (this.nrows != M.ncols || this.ncols != M.nrows) {
            throw new MatrixException("m_err_dim");
        }
        int end = this.start + this.ncols * this.lda;
        int i0 = this.start;
        int i1 = this.start + this.nrows;
        int j0 = M.start;
        while (i0 < end) {
            int k = i0;
            int l = j0;
            while (k < i1) {
                int n = k++;
                this.storage[n] = this.storage[n] + M.storage[l];
                l += M.lda;
            }
            i0 += this.lda;
            i1 += this.lda;
            ++j0;
        }
    }

    public void add(double d) {
        block5: {
            if (d == 0.0) break block5;
            if (this.isFull()) {
                int i = 0;
                while (i < this.storage.length) {
                    int n = i++;
                    this.storage[n] = this.storage[n] + d;
                }
            } else {
                int end = this.start + this.ncols * this.lda;
                int i0 = this.start;
                int i1 = this.start + this.nrows;
                while (i0 < end) {
                    int k = i0;
                    while (k < i1) {
                        int n = k++;
                        this.storage[n] = this.storage[n] + d;
                    }
                    i0 += this.lda;
                    i1 += this.lda;
                }
            }
        }
    }

    public void chs() {
        if (this.isFull()) {
            for (int i = 0; i < this.storage.length; ++i) {
                this.storage[i] = -this.storage[i];
            }
        } else {
            int end = this.start + this.ncols * this.lda;
            int i0 = this.start;
            int i1 = this.start + this.nrows;
            while (i0 < end) {
                for (int k = i0; k < i1; ++k) {
                    this.storage[k] = -this.storage[k];
                }
                i0 += this.lda;
                i1 += this.lda;
            }
        }
    }

    public void sub(FastMatrix M) {
        if (this.nrows != M.nrows || this.ncols != M.ncols) {
            throw new MatrixException("m_err_dim");
        }
        if (this.isFull() && M.isFull()) {
            for (int i = 0; i < this.storage.length; ++i) {
                int n = i;
                this.storage[n] = this.storage[n] - M.storage[i];
            }
        } else {
            int end = this.start + this.ncols * this.lda;
            int i0 = this.start;
            int i1 = this.start + this.nrows;
            int j0 = M.start;
            while (i0 < end) {
                int k = i0;
                int l = j0;
                while (k < i1) {
                    int n = k++;
                    this.storage[n] = this.storage[n] - M.storage[l];
                    ++l;
                }
                i0 += this.lda;
                i1 += this.lda;
                j0 += M.lda;
            }
        }
    }

    public void subTranspose(FastMatrix M) {
        if (this.nrows != M.ncols || this.ncols != M.nrows) {
            throw new MatrixException("m_err_dim");
        }
        int end = this.start + this.ncols * this.lda;
        int i0 = this.start;
        int i1 = this.start + this.nrows;
        int j0 = M.start;
        while (i0 < end) {
            int k = i0;
            int l = j0;
            while (k < i1) {
                int n = k++;
                this.storage[n] = this.storage[n] - M.storage[l];
                l += M.lda;
            }
            i0 += this.lda;
            i1 += this.lda;
            ++j0;
        }
    }

    public void sub(double d) {
        block6: {
            if (d == 0.0) break block6;
            if (this.isFull()) {
                int i = 0;
                while (i < this.storage.length) {
                    int n = i++;
                    this.storage[n] = this.storage[n] - d;
                }
            } else {
                int end = this.start + this.ncols * this.lda;
                int i0 = this.start;
                int i1 = this.start + this.nrows;
                while (i0 < end) {
                    int c = 0;
                    while (c < this.ncols) {
                        int k = i0;
                        while (k < i1) {
                            int n = k++;
                            this.storage[n] = this.storage[n] + d;
                        }
                        ++c;
                        i0 += this.lda;
                        i1 += this.lda;
                    }
                    i0 += this.lda;
                    i1 += this.lda;
                }
            }
        }
    }

    public void mul(double d) {
        block11: {
            block10: {
                if (d != 0.0) break block10;
                if (this.isFull()) {
                    for (int i = 0; i < this.storage.length; ++i) {
                        this.storage[i] = 0.0;
                    }
                } else {
                    int end = this.start + this.ncols * this.lda;
                    int i0 = this.start;
                    int i1 = this.start + this.nrows;
                    while (i0 < end) {
                        for (int k = i0; k < i1; ++k) {
                            this.storage[k] = 0.0;
                        }
                        i0 += this.lda;
                        i1 += this.lda;
                    }
                }
                break block11;
            }
            if (d == 1.0) break block11;
            if (this.isFull()) {
                int i = 0;
                while (i < this.storage.length) {
                    int n = i++;
                    this.storage[n] = this.storage[n] * d;
                }
            } else {
                int end = this.start + this.ncols * this.lda;
                int i0 = this.start;
                int i1 = this.start + this.nrows;
                while (i0 < end) {
                    int k = i0;
                    while (k < i1) {
                        int n = k++;
                        this.storage[n] = this.storage[n] * d;
                    }
                    i0 += this.lda;
                    i1 += this.lda;
                }
            }
        }
    }

    public void div(double d) {
        block11: {
            block10: {
                if (d != 0.0) break block10;
                if (this.isFull()) {
                    for (int i = 0; i < this.storage.length; ++i) {
                        this.storage[i] = Double.NaN;
                    }
                } else {
                    int end = this.start + this.ncols * this.lda;
                    int i0 = this.start;
                    int i1 = this.start + this.nrows;
                    while (i0 < end) {
                        for (int k = i0; k < i1; ++k) {
                            this.storage[k] = Double.NaN;
                        }
                        i0 += this.lda;
                        i1 += this.lda;
                    }
                }
                break block11;
            }
            if (d == 1.0) break block11;
            if (this.isFull()) {
                int i = 0;
                while (i < this.storage.length) {
                    int n = i++;
                    this.storage[n] = this.storage[n] / d;
                }
            } else {
                int end = this.start + this.ncols * this.lda;
                int i0 = this.start;
                int i1 = this.start + this.nrows;
                while (i0 < end) {
                    int k = i0;
                    while (k < i1) {
                        int n = k++;
                        this.storage[n] = this.storage[n] / d;
                    }
                    i0 += this.lda;
                    i1 += this.lda;
                }
            }
        }
    }

    public void addAY(double alpha, FastMatrix Y) {
        if (alpha == 0.0) {
            return;
        }
        DataBlockIterator cols = this.columnsIterator();
        DataBlockIterator ycols = Y.columnsIterator();
        while (cols.hasNext()) {
            cols.next().addAY(alpha, ycols.next());
        }
    }

    public void addAYt(double alpha, FastMatrix Y) {
        if (alpha == 0.0) {
            return;
        }
        DataBlockIterator cols = this.columnsIterator();
        DataBlockIterator ycols = Y.rowsIterator();
        while (cols.hasNext()) {
            cols.next().addAY(alpha, ycols.next());
        }
    }

    public void addXaYt(double a, DataBlock x, DataBlock y) {
        if (a == 0.0) {
            return;
        }
        double[] px = x.getStorage();
        double[] py = y.getStorage();
        int xinc = x.getIncrement();
        int yinc = y.getIncrement();
        int x0 = x.getStartPosition();
        int x1 = x.getEndPosition();
        int y0 = y.getStartPosition();
        int y1 = y.getEndPosition();
        int pos = this.start;
        int ypos = y0;
        while (ypos != y1) {
            double yc = py[ypos];
            if (yc != 0.0) {
                yc *= a;
                if (xinc == 1) {
                    cpos = pos;
                    for (xpos = x0; xpos < x1; ++xpos) {
                        int n = cpos++;
                        this.storage[n] = this.storage[n] + yc * px[xpos];
                    }
                } else {
                    cpos = pos;
                    for (xpos = x0; xpos != x1; xpos += xinc) {
                        int n = cpos++;
                        this.storage[n] = this.storage[n] + yc * px[xpos];
                    }
                }
            }
            ypos += yinc;
            pos += this.lda;
        }
    }

    public void addXaXt(double a, DataBlock x) {
        this.addXaYt(a, x, x);
    }

    public FastMatrix inv() {
        if (!this.isSquare()) {
            throw new IllegalArgumentException();
        }
        FastMatrix I = FastMatrix.identity(this.nrows);
        LUDecomposition lu = Gauss.decompose(this);
        lu.solve(I);
        return I;
    }

    public static LogSign logDeterminant(FastMatrix X) {
        if (!X.isSquare()) {
            throw new IllegalArgumentException();
        }
        if (X.nrows == 1) {
            double x00 = X.get(0, 0);
            return new LogSign(Math.log(Math.abs(x00)), x00 < 0.0);
        }
        HouseholderWithPivoting hous = new HouseholderWithPivoting();
        QRDecomposition qr = hous.decompose(X, 0);
        int rank = UpperTriangularMatrix.rank(qr.rawR(), 1.0E-13);
        if (rank < X.nrows) {
            return null;
        }
        return LogSign.of(qr.rawRdiagonal(), qr.pivotSign() == -1 != (X.nrows % 2 == 1));
    }

    public static double determinant(FastMatrix X) {
        try {
            if (X.nrows == 1) {
                return X.get(0, 0);
            }
            LogSign ls = FastMatrix.logDeterminant(X);
            if (ls == null) {
                return 0.0;
            }
            double val = Math.exp(ls.getValue());
            return ls.isPositive() ? val : -val;
        }
        catch (MatrixException err) {
            return 0.0;
        }
    }

    public DataBlock diagonal() {
        int n = Math.min(this.nrows, this.ncols);
        int inc = 1 + this.lda;
        return DataBlock.of(this.storage, this.start, this.start + inc * n, inc);
    }

    public DataBlock subDiagonal(int pos) {
        int n;
        if (pos >= this.ncols) {
            return DataBlock.EMPTY;
        }
        if (-pos >= this.nrows) {
            return DataBlock.EMPTY;
        }
        int beg = this.start;
        int inc = 1 + this.lda;
        if (pos > 0) {
            beg += pos * this.lda;
            n = Math.min(this.nrows, this.ncols - pos);
        } else if (pos < 0) {
            beg -= pos;
            n = Math.min(this.nrows + pos, this.ncols);
        } else {
            n = Math.min(this.nrows, this.ncols);
        }
        return DataBlock.of(this.storage, beg, beg + inc * n, inc);
    }

    public DataBlock row(int r) {
        int inc = this.lda;
        int beg = this.start + r;
        int end = beg + this.ncols * inc;
        return DataBlock.of(this.storage, beg, end, inc);
    }

    public DataBlock column(int c) {
        int beg = this.start + c * this.lda;
        int end = beg + this.nrows;
        return DataBlock.of(this.storage, beg, end, 1);
    }

    public DataBlock diagonal(int r0, int c0, int n) {
        int inc = this.lda + 1;
        int beg = this.start + c0 * this.lda + r0;
        int end = beg + n * inc;
        return DataBlock.of(this.storage, beg, end, inc);
    }

    public DataBlock skewDiagonal(int r0, int c0, int n) {
        int inc = 1 - this.lda;
        int beg = this.start + c0 * this.lda + r0;
        int end = beg + n * inc;
        return DataBlock.of(this.storage, beg, end, inc);
    }

    public DataBlock row(int r0, int c0, int n) {
        int beg = this.start + c0 * this.lda + r0;
        int end = beg + n * this.lda;
        return DataBlock.of(this.storage, beg, end, this.lda);
    }

    public DataBlock column(int r0, int c0, int n) {
        int beg = this.start + c0 * this.lda + r0;
        int end = beg + n;
        return DataBlock.of(this.storage, beg, end, 1);
    }

    public DataBlock rowSums() {
        if (this.isEmpty()) {
            return DataBlock.EMPTY;
        }
        DataBlockIterator cols = this.columnsIterator();
        DataBlock x = cols.next().deepClone();
        while (cols.hasNext()) {
            x.add(cols.next());
        }
        return x;
    }

    public DataBlock columnSums() {
        if (this.isEmpty()) {
            return DataBlock.EMPTY;
        }
        DataBlockIterator rows = this.rowsIterator();
        DataBlock x = rows.next().deepClone();
        while (rows.hasNext()) {
            x.add(rows.next());
        }
        return x;
    }

    public DataBlockIterator rowsIterator() {
        return new RCIterator(this.topOutside(), this.nrows, 1);
    }

    public DataBlockIterator reverseRowsIterator() {
        return new RCIterator(this.bottomOutside(), this.nrows, -1);
    }

    public DataBlockIterator columnsIterator() {
        return new RCIterator(this.leftOutside(), this.ncols, this.lda);
    }

    public DataBlockIterator reverseColumnsIterator() {
        return new RCIterator(this.rightOutside(), this.ncols, -this.lda);
    }

    public DataBlock topOutside() {
        int beg = this.start - 1;
        int inc = this.lda;
        return DataBlock.of(this.storage, beg, beg + this.ncols * inc, inc);
    }

    public DataBlock leftOutside() {
        int beg = this.start - this.lda;
        return DataBlock.of(this.storage, beg, beg + this.nrows, 1);
    }

    public DataBlock bottomOutside() {
        int beg = this.start + this.nrows;
        int inc = this.lda;
        return DataBlock.of(this.storage, beg, beg + this.ncols * inc, inc);
    }

    public DataBlock rightOutside() {
        int beg = this.start + this.lda * this.ncols;
        return DataBlock.of(this.storage, beg, beg + this.nrows, 1);
    }

    public FastMatrix plus(FastMatrix B) {
        FastMatrix AB = this.deepClone();
        AB.add(B);
        return AB;
    }

    public FastMatrix minus(FastMatrix B) {
        FastMatrix AB = this.deepClone();
        AB.sub(B);
        return AB;
    }

    public FastMatrix plus(double d) {
        FastMatrix AB = this.deepClone();
        AB.add(d);
        return AB;
    }

    public FastMatrix minus(double d) {
        FastMatrix AB = this.deepClone();
        AB.sub(d);
        return AB;
    }

    public FastMatrix times(double d) {
        FastMatrix AB = this.deepClone();
        AB.mul(d);
        return AB;
    }

    public FastMatrix dividedBy(double d) {
        FastMatrix AB = this.deepClone();
        AB.div(d);
        return AB;
    }

    public void upLeftShift(int n) {
        int del = (1 + this.lda) * n;
        int c = 0;
        int i = this.start;
        while (c < this.ncols - n) {
            int r = 0;
            int j = i;
            while (r < this.nrows - n) {
                this.storage[j] = this.storage[j + del];
                ++r;
                ++j;
            }
            ++c;
            i += this.lda;
        }
    }

    public void downRightShift(int n) {
        int del = (1 + this.lda) * n;
        int c = n;
        int i = this.start + (this.nrows - 1) + (this.ncols - 1) * this.lda;
        while (c < this.ncols) {
            int r = n;
            int j = i;
            while (r < this.nrows) {
                this.storage[j] = this.storage[j - del];
                ++r;
                --j;
            }
            ++c;
            i -= this.lda;
        }
    }

    public MatrixWindow all() {
        return new MatrixWindow(this.storage, this.lda, this.start, this.nrows, this.ncols);
    }

    public MatrixWindow topLeft(int nr, int nc) {
        return new MatrixWindow(this.storage, this.lda, this.start, nr, nc);
    }

    public MatrixWindow top(int nr) {
        return new MatrixWindow(this.storage, this.lda, this.start, nr, this.ncols);
    }

    public MatrixWindow left(int nc) {
        return new MatrixWindow(this.storage, this.lda, this.start, this.nrows, nc);
    }

    public MatrixWindow bottomRight() {
        int nstart = this.start + this.nrows + this.ncols * this.lda;
        return new MatrixWindow(this.storage, this.lda, nstart, 0, 0);
    }

    public MatrixWindow bottomRight(int nr, int nc) {
        int nstart = this.start + (this.nrows - nr) + (this.ncols - nc) * this.lda;
        return new MatrixWindow(this.storage, this.lda, nstart, nr, nc);
    }

    public MatrixWindow bottom(int nr) {
        return new MatrixWindow(this.storage, this.lda, this.start + this.nrows - nr, nr, this.ncols);
    }

    public MatrixWindow right(int nc) {
        return new MatrixWindow(this.storage, this.lda, this.start + (this.ncols - nc) * this.lda, this.nrows, nc);
    }

    public DataWindow top() {
        return DataWindow.windowOf(this.storage, this.start, this.start + this.ncols * this.lda, this.lda);
    }

    public DataWindow left() {
        return DataWindow.windowOf(this.storage, this.start, this.start + this.nrows, 1);
    }

    public DataWindow bottom() {
        int beg = this.start + (this.nrows - 1);
        return DataWindow.windowOf(this.storage, beg, beg + this.ncols * this.lda, this.lda);
    }

    public DataWindow right() {
        int beg = this.start + (this.ncols - 1) * this.lda;
        return DataWindow.windowOf(this.storage, beg, beg + this.nrows, 1);
    }

    public String toString(String fmt) {
        return Matrix.format((Matrix)this, (String)fmt);
    }

    public String toString() {
        return Matrix.format((Matrix)this);
    }

    public static class Builder {
        private final double[] storage;
        private int start = 0;
        private int lda;
        private int nrows;
        private int ncols;

        public Builder(double[] s) {
            this.storage = s;
        }

        public Builder start(int start) {
            this.start = start;
            return this;
        }

        public Builder nrows(int nrows) {
            this.nrows = nrows;
            return this;
        }

        public Builder ncolumns(int ncols) {
            this.ncols = ncols;
            return this;
        }

        public Builder columnIncrement(int lda) {
            this.lda = lda;
            return this;
        }

        public FastMatrix build() {
            if (this.lda != 0 && this.lda < this.nrows) {
                throw new MatrixException("m_err_dim");
            }
            return new FastMatrix(this.storage, this.lda == 0 ? this.nrows : this.lda, this.start, this.nrows, this.ncols);
        }
    }

    private static class RCIterator
    extends DataBlockIterator {
        private RCIterator(DataBlock block, int n, int inc) {
            super(block, n, inc);
        }
    }

    private static class Columns
    implements Iterator<DataBlock> {
        private int pos = 0;
        private final FastMatrix M;

        Columns(FastMatrix M) {
            this.M = M;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.M.ncols;
        }

        @Override
        public DataBlock next() {
            return this.M.column(this.pos++);
        }
    }

    private static class Rows
    implements Iterator<DataBlock> {
        private int pos = 0;
        private final FastMatrix M;

        Rows(FastMatrix M) {
            this.M = M;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.M.nrows;
        }

        @Override
        public DataBlock next() {
            return this.M.row(this.pos++);
        }
    }
}

