/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.distribution.NormalStatisticsProvider;
import dr.inference.model.GradientProvider;
import dr.math.ErrorFunction;
import dr.math.MathUtils;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.RandomGenerator;

public class NormalDistribution
implements Distribution,
RandomGenerator,
GradientProvider,
NormalStatisticsProvider {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return NormalDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double m;
    protected double sd;
    private static final double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
    private static final double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
    private static final double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
    private static final double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
    private static final double[] p_ = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
    private static final double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
    private static final int CUTOFF = 16;
    private static final double M_SQRT_32 = 5.656854249492381;
    private static final double M_1_SQRT_2PI = 0.3989422804014327;
    private static final double DBL_EPSILON = 2.220446049250313E-16;

    public NormalDistribution(double d, double d2) {
        this.m = d;
        this.sd = d2;
    }

    public double getMean() {
        return this.m;
    }

    public void setMean(double d) {
        this.m = d;
    }

    public double getSD() {
        return this.sd;
    }

    public void setSD(double d) {
        this.sd = d;
    }

    @Override
    public double pdf(double d) {
        return NormalDistribution.pdf(d, this.m, this.sd);
    }

    @Override
    public double logPdf(double d) {
        return NormalDistribution.logPdf(d, this.m, this.sd);
    }

    @Override
    public double cdf(double d) {
        return NormalDistribution.cdf(d, this.m, this.sd);
    }

    @Override
    public double quantile(double d) {
        return NormalDistribution.quantile(d, this.m, this.sd);
    }

    @Override
    public double mean() {
        return NormalDistribution.mean(this.m, this.sd);
    }

    @Override
    public double variance() {
        return NormalDistribution.variance(this.m, this.sd);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2, double d3) {
        double d4 = 1.0 / (Math.sqrt(Math.PI * 2) * d3);
        double d5 = -(d - d2) * (d - d2) / (2.0 * d3 * d3);
        return d4 * Math.exp(d5);
    }

    public static double logPdf(double d, double d2, double d3) {
        double d4 = 1.0 / (Math.sqrt(Math.PI * 2) * d3);
        double d5 = -(d - d2) * (d - d2) / (2.0 * d3 * d3);
        return Math.log(d4) + d5;
    }

    public static double gradLogPdf(double d, double d2, double d3) {
        return (d2 - d) / (d3 * d3);
    }

    public static double hessianLogPdf(double d, double d2, double d3) {
        return -1.0 / (d3 * d3);
    }

    public static double cdf(double d, double d2, double d3) {
        return NormalDistribution.cdf(d, d2, d3, false);
    }

    public static double quantile(double d, double d2, double d3) {
        return d2 + Math.sqrt(2.0) * d3 * ErrorFunction.inverseErf(2.0 * d - 1.0);
    }

    public static double mean(double d, double d2) {
        return d;
    }

    public static double variance(double d, double d2) {
        return d2 * d2;
    }

    public static double cdf(double d, double d2, double d3, boolean bl) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d) && d2 == d) {
            return Double.NaN;
        }
        if (d3 <= 0.0) {
            if (d3 < 0.0) {
                return Double.NaN;
            }
            return d < d2 ? 0.0 : 1.0;
        }
        double d4 = (d - d2) / d3;
        if (Double.isInfinite(d4)) {
            return d < d2 ? 0.0 : 1.0;
        }
        return NormalDistribution.standardCDF(d4, bl);
    }

    public static double standardCDF(double d, boolean bl) {
        boolean bl2 = false;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = d;
        double d3 = Double.NaN;
        double d4 = 1.110223E-16f;
        boolean bl3 = !bl2;
        boolean bl4 = bl2;
        double d5 = Math.abs(d);
        if (d5 <= 0.67448975) {
            double d6;
            double d7;
            if (d5 > d4) {
                double d8 = d * d;
                d7 = a[4] * d8;
                d6 = d8;
                for (int i = 0; i < 3; ++i) {
                    d7 = (d7 + a[i]) * d8;
                    d6 = (d6 + b[i]) * d8;
                }
            } else {
                d6 = 0.0;
                d7 = 0.0;
            }
            double d9 = d * (d7 + a[3]) / (d6 + b[3]);
            if (bl3) {
                d2 = 0.5 + d9;
            }
            if (bl4) {
                d3 = 0.5 - d9;
            }
            if (bl) {
                if (bl3) {
                    d2 = Math.log(d2);
                }
                if (bl4) {
                    d3 = Math.log(d3);
                }
            }
        } else if (d5 <= 5.656854249492381) {
            double d10 = c[8] * d5;
            double d11 = d5;
            for (int i = 0; i < 7; ++i) {
                d10 = (d10 + c[i]) * d5;
                d11 = (d11 + NormalDistribution.d[i]) * d5;
            }
            double d12 = (d10 + c[7]) / (d11 + NormalDistribution.d[7]);
            double d13 = (double)((int)(d5 * 16.0)) * 1.0 / 16.0;
            double d14 = (d5 - d13) * (d5 + d13);
            if (bl) {
                d2 = -d13 * d13 * 0.5 + -d14 * 0.5 + Math.log(d12);
                if (bl3 && d > 0.0 || bl4 && d <= 0.0) {
                    d3 = Math.log(1.0 - Math.exp(-d13 * d13 * 0.5) * Math.exp(-d14 * 0.5) * d12);
                }
            } else {
                d2 = Math.exp(-d13 * d13 * 0.5) * Math.exp(-d14 * 0.5) * d12;
                d3 = 1.0 - d2;
            }
            if (d > 0.0) {
                d12 = d2;
                if (bl3) {
                    d2 = d3;
                }
                d3 = d12;
            }
        } else if (bl || bl3 && -37.5193 < d && d < 8.2924 || bl4 && -8.2924 < d && d < 37.5193) {
            double d15 = 1.0 / (d * d);
            double d16 = p_[5] * d15;
            double d17 = d15;
            for (int i = 0; i < 4; ++i) {
                d16 = (d16 + p_[i]) * d15;
                d17 = (d17 + q[i]) * d15;
            }
            double d18 = d15 * (d16 + p_[4]) / (d17 + q[4]);
            d18 = (0.3989422804014327 - d18) / d5;
            d15 = (double)((int)(d * 16.0)) * 1.0 / 16.0;
            double d19 = (d - d15) * (d + d15);
            if (bl) {
                d2 = -d15 * d15 * 0.5 + -d19 * 0.5 + Math.log(d18);
                if (bl3 && d > 0.0 || bl4 && d <= 0.0) {
                    d3 = Math.log(1.0 - Math.exp(-d15 * d15 * 0.5) * Math.exp(-d19 * 0.5) * d18);
                }
            } else {
                d2 = Math.exp(-d15 * d15 * 0.5) * Math.exp(-d19 * 0.5) * d18;
                d3 = 1.0 - d2;
            }
            if (d > 0.0) {
                d18 = d2;
                if (bl3) {
                    d2 = d3;
                }
                d3 = d18;
            }
        } else if (d > 0.0) {
            d2 = 1.0;
            d3 = 0.0;
        } else {
            d2 = 0.0;
            d3 = 1.0;
        }
        return d2;
    }

    public static double standardTail(double d, boolean bl) {
        double d2;
        if (d < 0.0) {
            bl = !bl;
            d = -d;
        }
        if (d <= 8.0 || bl && d <= 37.0) {
            double d3 = 0.5 * d * d;
            d2 = d >= 1.28 ? 0.398942280385 * Math.exp(-d3) / (d - 3.8052E-8 + 1.00000615302 / (d + 3.98064794E-4 + 1.98615381364 / (d - 0.151679116635 + 5.29330324926 / (d + 4.8385912808 - 15.1508972451 / (d + 0.742380924027 + 30.789933034 / (d + 3.99019417011)))))) : 0.5 - d * (0.398942280444 - 0.399903438504 * d3 / (d3 + 5.75885480458 - 29.8213557808 / (d3 + 2.62433121679 + 48.6959930692 / (d3 + 5.92885724438))));
        } else {
            d2 = 0.0;
        }
        if (!bl) {
            d2 = 1.0 - d2;
        }
        return d2;
    }

    public static double tailCDF(double d, double d2, double d3) {
        return NormalDistribution.standardTail((d - d2) / d3, true);
    }

    public static double tailCDF(double d, double d2, double d3, boolean bl) {
        return NormalDistribution.standardTail((d - d2) / d3, bl);
    }

    public double tailCDF(double d) {
        return NormalDistribution.standardTail((d - this.m) / this.sd, true);
    }

    static void testTail(double d, double d2, double d3) {
        double d4 = NormalDistribution.cdf(d, d2, d3);
        double d5 = 1.0 - d4;
        double d6 = NormalDistribution.cdf(d, d2, d3, false);
        double d7 = 1.0 - d6;
        double d8 = NormalDistribution.tailCDF(d, d2, d3);
        System.out.println(">" + d + " N(" + d2 + ", " + d3 + ")");
        System.out.println("Original CDF: " + d5);
        System.out.println("     New CDF: " + d7);
        System.out.println("     tailCDF: " + d8);
    }

    public static void main(String[] stringArray) {
        NormalDistribution.testTail(0.1, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(1.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(5.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(7.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(8.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(8.25, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(10.0, 0.0, 1.0);
        System.out.println(NormalDistribution.standardCDF(4.0, true));
    }

    @Override
    public Object nextRandom() {
        double d = MathUtils.nextGaussian();
        d *= this.getSD();
        return d += this.getMean();
    }

    @Override
    public double logPdf(Object object) {
        double d = (Double)object;
        return this.logPdf(object);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = NormalDistribution.gradLogPdf(dArray[i], this.getMean(), this.getSD());
        }
        return dArray2;
    }

    @Override
    public double getNormalMean(int n) {
        return this.getMean();
    }

    @Override
    public double getNormalSD(int n) {
        return this.getSD();
    }
}

