/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.wrightfisher.FitnessFunction;

public class BakSneppenFitness
extends FitnessFunction {
    private double M = 2.0;

    public BakSneppenFitness(double d) {
        if (!(d >= 1.0)) {
            throw new IllegalArgumentException("M must be greater than or equal to 1");
        }
        this.M = d;
    }

    @Override
    public double getFitness(byte[] byArray) {
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) {
                d += d2;
            }
            d2 /= this.M;
        }
        return d;
    }

    @Override
    public double getFitnessFactor(int n, byte by, byte by2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] getFitnessTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initializeToFittest(byte[] byArray) {
        throw new UnsupportedOperationException();
    }
}

