/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.benchmarking;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;

public class SsfCholette {
    public static Builder builder(int conversion) {
        return new Builder(conversion);
    }

    public static class Builder {
        private double[] weights = null;
        private double rho = 0.9;
        private int start = 0;
        private final int conversion;

        private Builder(int conversion) {
            this.conversion = conversion;
        }

        public ISsf build() {
            CholetteDefinition def = new CholetteDefinition(this.conversion, this.start, this.rho, this.weights);
            return Ssf.of(this.rho == 1.0 ? new DiffuseInitialization() : new StationaryInitialization(this.rho), new Dynamics(def), new Loading(def));
        }

        public Builder rho(double rho) {
            this.rho = rho;
            return this;
        }

        public Builder weights(DoubleSeq weights) {
            this.weights = (double[])(weights != null ? weights.toArray() : null);
            return this;
        }

        public Builder start(int start) {
            this.start = start;
            return this;
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final CholetteDefinition def;

        Dynamics(CholetteDefinition def) {
            this.def = def;
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(1, 1, 1.0);
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            cm.set(1, 0, 1.0);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(1, 1, this.def.rho);
            int rpos = pos + this.def.start;
            if ((rpos + 1) % this.def.conversion != 0) {
                tr.set(0, 1, this.def.weight(pos));
                if (rpos % this.def.conversion != 0) {
                    tr.set(0, 0, 1.0);
                }
            }
        }

        @Override
        public void TX(int pos, DataBlock x) {
            int rpos = pos + this.def.start;
            if ((rpos + 1) % this.def.conversion == 0) {
                x.set(0, 0.0);
            } else if (rpos % this.def.conversion == 0) {
                double s = x.get(1);
                x.set(0, this.def.mweight(pos, s));
            } else {
                double s = x.get(1);
                x.add(0, this.def.mweight(pos, s));
            }
            x.mul(1, this.def.rho);
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            int rpos = pos + this.def.start;
            if ((rpos + 1) % this.def.conversion == 0) {
                vm.set(0, 0, 0.0);
                vm.set(1, 0, 0.0);
                vm.set(0, 1, 0.0);
            } else if (rpos % this.def.conversion == 0) {
                double w = this.def.weight(pos);
                double v = w * vm.get(1, 1);
                vm.set(0, 0, w * v);
                vm.set(1, 0, v * this.def.rho);
                vm.set(0, 1, v * this.def.rho);
            } else {
                double w = this.def.weight(pos);
                double v11 = vm.get(1, 1);
                double v01 = vm.get(0, 1);
                double z = (v01 + w * v11) * this.def.rho;
                vm.set(0, 1, z);
                vm.set(1, 0, z);
                vm.add(0, 0, w * (2.0 * v01 + w * v11));
            }
            vm.mul(1, 1, this.def.rho * this.def.rho);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(1, u.get(0));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(1, 1, 1.0);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            int rpos = pos + this.def.start;
            if ((rpos + 1) % this.def.conversion == 0) {
                x.set(0, 0.0);
                x.mul(1, this.def.rho);
            } else if (rpos % this.def.conversion == 0) {
                double x0 = x.get(0);
                double x1 = x.get(1);
                x.set(1, this.def.rho * x1 + this.def.mweight(pos, x0));
                x.set(0, 0.0);
            } else {
                double x0 = x.get(0);
                double x1 = x.get(1);
                x.set(1, this.def.rho * x1 + this.def.mweight(pos, x0));
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            x.set(0, 0.0);
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }

    static class DiffuseInitialization
    implements ISsfInitialization {
        DiffuseInitialization() {
        }

        @Override
        public int getStateDim() {
            return 2;
        }

        @Override
        public boolean isDiffuse() {
            return true;
        }

        @Override
        public int getDiffuseDim() {
            return 1;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.set(1, 0, 1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            pi0.set(1, 1, 1.0);
        }
    }

    static class StationaryInitialization
    implements ISsfInitialization {
        private final double rho;

        StationaryInitialization(double rho) {
            this.rho = rho;
        }

        @Override
        public int getStateDim() {
            return 2;
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public int getDiffuseDim() {
            return 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            pf0.set(1, 1, 1.0 / (1.0 - this.rho * this.rho));
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            pi0.set(1, 1, 1.0);
        }
    }

    static class Loading
    implements ISsfLoading {
        private final CholetteDefinition def;

        Loading(CholetteDefinition def) {
            this.def = def;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            int rpos = pos + this.def.start;
            if (rpos % this.def.conversion == 0) {
                z.set(0, 0.0);
            } else {
                z.set(0, 1.0);
            }
            z.set(1, this.def.weight(pos));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            int rpos = pos + this.def.start;
            double r = rpos % this.def.conversion == 0 ? 0.0 : x.get(0);
            return r + this.def.mweight(pos, x.get(1));
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            int rpos = pos + this.def.start;
            if (rpos % this.def.conversion == 0) {
                return this.def.mweight2(pos, V.get(1, 1));
            }
            double r = V.get(0, 0);
            r += this.def.mweight(pos, 2.0 * V.get(1, 0));
            return r += this.def.mweight2(pos, V.get(1, 1));
        }

        @Override
        public void VpZdZ(int pos, FastMatrix vm, double d) {
            if (d == 0.0) {
                return;
            }
            int rpos = pos + this.def.start;
            vm.add(1, 1, this.def.mweight2(pos, d));
            if (rpos % this.def.conversion != 0) {
                double w = this.def.mweight(pos, d);
                vm.add(0, 0, d);
                vm.add(0, 1, w);
                vm.add(1, 0, w);
            }
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            int rpos = pos + this.def.start;
            x.add(1, this.def.mweight(pos, d));
            if (rpos % this.def.conversion != 0) {
                x.add(0, d);
            }
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }

    static class CholetteDefinition {
        final double[] weights;
        final double rho;
        final int start;
        final int conversion;

        CholetteDefinition(int conv, int start, double rho, double[] w) {
            this.conversion = conv;
            this.weights = w;
            this.rho = rho;
            this.start = start;
        }

        double weight(int pos) {
            return this.weights == null ? 1.0 : this.weights[pos];
        }

        double mweight(int pos, double m) {
            return this.weights == null ? m : this.weights[pos] * m;
        }

        double mweight2(int pos, double m) {
            return this.weights == null ? m : this.weights[pos] * this.weights[pos] * m;
        }
    }
}

