/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.MatrixResults;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.akf.AugmentedUpdateInformation;
import jdplus.toolkit.base.core.ssf.akf.IAugmentedFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public class DefaultAugmentedFilteringResults
extends DefaultFilteringResults
implements IAugmentedFilteringResults {
    private final MatrixResults B = new MatrixResults();
    private final DataBlockResults E = new DataBlockResults();

    protected DefaultAugmentedFilteringResults(boolean var) {
        super(var);
    }

    public static DefaultAugmentedFilteringResults full() {
        return new DefaultAugmentedFilteringResults(true);
    }

    public static DefaultAugmentedFilteringResults light() {
        return new DefaultAugmentedFilteringResults(false);
    }

    @Override
    public void prepare(ISsf ssf, int start, int end) {
        super.prepare(ssf, start, end);
        ISsfInitialization initialization = ssf.initialization();
        int dim = initialization.getStateDim();
        int n = initialization.getDiffuseDim();
        this.B.prepare(dim, n, 0, n);
        this.E.prepare(dim, 0, n);
    }

    @Override
    public void save(int t, AugmentedUpdateInformation pe) {
        super.save(t, pe);
        this.E.save(t, pe.E());
    }

    @Override
    public void close(int pos) {
    }

    @Override
    public void save(int t, AugmentedState state, StateInfo info) {
        if (info != StateInfo.Forecast) {
            return;
        }
        super.save(t, state, info);
        this.B.save(t, state.B());
    }

    @Override
    public FastMatrix B(int pos) {
        return this.B.matrix(pos);
    }

    @Override
    public DataBlock E(int pos) {
        return this.E.datablock(pos);
    }

    @Override
    public void clear() {
        super.clear();
        this.B.clear();
    }
}

