/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.List;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class IVFactory
implements RegressionVariableFactory<InterventionVariable> {
    static IVFactory FACTORY = new IVFactory();

    private IVFactory() {
    }

    @Override
    public boolean fill(InterventionVariable var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int di;
        int dcount = buffer.getRowsCount();
        List seqs = var.getSequences();
        if (seqs.isEmpty()) {
            return true;
        }
        LocalDateTime t0 = LocalDateTime.MAX;
        LocalDateTime t1 = LocalDateTime.MIN;
        for (Range seq : seqs) {
            if (t0.isAfter((ChronoLocalDateTime)seq.start())) {
                t0 = (LocalDateTime)seq.start();
            }
            if (!t1.isBefore((ChronoLocalDateTime)seq.end())) continue;
            t1 = (LocalDateTime)seq.end();
        }
        TsPeriod pstart = start.withDate(t0);
        TsPeriod pend = start.withDate(t1);
        int n = dcount - start.until(pstart);
        if (n < 0) {
            return true;
        }
        double[] tmp = new double[n];
        for (Range seq : seqs) {
            TsPeriod curstart = start.withDate((LocalDateTime)seq.start());
            TsPeriod curend = start.withDate((LocalDateTime)seq.end());
            int istart = pstart.until(curstart);
            int iend = 1 + pstart.until(curend);
            if (iend > n) {
                iend = n;
            }
            int j = istart;
            while (j < iend) {
                int n2 = j++;
                tmp[n2] = tmp[n2] + 1.0;
            }
        }
        double delta = var.getDelta();
        double deltas = var.getDeltaSeasonal();
        int freq = start.getUnit().getAnnualFrequency();
        if (delta != 0.0 || deltas != 0.0) {
            Polynomial d;
            Polynomial num = Polynomial.ONE;
            Polynomial polynomial = d = delta != 0.0 ? Polynomial.valueOf(1.0, -delta) : Polynomial.ONE;
            if (freq != 1 && deltas != 0.0) {
                double[] ds = new double[freq + 1];
                ds[0] = 1.0;
                ds[freq] = -deltas;
                d = d.times(Polynomial.of(ds));
            }
            RationalFunction rf = RationalFunction.of(num, d);
            double[] w = rf.coefficients(n);
            double[] ftmp = new double[n];
            for (int i = 0; i < ftmp.length; ++i) {
                if (tmp[i] == 0.0) continue;
                for (int j = 0; j < ftmp.length - i; ++j) {
                    int n3 = i + j;
                    ftmp[n3] = ftmp[n3] + tmp[i] * w[j];
                }
            }
            tmp = ftmp;
        }
        if ((di = start.until(pstart)) > 0) {
            buffer.column(0).drop(di, 0).copyFrom(tmp, 0);
        } else {
            buffer.column(0).copyFrom(tmp, -di);
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(InterventionVariable var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

