/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.transformation;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.transformation.DataTransformation;
import jdplus.toolkit.base.core.data.transformation.ExpTransformation;
import jdplus.toolkit.base.core.data.transformation.LogJacobian;

public class LogTransformation
implements DataTransformation {
    public static final LogTransformation EXEMPLAR = new LogTransformation();

    public boolean canTransform(DoubleSeq data) {
        return data.allMatch(x -> Double.isFinite(x) ? x > 0.0 : true);
    }

    @Override
    public DataTransformation converse() {
        return ExpTransformation.EXEMPLAR;
    }

    @Override
    public DoubleSeq transform(DoubleSeq data, LogJacobian ljacobian) {
        double[] x = data.toArray();
        for (int i = 0; i < x.length; ++i) {
            if (!Double.isFinite(x[i])) continue;
            x[i] = Math.log(x[i]);
        }
        if (ljacobian != null) {
            double s = 0.0;
            if (ljacobian.missing == null) {
                for (int i = ljacobian.start; i < ljacobian.end; ++i) {
                    if (!Double.isFinite(x[i])) continue;
                    s += x[i];
                }
            } else {
                int imissing;
                int nmissing = ljacobian.missing.length;
                int ic = ljacobian.start;
                for (imissing = 0; imissing < nmissing && ljacobian.missing[imissing] < ic; ++imissing) {
                }
                while (imissing != nmissing && ic < ljacobian.end) {
                    if (ic == ljacobian.missing[imissing]) {
                        ++ic;
                        ++imissing;
                        continue;
                    }
                    s += x[ic++];
                }
                while (ic < ljacobian.end) {
                    s += x[ic++];
                }
            }
            ljacobian.value -= s;
        }
        return DoubleSeq.of((double[])x);
    }

    @Override
    public double transform(double x) {
        return x <= 0.0 ? Double.NaN : Math.log(x);
    }
}

