/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropModXY
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final int mod;
    private IntIterableBitSet usedValues;

    public PropModXY(IntVar x, int mod, IntVar y) {
        super((Variable[])new IntVar[]{x, y}, (Priority)PropagatorPriority.BINARY, false);
        this.x = x;
        this.y = y;
        this.mod = mod;
        if (y.hasEnumeratedDomain()) {
            this.usedValues = new IntIterableBitSet();
            this.usedValues.setOffset(y.getLB());
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.y.getLB() < 0) {
            this.y.updateLowerBound(-(this.mod - 1), (ICause)this);
        }
        if (this.y.getUB() > 0) {
            this.y.updateUpperBound(this.mod - 1, (ICause)this);
        }
        if (this.x.getUB() <= 0) {
            this.y.updateUpperBound(0, (ICause)this);
        }
        if (this.x.getLB() >= 0) {
            this.y.updateLowerBound(0, (ICause)this);
        }
        if (this.x.hasEnumeratedDomain() && this.y.hasEnumeratedDomain()) {
            this.propagateEnumerated();
        } else {
            this.propagateBounded();
        }
    }

    private void propagateEnumerated() throws ContradictionException {
        this.usedValues.clear();
        int v = this.x.getLB();
        while (v <= this.x.getUB()) {
            if (this.y.contains(v % this.mod)) {
                this.usedValues.add(v % this.mod);
            } else {
                this.x.removeValue(v, (ICause)this);
            }
            v = this.x.nextValue(v);
        }
        this.y.removeAllValuesBut(this.usedValues, this);
    }

    private void propagateBounded() throws ContradictionException {
        boolean hasChange = true;
        while (hasChange) {
            hasChange = false;
            while (!this.y.contains(this.x.getLB() % this.mod)) {
                this.x.updateLowerBound(this.x.getLB() + 1, (ICause)this);
                hasChange = true;
            }
            while (!this.y.contains(this.x.getUB() % this.mod)) {
                this.x.updateUpperBound(this.x.getUB() - 1, (ICause)this);
                hasChange = true;
            }
            while (!PropModXY.containsOneDivid(this.x, this.mod, this.y.getLB())) {
                this.y.updateLowerBound(this.y.getLB() + 1, (ICause)this);
                hasChange = true;
            }
            while (!PropModXY.containsOneDivid(this.x, this.mod, this.y.getUB())) {
                this.y.updateUpperBound(this.y.getUB() - 1, (ICause)this);
                hasChange = true;
            }
        }
    }

    private static boolean containsOneDivid(IntVar X, int mod, int value) {
        int i = X.getLB();
        while (i <= X.getUB()) {
            if (i % mod == value) {
                return true;
            }
            i = X.nextValue(i);
        }
        return false;
    }

    @Override
    public ESat isEntailed() {
        if (this.x.isInstantiated() && this.y.isInstantiated()) {
            return this.x.getValue() % this.mod == this.y.getValue() ? ESat.TRUE : ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.x.getName() + " % " + this.mod + " = " + this.y.getName();
    }
}

