/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.ISolver;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.QuickXPlain;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.InvalidSolutionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.objective.IBoundsManager;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.objective.ObjectiveFactory;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.loop.Reporting;
import org.chocosolver.solver.search.loop.learn.LazyClauseGeneration;
import org.chocosolver.solver.search.loop.learn.Learn;
import org.chocosolver.solver.search.loop.learn.LearnNothing;
import org.chocosolver.solver.search.loop.monitors.ISearchMonitor;
import org.chocosolver.solver.search.loop.monitors.SearchMonitorList;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.loop.move.MoveBinaryDFS;
import org.chocosolver.solver.search.loop.move.MoveSeq;
import org.chocosolver.solver.search.loop.propagate.Propagate;
import org.chocosolver.solver.search.measure.IMeasures;
import org.chocosolver.solver.search.measure.MeasuresRecorder;
import org.chocosolver.solver.search.restart.AbstractRestart;
import org.chocosolver.solver.search.restart.ForceRestartBeforeCut;
import org.chocosolver.solver.search.strategy.BlackBoxConfigurator;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.search.strategy.strategy.WarmStart;
import org.chocosolver.solver.trace.IOutputFactory;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.criteria.Criterion;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.logger.ANSILogger;
import org.chocosolver.util.logger.Logger;

public final class Solver
implements ISolver,
IMeasures,
IOutputFactory {
    private Learn L;
    private Move M;
    private final Model mModel;
    private final MiniSat mSat;
    private IObjectiveManager objectivemanager;
    private Action action;
    private final MeasuresRecorder mMeasures;
    private final DecisionPath dpath;
    private int rootWorldIndex = 0;
    private int searchWorldIndex = 0;
    private final List<Criterion> criteria;
    private boolean defaultSearch = false;
    private boolean completeSearch = false;
    private final SearchMonitorList searchMonitors;
    private PropagationEngine engine;
    private final ContradictionException exception;
    private ESat feasible = ESat.UNDEFINED;
    private int jumpTo;
    private boolean stop;
    private boolean canBeRepaired = true;
    private AbstractRestart restarter;
    private Solution lastSol = null;
    private WarmStart warmStart = null;
    private Logger logger = new ANSILogger();

    Solver(Model aModel) {
        this.mModel = aModel;
        this.exception = new ContradictionException();
        this.objectivemanager = ObjectiveFactory.SAT();
        this.dpath = new DecisionPath(aModel.getEnvironment());
        this.action = Action.initialize;
        this.mMeasures = new MeasuresRecorder(this.mModel.getName());
        this.criteria = new ArrayList<Criterion>();
        this.mMeasures.setSearchState(SearchState.NEW);
        this.mMeasures.setBoundsManager(this.objectivemanager);
        this.searchMonitors = new SearchMonitorList();
        this.M = new MoveBinaryDFS();
        this.L = new LearnNothing();
        this.restarter = AbstractRestart.NO_RESTART;
        if (this.mModel.getSettings().isLCG()) {
            this.mSat = new MiniSat(true);
            this.setLearner(new LazyClauseGeneration(this, this.mSat));
        } else {
            this.mSat = null;
        }
        this.engine = new PropagationEngine(this.mModel, this.mSat);
    }

    public void throwsException(ICause c, Variable v, String s) throws ContradictionException {
        throw this.exception.set(c, v, s);
    }

    public void throwsException(ICause c, Variable v, String s, Reason reason) throws ContradictionException {
        if (this.isLCG()) {
            this.mSat.cEnqueue(0, c.manageReification().apply(reason));
        }
        this.throwsException(c, v, s);
    }

    public ContradictionException getContradictionException() {
        return this.exception;
    }

    public boolean solve() {
        boolean satPb;
        this.mMeasures.setSearchState(SearchState.RUNNING);
        boolean bl = satPb = this.getModel().getResolutionPolicy() == ResolutionPolicy.SATISFACTION;
        if (this.getModel().getObjective() == null && !satPb) {
            throw new SolverException("No objective variable has been defined whereas policy implies optimization");
        }
        boolean bl2 = this.stop = !this.canBeRepaired;
        if (this.action == Action.initialize) {
            this.searchMonitors.beforeInitialize();
            boolean ok = this.initialize();
            this.searchMonitors.afterInitialize(ok);
        }
        boolean newSolutionFound = this.searchLoop();
        this.searchMonitors.beforeClose();
        this.closeSearch();
        this.searchMonitors.afterClose();
        return newSolutionFound;
    }

    public boolean searchLoop() {
        boolean solution = false;
        boolean left = true;
        Thread th = Thread.currentThread();
        block7: while (!this.stop) {
            this.stop = this.isStopCriterionMet();
            if (this.stop || th.isInterrupted()) {
                if (this.stop) {
                    this.mMeasures.setSearchState(SearchState.STOPPED);
                } else {
                    this.mMeasures.setSearchState(SearchState.KILLED);
                }
            }
            switch (this.action.ordinal()) {
                case 0: {
                    throw new UnsupportedOperationException("should not initialize during search loop");
                }
                case 1: {
                    this.propagate(left);
                    continue block7;
                }
                case 2: {
                    left = true;
                    this.extend();
                    continue block7;
                }
                case 4: {
                    left = false;
                    this.repair();
                    continue block7;
                }
                case 3: {
                    this.stop = solution = this.validate();
                    continue block7;
                }
            }
            throw new SolverException("Invalid Solver loop action " + (Object)((Object)this.action));
        }
        return solution;
    }

    private boolean initialize() {
        boolean ok = true;
        this.checkDeclaredConstraints();
        this.checkExplainedVariables();
        this.checkExplainedConstraints();
        this.engine.initialize();
        this.getMeasures().setReadingTimeCount(System.nanoTime() - this.mModel.getCreationTime());
        this.mMeasures.startStopwatch();
        this.rootWorldIndex = this.mModel.getEnvironment().getWorldIndex();
        this.M.setTopDecisionPosition(0);
        this.pushTrail();
        try {
            this.checkTasks();
            this.mMeasures.incFixpointCount();
            if (this.isLCG() && !this.getSat().ok_) {
                this.throwsException(Cause.Sat, null, null);
            }
            this.doPropagate();
            this.action = Action.extend;
            this.pushTrail();
            this.searchWorldIndex = this.mModel.getEnvironment().getWorldIndex();
            this.pushTrail();
            this.L.init();
        }
        catch (ContradictionException ce) {
            this.engine.flush();
            this.mMeasures.incFailCount();
            this.searchMonitors.onContradiction(ce);
            this.cancelTrail();
            this.stop = true;
            ok = false;
        }
        if (this.M.getChildMoves().size() <= 1 && this.M.getStrategy() == null) {
            if (this.getModel().getSettings().warnUser()) {
                this.logger.white().println("No search strategies defined.");
                this.logger.white().println("Set to default ones.");
            }
            this.defaultSearch = true;
            this.mModel.getSettings().makeDefaultSearch(this.mModel);
        }
        this.preprocessing(this.getModel().getSettings().getTimeLimitForPreprocessing());
        if (this.completeSearch && !this.defaultSearch) {
            BlackBoxConfigurator bb = BlackBoxConfigurator.init();
            bb.complete(this.mModel, this.M.getStrategy());
        }
        if (this.warmStart != null) {
            AbstractStrategy<Variable> declared = this.M.getStrategy();
            this.warmStart.setStrategy(declared);
            this.setSearch(this.warmStart);
        }
        if (this.isLCG() && this.getObjectiveManager().isOptimization()) {
            this.setRestartOnSolutions();
        }
        this.restarter.init();
        if (!this.M.init()) {
            this.cancelTrail();
            this.feasible = ESat.FALSE;
            this.engine.flush();
            this.getMeasures().incFailCount();
            this.stop = true;
            ok = true;
        }
        this.criteria.stream().filter(c -> c instanceof ICounter).forEach(c -> ((ICounter)c).init());
        return ok;
    }

    private void checkDeclaredConstraints() {
        Optional<Constraint> undeclared;
        Set instances;
        if (this.mModel.getSettings().checkDeclaredConstraints() && (instances = (Set)this.mModel.getHook("cinstances")) != null && (undeclared = instances.stream().filter(c -> c.getStatus() == Constraint.Status.FREE).findFirst()).isPresent()) {
            this.logger.white().println("At least one constraint is free, i.e., neither posted or reified. ).");
            instances.stream().filter(c -> c.getStatus() == Constraint.Status.FREE).limit(this.mModel.getSettings().printAllUndeclaredConstraints() ? Integer.MAX_VALUE : 1L).forEach(c -> this.logger.white().printf(String.format("%s is free\n", c), new Object[0]));
        }
    }

    private void checkExplainedVariables() {
        if (this.isLCG()) {
            HashSet<String> warned = new HashSet<String>();
            int c = 0;
            int e = 0;
            for (Variable var : this.getModel().getVars()) {
                boolean isExplained = false;
                boolean isPartial = false;
                Annotation[] annotations = var.getClass().getAnnotations();
                String comment = "";
                for (Annotation annotation : annotations) {
                    if (!Objects.equals(annotation.annotationType(), Explained.class)) continue;
                    isExplained = true;
                    isPartial |= ((Explained)annotation).partial();
                    comment = ((Explained)annotation).comment();
                    ++e;
                }
                ++c;
                if (!isExplained) {
                    if (!this.getModel().getSettings().warnUser() || warned.contains(var.getClass().getSimpleName())) continue;
                    warned.add(var.getClass().getSimpleName());
                    this.logger.white().println("Warning: " + var.getClass().getSimpleName() + " is not explained.");
                    continue;
                }
                if (!isPartial || !this.getModel().getSettings().warnUser() || warned.contains(var.getClass().getSimpleName())) continue;
                warned.add(var.getClass().getSimpleName());
                this.logger.white().println("Warning: " + var.getClass().getSimpleName() + " is partially explained" + (!comment.isEmpty() ? " (" + comment + ".)" : "."));
            }
            if (this.getModel().getSettings().warnUser() && e < c) {
                this.logger.printf("%.2f%% variables are explained\n", (double)e * 100.0 / (double)c);
            }
            warned.clear();
        }
    }

    private void checkExplainedConstraints() {
        if (this.isLCG()) {
            HashSet<String> warned = new HashSet<String>();
            int c = 0;
            int e = 0;
            for (Constraint cstr : this.getModel().getCstrs()) {
                for (Propagator propagator : cstr.getPropagators()) {
                    boolean isExplained = false;
                    boolean isPartial = false;
                    Annotation[] annotations = propagator.getClass().getAnnotations();
                    String comment = "";
                    for (Annotation annotation : annotations) {
                        if (!Objects.equals(annotation.annotationType(), Explained.class)) continue;
                        isExplained = true;
                        isPartial |= ((Explained)annotation).partial();
                        comment = ((Explained)annotation).comment();
                        ++e;
                    }
                    ++c;
                    if (!isExplained) {
                        if (!this.getModel().getSettings().warnUser() || warned.contains(propagator.getClass().getSimpleName())) continue;
                        warned.add(propagator.getClass().getSimpleName());
                        this.logger.white().println("Warning: " + propagator.getClass().getSimpleName() + " is not explained.");
                        continue;
                    }
                    if (!isPartial || !this.getModel().getSettings().warnUser() || warned.contains(propagator.getClass().getSimpleName())) continue;
                    warned.add(propagator.getClass().getSimpleName());
                    this.logger.white().println("Warning: " + propagator.getClass().getSimpleName() + " is partially explained" + (!comment.isEmpty() ? " (" + comment + ".)" : "."));
                }
            }
            if (this.getModel().getSettings().warnUser() && e < c) {
                this.logger.printf("%.2f%% propagators are explained\n", (double)e * 100.0 / (double)c);
            }
            warned.clear();
        }
    }

    private void checkTasks() throws ContradictionException {
        if (this.mModel.getHook("H_TASKSET") != null) {
            ArrayList tset = (ArrayList)this.mModel.getHook("H_TASKSET");
            for (int i = 0; i < tset.size(); ++i) {
                ((Task)tset.get(i)).ensureBoundConsistency();
            }
        }
    }

    public void pushTrail() {
        this.mModel.getEnvironment().worldPush();
        if (this.isLCG()) {
            this.mSat.pushTrailMarker();
        }
    }

    public void cancelTrail() {
        this.mModel.getEnvironment().worldPop();
        if (this.isLCG() && this.mSat.trailMarker() > this.mModel.getEnvironment().getWorldIndex()) {
            this.mSat.cancel();
        }
    }

    public void preprocessing(long timeLimitInMS) {
        if (!this.getEngine().isInitialized()) {
            throw new SolverException("A call to solver.propagate() must be done before calling solver.preprocessing()");
        }
        if (timeLimitInMS > 0L && this.getModel().getSettings().warnUser()) {
            this.logger.white().printf("Running preprocessing step (%dms).\n", timeLimitInMS);
        }
        long tl = System.currentTimeMillis() + timeLimitInMS;
        IntVar[] ivars = this.mModel.retrieveIntVars(true);
        block2: for (int i = 0; i < ivars.length; ++i) {
            IntVar v = ivars[i];
            if (v.isInstantiated()) continue;
            DisposableValueIterator it = v.getValueIterator(true);
            while (it.hasNext()) {
                if (System.currentTimeMillis() > tl) break block2;
                int a = it.next();
                if (this.hasSupport(v, a)) continue;
                try {
                    v.removeValue(a, (ICause)Cause.Null);
                    if (!this.getModel().getSettings().warnUser()) continue;
                    this.logger.white().printf("Preprocessing removed value %d from %s\n", a, v.getName());
                }
                catch (ContradictionException e) {
                    throw new SolverException("Preprocessing failed");
                }
            }
            it.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSupport(IntVar var, int val) {
        this.mModel.getEnvironment().worldPush();
        try {
            var.instantiateTo(val, (ICause)Cause.Null);
            this.mModel.getSolver().getEngine().propagate();
            boolean bl = true;
            return bl;
        }
        catch (ContradictionException e) {
            this.mModel.getSolver().getEngine().flush();
            boolean bl = false;
            return bl;
        }
        finally {
            this.mModel.getEnvironment().worldPop();
        }
    }

    private void doPropagate() throws ContradictionException {
        this.dpath.buildNext();
        this.objectivemanager.postDynamicCut();
        this.engine.propagate();
        this.dpath.apply();
        this.engine.propagate();
    }

    private void propagate(boolean left) {
        this.searchMonitors.beforeDownBranch(left);
        try {
            this.mMeasures.incFixpointCount();
            this.doPropagate();
            this.action = Action.extend;
        }
        catch (ContradictionException ce) {
            this.engine.flush();
            this.mMeasures.incFailCount();
            this.jumpTo = 1;
            this.action = Action.repair;
            this.searchMonitors.onContradiction(ce);
        }
        this.searchMonitors.afterDownBranch(left);
    }

    private void extend() {
        this.searchMonitors.beforeOpenNode();
        this.mMeasures.incNodeCount();
        this.action = Action.propagate;
        if (this.restarter.mustRestart(this)) {
            this.restart();
            this.L.forget();
        } else if (!this.M.extend(this)) {
            this.action = Action.validate;
        }
        this.searchMonitors.afterOpenNode();
    }

    private void repair() {
        this.L.record();
        this.action = Action.propagate;
        this.searchMonitors.beforeUpBranch();
        if (this.restarter.mustRestart(this)) {
            this.canBeRepaired = true;
            this.restart();
        } else {
            this.canBeRepaired = this.M.repair(this);
        }
        this.searchMonitors.afterUpBranch();
        if (!this.canBeRepaired) {
            this.stop = true;
        } else {
            this.L.forget();
        }
    }

    private boolean validate() {
        boolean bestSolutionHasBeenUpdated;
        if (!this.getModel().getSettings().checkModel(this)) {
            throw new InvalidSolutionException("The current solution does not satisfy the checker.Either (a) the search strategy is not complete or (b) the model is not constrained enough or (c) a constraint's checker (\"isSatisfied()\") is not correct or (d) some constraints' filtering algorithm (\"propagate(...)\") is not correct.\n" + Reporting.fullReport(this.mModel), this.mModel);
        }
        this.feasible = ESat.TRUE;
        this.mMeasures.incSolutionCount();
        if (this.mModel.getResolutionPolicy() == ResolutionPolicy.SATISFACTION && this.mMeasures.getSolutionCount() == 1L) {
            this.mMeasures.updateTimeToBestSolution();
        } else if (this.mModel.getResolutionPolicy() != ResolutionPolicy.SATISFACTION && (bestSolutionHasBeenUpdated = this.objectivemanager.updateBestSolution())) {
            this.mMeasures.updateTimeToBestSolution();
        }
        this.searchMonitors.onSolution();
        this.jumpTo = 1;
        this.action = Action.repair;
        return true;
    }

    private void closeSearch() {
        if (this.mMeasures.getSearchState() == SearchState.RUNNING) {
            this.mMeasures.setSearchState(SearchState.TERMINATED);
        }
        this.feasible = ESat.FALSE;
        if (this.mMeasures.getSolutionCount() > 0L) {
            this.feasible = ESat.TRUE;
            if (this.objectivemanager.isOptimization()) {
                this.mMeasures.setObjectiveOptimal(!this.isStopCriterionMet());
            }
        } else if (this.isStopCriterionMet()) {
            this.mMeasures.setObjectiveOptimal(false);
            this.feasible = ESat.UNDEFINED;
        }
    }

    public void reset() {
        if (this.rootWorldIndex > -1) {
            this.mModel.getEnvironment().worldPopUntil(this.rootWorldIndex);
        }
        this.searchWorldIndex = 0;
        this.action = Action.initialize;
        this.mMeasures.reset();
        this.engine.reset();
        this.dpath.synchronize();
        this.objectivemanager.resetBestBounds();
        this.removeAllStopCriteria();
        this.feasible = ESat.UNDEFINED;
        this.jumpTo = 0;
        this.stop = false;
        this.canBeRepaired = true;
    }

    public void hardReset() {
        this.reset();
        this.M.removeStrategy();
        this.setMove(new MoveBinaryDFS());
        this.setNoLearning();
        this.lastSol = null;
        if (this.warmStart != null) {
            this.warmStart.clearHints();
            this.warmStart = null;
        }
        this.searchMonitors.reset();
        this.defaultSearch = false;
        this.completeSearch = false;
        this.mModel.removeMinisat();
    }

    public void propagate() throws ContradictionException {
        if (!this.engine.isInitialized()) {
            this.engine.initialize();
        }
        this.checkTasks();
        try {
            this.engine.propagate();
        }
        finally {
            this.engine.flush();
        }
    }

    public List<Constraint> findMinimumConflictingSet(List<Constraint> conflictingSet) {
        if (this.isSolving()) {
            throw new SolverException("Minimum Conflicting Set (MCS) can't be executed during solving");
        }
        return new QuickXPlain(this.getModel()).findMinimumConflictingSet(conflictingSet);
    }

    public void restart() {
        this.searchMonitors.beforeRestart();
        this.restoreRootNode();
        this.pushTrail();
        this.getMeasures().incRestartCount();
        try {
            this.objectivemanager.postDynamicCut();
            this.mMeasures.incFixpointCount();
            this.doPropagate();
            this.action = Action.extend;
        }
        catch (ContradictionException e) {
            this.stop = true;
        }
        this.searchMonitors.afterRestart();
    }

    private void restoreRootNode() {
        IEnvironment environment = this.mModel.getEnvironment();
        while (environment.getWorldIndex() > this.searchWorldIndex) {
            this.getMeasures().incBackTrackCount();
            this.cancelTrail();
        }
        this.dpath.synchronize();
    }

    public void onReceivingExternalCut(int newBestVal) {
        if (this.isLCG()) {
            ForceRestartBeforeCut rbc = this.getRestartBeforeCut();
            rbc.storeCut(newBestVal);
        } else {
            this.getObjectiveManager().updateBestSolution(newBestVal);
        }
    }

    private ForceRestartBeforeCut getRestartBeforeCut() {
        ForceRestartBeforeCut rbc;
        AbstractRestart rst;
        for (rst = this.getRestarter(); rst != null && !(rst instanceof ForceRestartBeforeCut); rst = rst.getNext()) {
        }
        if (rst == null) {
            rbc = new ForceRestartBeforeCut(this);
            rbc.setNext(this.restarter);
            this.restarter = rbc;
        } else {
            rbc = (ForceRestartBeforeCut)rst;
        }
        return rbc;
    }

    public boolean moveForward(Decision<?> decision) {
        if (!this.engine.isInitialized()) {
            this.engine.initialize();
        }
        if (this.getEnvironment().getWorldIndex() == 0) {
            this.getEnvironment().worldPush();
        }
        boolean success = true;
        if (decision != null) {
            this.getDecisionPath().pushDecision(decision);
            this.getEnvironment().worldPush();
            this.getDecisionPath().buildNext();
        }
        try {
            this.getDecisionPath().apply();
            this.getObjectiveManager().postDynamicCut();
            this.getEngine().propagate();
        }
        catch (ContradictionException cex) {
            this.engine.flush();
            success = false;
        }
        return success;
    }

    public boolean moveBackward() {
        this.getEnvironment().worldPop();
        boolean success = false;
        Decision head = this.dpath.getLastDecision();
        while (!success && head.getPosition() > 0) {
            if (head.hasNext()) {
                this.getEnvironment().worldPush();
                this.getDecisionPath().buildNext();
                try {
                    this.getDecisionPath().apply();
                    this.getObjectiveManager().postDynamicCut();
                    this.getEngine().propagate();
                    success = true;
                }
                catch (ContradictionException cex) {
                    this.engine.flush();
                }
            } else {
                this.dpath.synchronize();
                this.getEnvironment().worldPop();
            }
            head = this.dpath.getLastDecision();
        }
        return success;
    }

    public boolean isSolving() {
        boolean isSearching = this.getSearchState() != SearchState.NEW;
        boolean isTrailing = this.getEnvironment().getWorldIndex() > this.rootWorldIndex;
        return isSearching || isTrailing;
    }

    public Model getModel() {
        return this.mModel;
    }

    public boolean isLCG() {
        return this.mSat != null;
    }

    public MiniSat getSat() {
        return this.mSat;
    }

    public Learn getLearner() {
        return this.L;
    }

    public Move getMove() {
        return this.M;
    }

    @Deprecated
    public Propagate getPropagate() {
        return null;
    }

    public IEnvironment getEnvironment() {
        return this.getModel().getEnvironment();
    }

    public DecisionPath getDecisionPath() {
        return this.dpath;
    }

    public <V extends Variable> AbstractStrategy<V> getSearch() {
        if (this.M.getChildMoves().size() > 1 && this.mModel.getSettings().warnUser()) {
            this.logger.bold().println("This search loop is based on a sequential Move, the returned strategy may not reflect the reality.");
        }
        return this.M.getStrategy();
    }

    public <V extends Variable> IObjectiveManager<V> getObjectiveManager() {
        return this.objectivemanager;
    }

    public boolean isDefaultSearchUsed() {
        return this.defaultSearch;
    }

    public boolean isSearchCompleted() {
        return this.completeSearch;
    }

    public boolean hasEndedUnexpectedly() {
        return this.mMeasures.getSearchState() == SearchState.KILLED;
    }

    public boolean isStopCriterionMet() {
        boolean ismet = false;
        for (int i = 0; i < this.criteria.size() && !ismet; ++i) {
            ismet = this.criteria.get(i).isMet();
        }
        return ismet;
    }

    public int getSearchWorldIndex() {
        return this.searchWorldIndex;
    }

    public MeasuresRecorder getMeasures() {
        return this.mMeasures;
    }

    public PropagationEngine getEngine() {
        return this.engine;
    }

    public ESat isFeasible() {
        return this.feasible;
    }

    public ESat isSatisfied() {
        int OK = 0;
        for (Constraint c : this.mModel.getCstrs()) {
            if (c.isEnabled()) {
                ESat satC = c.isSatisfied();
                if (ESat.FALSE == satC) {
                    if (this.getModel().getSettings().warnUser()) {
                        this.logger.bold().red().printf("FAILURE >> %s (%s)%n", new Object[]{c, satC});
                    }
                    return ESat.FALSE;
                }
                if (ESat.TRUE != satC) continue;
                ++OK;
                continue;
            }
            ++OK;
        }
        if (OK == this.mModel.getCstrs().length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public int getJumpTo() {
        return this.jumpTo;
    }

    public void setLearner(Learn l) {
        this.L = l;
    }

    public void setMove(Move ... m) {
        this.M = m == null ? null : (m.length == 1 ? m[0] : new MoveSeq(this.getModel(), m));
    }

    @Deprecated
    public void setPropagate(Propagate p) {
    }

    public void addRestarter(AbstractRestart restarter) {
        if (restarter != AbstractRestart.NO_RESTART) {
            restarter.setNext(this.restarter);
            this.restarter = restarter;
        }
    }

    public AbstractRestart getRestarter() {
        return this.restarter;
    }

    public void clearRestarter() {
        this.restarter = AbstractRestart.NO_RESTART;
    }

    public void setObjectiveManager(IObjectiveManager<?> om) {
        this.objectivemanager = om;
        this.mMeasures.setBoundsManager(om);
    }

    public void setSearch(AbstractStrategy ... strategies) {
        if (strategies == null || strategies.length == 0) {
            throw new UnsupportedOperationException("no search strategy has been specified");
        }
        if (this.M.getChildMoves().size() > 1) {
            throw new UnsupportedOperationException("The Move declared is composed of many Moves.\nA strategy must be attached to each of them independently, and it cannot be achieved calling this method.An iteration over it child moves is needed: this.getMove().getChildMoves().");
        }
        if ((strategies = (AbstractStrategy[])Arrays.stream(strategies).filter(Objects::nonNull).flatMap(s -> s instanceof StrategiesSequencer ? Arrays.stream(((StrategiesSequencer)s).getStrategies()) : Stream.of(s)).toArray(AbstractStrategy[]::new)).length == 0) {
            this.M.removeStrategy();
        } else if (strategies.length == 1) {
            this.M.setStrategy(strategies[0]);
        } else {
            this.M.setStrategy(Search.sequencer(strategies));
        }
    }

    public void setEngine(PropagationEngine propagationEngine) {
        if (this.engine.isInitialized() && this.getEnvironment().getWorldIndex() != this.rootWorldIndex) {
            throw new SolverException("Illegal propagation engine modification.");
        }
        this.engine = propagationEngine;
    }

    public void makeCompleteStrategy(boolean isComplete) {
        this.completeSearch = isComplete;
    }

    public void addHint(IntVar var, int val) {
        if (this.warmStart == null) {
            this.warmStart = new WarmStart(this);
        }
        this.warmStart.addHint(var, val);
    }

    public void removeHints() {
        this.setSearch(this.warmStart.getStrategy());
        this.warmStart.clearHints();
        this.warmStart = null;
    }

    public void addStopCriterion(Criterion ... criterion) {
        if (criterion != null) {
            Collections.addAll(this.criteria, criterion);
        }
    }

    public void removeStopCriterion(Criterion ... criterion) {
        if (criterion != null) {
            for (Criterion c : criterion) {
                this.criteria.remove(c);
            }
        }
    }

    public void removeAllStopCriteria() {
        this.criteria.clear();
    }

    public SearchMonitorList getSearchMonitors() {
        return this.searchMonitors;
    }

    public void plugMonitor(ISearchMonitor sm) {
        this.searchMonitors.add(sm);
    }

    public void unplugMonitor(ISearchMonitor sm) {
        this.searchMonitors.remove(sm);
    }

    public void onSolution(Runnable r) {
        this.searchMonitors.add(r::run);
    }

    public void unplugAllSearchMonitors() {
        this.searchMonitors.reset();
    }

    public void setJumpTo(int jto) {
        this.jumpTo = jto;
    }

    public Solution defaultSolution() {
        if (this.lastSol == null) {
            this.lastSol = new Solution(this.getModel(), new Variable[0]);
            this.attach(this.lastSol);
        }
        return this.lastSol;
    }

    public boolean defaultSolutionExists() {
        return this.lastSol != null;
    }

    @Override
    public Solver ref() {
        return this;
    }

    @Override
    public String getModelName() {
        return this.getMeasures().getModelName();
    }

    @Override
    public long getTimestamp() {
        return this.getMeasures().getTimestamp();
    }

    @Override
    public float getTimeCount() {
        return this.getMeasures().getTimeCount();
    }

    @Override
    public long getTimeCountInNanoSeconds() {
        return this.getMeasures().getTimeCountInNanoSeconds();
    }

    @Override
    public long getTimeToBestSolutionInNanoSeconds() {
        return this.getMeasures().getTimeToBestSolutionInNanoSeconds();
    }

    @Override
    public long getReadingTimeCountInNanoSeconds() {
        return this.getMeasures().getReadingTimeCountInNanoSeconds();
    }

    @Override
    public float getReadingTimeCount() {
        return this.getMeasures().getReadingTimeCount();
    }

    @Override
    public long getNodeCount() {
        return this.getMeasures().getNodeCount();
    }

    @Override
    public long getBackTrackCount() {
        return this.getMeasures().getBackTrackCount();
    }

    @Override
    public long getBackjumpCount() {
        return this.getMeasures().getBackjumpCount();
    }

    @Override
    public long getFailCount() {
        return this.getMeasures().getFailCount();
    }

    @Override
    public long getFixpointCount() {
        return this.getMeasures().getFixpointCount();
    }

    @Override
    public long getPropagationCount() {
        return this.getMeasures().getPropagationCount();
    }

    @Override
    public long getRestartCount() {
        return this.getMeasures().getRestartCount();
    }

    @Override
    public long getSolutionCount() {
        return this.getMeasures().getSolutionCount();
    }

    @Override
    public long getDecisionCount() {
        return this.getMeasures().getDecisionCount();
    }

    @Override
    public long getMaxDepth() {
        return this.getMeasures().getMaxDepth();
    }

    @Override
    public long getCurrentDepth() {
        return this.getDecisionPath().size();
    }

    @Override
    public boolean hasObjective() {
        return this.getMeasures().hasObjective();
    }

    @Override
    public boolean isObjectiveOptimal() {
        return this.getMeasures().isObjectiveOptimal();
    }

    @Override
    public Number getBestSolutionValue() {
        return this.getMeasures().getBestSolutionValue();
    }

    @Override
    public SearchState getSearchState() {
        return this.getMeasures().getSearchState();
    }

    @Override
    public IBoundsManager getBoundsManager() {
        assert (this.getMeasures().getBoundsManager() == this.objectivemanager);
        return this.getMeasures().getBoundsManager();
    }

    public Logger log() {
        return this.logger;
    }

    public void logWithANSI(boolean ansi) {
        this.logger = ansi ? new ANSILogger(this.logger) : new Logger(this.logger);
    }

    public static enum Action {
        initialize,
        propagate,
        extend,
        validate,
        repair;

    }
}

