/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.chocosolver.memory.EnvironmentBuilder;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.search.strategy.BlackBoxConfigurator;
import org.chocosolver.util.ESat;

public class Settings {
    private Predicate<Solver> modelChecker = s -> !ESat.FALSE.equals((Object)s.isSatisfied());
    private boolean cloneVariableArrayInPropagator = true;
    private boolean enableViews = true;
    private int maxDomSizeForEnumerated = 65536;
    private int minCardForSumDecomposition = 50;
    private boolean enableTableSubstitution = true;
    private int maxTupleSizeForSubstitution = 10000;
    private int timeLimitForPreprocessing = -1;
    private boolean sortPropagatorActivationWRTPriority = true;
    private int maxPropagatorPriority = PropagatorPriority.VERY_SLOW.getValue();
    private Consumer<Model> defaultSearch = m -> BlackBoxConfigurator.init().make((Model)m);
    private boolean warnUser = false;
    private boolean enableDecompositionOfBooleanSum = false;
    private IntPredicate enableIncrementalityOnBoolSum = i -> i > 10;
    private boolean enableSAT = false;
    private boolean swapOnPassivate = true;
    private boolean checkDeclaredConstraints = true;
    private boolean checkDeclaredViews = true;
    private boolean checkDeclaredMonitors = true;
    private boolean printAllUndeclaredConstraints = false;
    private byte hybridEngine = 0;
    private int nbMaxLearnt = 100000;
    private boolean intVarLazyLitWithWeakBounds = false;
    private double ibexContractionRatio = 0.01;
    private boolean ibexRestoreRounding = false;
    private Function<Model, Solver> initSolver = Solver::new;
    private final HashMap<String, Object> additionalSettings = new HashMap();
    private boolean lcg = false;
    private Supplier<IEnvironment> environmentSupplier = () -> new EnvironmentBuilder().fromFlat().build();

    private Settings() {
    }

    public static Settings init() {
        return new Settings();
    }

    public static Settings prod() {
        return Settings.init().setModelChecker(s -> true).setWarnUser(false).setCheckDeclaredConstraints(false).setCheckDeclaredViews(false).setCheckDeclaredMonitors(false).setPrintAllUndeclaredConstraints(false);
    }

    public static Settings dev() {
        return Settings.init().setModelChecker(s -> !ESat.FALSE.equals((Object)s.isSatisfied())).setWarnUser(true).setCheckDeclaredConstraints(true).setCheckDeclaredViews(true).setCheckDeclaredMonitors(true).setPrintAllUndeclaredConstraints(true);
    }

    public boolean checkModel(Solver solver) {
        return this.modelChecker.test(solver);
    }

    public Settings setModelChecker(Predicate<Solver> modelChecker) {
        this.modelChecker = modelChecker;
        return this;
    }

    public Settings setEnvironmentSupplier(Supplier<IEnvironment> environmentSupplier) {
        this.environmentSupplier = environmentSupplier;
        return this;
    }

    public Supplier<IEnvironment> getEnvironmentSupplier() {
        return this.environmentSupplier;
    }

    public boolean cloneVariableArrayInPropagator() {
        return this.cloneVariableArrayInPropagator;
    }

    public Settings setCloneVariableArrayInPropagator(boolean cloneVariableArrayInPropagator) {
        this.cloneVariableArrayInPropagator = cloneVariableArrayInPropagator;
        return this;
    }

    public boolean enableViews() {
        return this.enableViews;
    }

    public Settings setEnableViews(boolean enableViews) {
        this.enableViews = enableViews;
        return this;
    }

    public int getMaxDomSizeForEnumerated() {
        return this.maxDomSizeForEnumerated;
    }

    public Settings setMaxDomSizeForEnumerated(int maxDomSizeForEnumerated) {
        this.maxDomSizeForEnumerated = maxDomSizeForEnumerated;
        return this;
    }

    public int getMinCardForSumDecomposition() {
        return this.minCardForSumDecomposition;
    }

    public Settings setMinCardinalityForSumDecomposition(int defaultMinCardinalityForSumDecomposition) {
        this.minCardForSumDecomposition = defaultMinCardinalityForSumDecomposition;
        return this;
    }

    public boolean enableTableSubstitution() {
        return this.enableTableSubstitution;
    }

    public Settings setEnableTableSubstitution(boolean enableTableSubstitution) {
        this.enableTableSubstitution = enableTableSubstitution;
        return this;
    }

    public int getMaxTupleSizeForSubstitution() {
        return this.maxTupleSizeForSubstitution;
    }

    public Settings setMaxTupleSizeForSubstitution(int maxTupleSizeForSubstitution) {
        this.maxTupleSizeForSubstitution = maxTupleSizeForSubstitution;
        return this;
    }

    public long getTimeLimitForPreprocessing() {
        return this.timeLimitForPreprocessing;
    }

    public Settings setTimeLimitForPreprocessing(int timeLimitForPreprocessing) {
        this.timeLimitForPreprocessing = timeLimitForPreprocessing;
        return this;
    }

    public boolean sortPropagatorActivationWRTPriority() {
        return this.sortPropagatorActivationWRTPriority;
    }

    public Settings setSortPropagatorActivationWRTPriority(boolean sortPropagatorActivationWRTPriority) {
        this.sortPropagatorActivationWRTPriority = sortPropagatorActivationWRTPriority;
        return this;
    }

    public int getMaxPropagatorPriority() {
        return this.maxPropagatorPriority;
    }

    public Settings setMaxPropagatorPriority(int maxPropagatorPriority) {
        this.maxPropagatorPriority = maxPropagatorPriority;
        return this;
    }

    public void makeDefaultSearch(Model model) {
        this.defaultSearch.accept(model);
    }

    public Settings setDefaultSearch(Consumer<Model> defaultSearch) {
        this.defaultSearch = defaultSearch;
        return this;
    }

    public boolean warnUser() {
        return this.warnUser;
    }

    public Settings setWarnUser(boolean warnUser) {
        this.warnUser = warnUser;
        return this;
    }

    public boolean enableDecompositionOfBooleanSum() {
        return this.enableDecompositionOfBooleanSum;
    }

    public Settings setEnableDecompositionOfBooleanSum(boolean enableDecompositionOfBooleanSum) {
        this.enableDecompositionOfBooleanSum = enableDecompositionOfBooleanSum;
        return this;
    }

    public boolean enableIncrementalityOnBoolSum(int nbvars) {
        return this.enableIncrementalityOnBoolSum.test(nbvars);
    }

    public Settings setEnableIncrementalityOnBoolSum(IntPredicate enableIncrementalityOnBoolSum) {
        this.enableIncrementalityOnBoolSum = enableIncrementalityOnBoolSum;
        return this;
    }

    public boolean enableSAT() {
        return this.enableSAT;
    }

    public Settings setEnableSAT(boolean enableSAT) {
        this.enableSAT = enableSAT;
        return this;
    }

    public boolean swapOnPassivate() {
        return this.swapOnPassivate;
    }

    public Settings setSwapOnPassivate(boolean swapOnPassivate) {
        this.swapOnPassivate = swapOnPassivate;
        return this;
    }

    public boolean checkDeclaredConstraints() {
        return this.checkDeclaredConstraints;
    }

    public Settings setCheckDeclaredConstraints(boolean checkDeclaredConstraints) {
        this.checkDeclaredConstraints = checkDeclaredConstraints;
        return this;
    }

    public boolean printAllUndeclaredConstraints() {
        return this.printAllUndeclaredConstraints;
    }

    public Settings setPrintAllUndeclaredConstraints(boolean printAllUndeclaredConstraints) {
        this.printAllUndeclaredConstraints = printAllUndeclaredConstraints;
        return this;
    }

    public boolean checkDeclaredViews() {
        return this.checkDeclaredViews;
    }

    public Settings setCheckDeclaredViews(boolean checkDeclaredViews) {
        this.checkDeclaredViews = checkDeclaredViews;
        return this;
    }

    public Settings setCheckDeclaredMonitors(boolean check) {
        this.checkDeclaredMonitors = check;
        return this;
    }

    public boolean checkDeclaredMonitors() {
        return this.checkDeclaredMonitors;
    }

    public Solver initSolver(Model model) {
        return this.initSolver.apply(model);
    }

    public Settings setInitSolver(Function<Model, Solver> initSolver) {
        this.initSolver = initSolver;
        return this;
    }

    public byte enableHybridizationOfPropagationEngine() {
        return this.hybridEngine;
    }

    public Settings setHybridizationOfPropagationEngine(byte hybrid) {
        this.hybridEngine = hybrid;
        return this;
    }

    public Settings setLCG(boolean isLCG) {
        this.lcg = isLCG;
        this.setEnableSAT(this.lcg || this.enableSAT);
        return this;
    }

    public boolean isLCG() {
        return this.lcg;
    }

    public int getNbMaxLearntClauses() {
        return this.nbMaxLearnt;
    }

    public Settings setNbMaxLearntClauses(int n) {
        this.nbMaxLearnt = n;
        return this;
    }

    public boolean intVarLazyLitWithWeakBounds() {
        return this.intVarLazyLitWithWeakBounds;
    }

    public Settings setIntVarLazyLitWithWeakBounds(boolean intVarLazyLitWithWeakBounds) {
        this.intVarLazyLitWithWeakBounds = intVarLazyLitWithWeakBounds;
        return this;
    }

    public double getIbexContractionRatio() {
        return this.ibexContractionRatio;
    }

    public void setIbexContractionRatio(double ibexContractionRatio) {
        this.ibexContractionRatio = ibexContractionRatio;
    }

    public Settings setIbexRestoreRounding(boolean ibexRestoreRounding) {
        this.ibexRestoreRounding = ibexRestoreRounding;
        return this;
    }

    public boolean getIbexRestoreRounding() {
        return this.ibexRestoreRounding;
    }

    public Optional<Object> get(String key) {
        return Optional.ofNullable(this.additionalSettings.get(key));
    }

    public Settings set(String key, Object value) {
        this.additionalSettings.put(key, value);
        return this;
    }
}

