/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.qsar.DescriptorEngine;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class DescriptorUtilities {
    public static String[] getDescriptorNamesByCategory(String category) {
        category = category + "Descriptor";
        ArrayList<String> ret = new ArrayList<String>();
        DescriptorEngine engine = new DescriptorEngine(IMolecularDescriptor.class, SilentChemObjectBuilder.getInstance());
        List classNames = engine.getDescriptorClassNames();
        block0: for (String className : classNames) {
            String[] dictClasses = engine.getDictionaryClass(className);
            if (dictClasses == null) {
                if (className.indexOf("AcidicGroupCountDescriptor") >= 0) {
                    dictClasses = new String[]{"constitutionalDescriptor"};
                }
                if (className.indexOf("FractionalCSP3Descriptor") >= 0) {
                    dictClasses = new String[]{"constitutionalDescriptor"};
                }
            }
            for (String dictClass : dictClasses) {
                if (!category.equals(dictClass)) continue;
                ret.add(className);
                continue block0;
            }
        }
        String[] validClassNames = new String[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            validClassNames[i] = (String)ret.get(i);
        }
        return validClassNames;
    }

    public static String[] getDescriptorCategories() {
        DescriptorEngine engine = new DescriptorEngine(IMolecularDescriptor.class, SilentChemObjectBuilder.getInstance());
        return engine.getAvailableDictionaryClasses();
    }

    public static void main(String[] args) {
        String category = "geometrical";
        DescriptorUtilities.getDescriptorNamesByCategory(category);
    }
}

