/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.ext.batik.ext.awt.LinearGradientPaint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.geom.Point2D;
import javax.swing.UIManager;

public class QuaquaRootPaneBackground
extends PaintableColor {
    private Color[] activeColors;
    private Color[] inactiveColors;

    public QuaquaRootPaneBackground(int plainColor, int[] activeTextureColors, int[] inactiveTextureColors) {
        super(plainColor);
        int i;
        this.activeColors = new Color[activeTextureColors.length];
        for (i = 0; i < activeTextureColors.length; ++i) {
            this.activeColors[i] = new Color(activeTextureColors[i]);
        }
        this.inactiveColors = new Color[inactiveTextureColors.length];
        for (i = 0; i < inactiveTextureColors.length; ++i) {
            this.inactiveColors[i] = new Color(inactiveTextureColors[i]);
        }
    }

    public QuaquaRootPaneBackground(Color plainColor, Color[] activeTextureColors, Color[] inactiveTextureColors) {
        super(plainColor.getRGB());
        this.activeColors = activeTextureColors;
        this.inactiveColors = inactiveTextureColors;
    }

    public Paint getPaint(Component c, int x, int y, int width, int height) {
        boolean isTextured = QuaquaUtilities.isOnTexturedWindow(c);
        if (isTextured) {
            int rootOffset = 0;
            int rootHeight = 0;
            for (Component p = c; p != null && p.getParent() != null; p = p.getParent()) {
                rootOffset -= p.getY();
                rootHeight = p.getHeight();
            }
            rootHeight = Math.max(rootHeight, 122);
            return new LinearGradientPaint(new Point2D.Float(x, rootOffset), new Point2D.Float(x, rootOffset + rootHeight), new float[]{0.0f, 1.0f / (float)rootHeight, 81.0f / (float)rootHeight, ((float)rootHeight - 41.0f) / (float)rootHeight, ((float)rootHeight - 1.0f) / (float)rootHeight}, QuaquaUtilities.isOnActiveWindow(c) ? this.activeColors : this.inactiveColors);
        }
        return UIManager.getColor("Panel.background");
    }
}

