/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra.missingData;

import dr.inference.model.MatrixParameterInterface;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.ReadableMatrix;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.WrappedVector;
import dr.math.matrixAlgebra.WritableMatrix;
import dr.math.matrixAlgebra.WritableVector;
import dr.math.matrixAlgebra.missingData.InversionResult;
import dr.math.matrixAlgebra.missingData.PermutationIndices;
import dr.util.EuclideanToInfiniteNormUnitBallTransform;
import java.util.Arrays;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt_D64;
import org.ejml.alg.dense.linsol.lu.LinearSolverLu_D64;
import org.ejml.alg.dense.linsol.svd.SolvePseudoInverseSvd;
import org.ejml.alg.dense.misc.UnrolledDeterminantFromMinor;
import org.ejml.alg.dense.misc.UnrolledInverseFromMinor;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class MissingOps {
    private static double[] buffer = new double[16];

    public static DenseMatrix64F wrap(double[] dArray, int n, int n2, int n3) {
        double[] dArray2 = new double[n2 * n3];
        return MissingOps.wrap(dArray, n, n2, n3, dArray2);
    }

    public static DenseMatrix64F wrap(double[] dArray, int n, int n2, int n3, double[] dArray2) {
        System.arraycopy(dArray, n, dArray2, 0, n2 * n3);
        return DenseMatrix64F.wrap(n2, n3, dArray2);
    }

    public static DenseMatrix64F wrap(MatrixParameterInterface matrixParameterInterface) {
        return MissingOps.wrap(matrixParameterInterface.getParameterValues(), 0, matrixParameterInterface.getRowDimension(), matrixParameterInterface.getColumnDimension());
    }

    public static DenseMatrix64F wrapDiagonal(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n2 * n2];
        return MissingOps.wrapDiagonal(dArray, n, n2, dArray2);
    }

    public static DenseMatrix64F wrapSpherical(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n2 * n2];
        return MissingOps.wrapSpherical(dArray, n, n2, dArray2);
    }

    public static DenseMatrix64F wrapSpherical(double[] dArray, int n, int n2, double[] dArray2) {
        MissingOps.fillSpherical(dArray, n, n2, dArray2);
        DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(n2, n2, dArray2);
        CommonOps.transpose(denseMatrix64F);
        return denseMatrix64F;
    }

    private static void fillSpherical(double[] dArray, int n, int n2, double[] dArray2) {
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray, n + i * (n2 - 1), dArray2, i * n2, n2 - 1);
            dArray2[(i + 1) * n2 - 1] = EuclideanToInfiniteNormUnitBallTransform.projection(dArray, n + i * (n2 - 1), n2 - 1);
        }
    }

    public static DenseMatrix64F wrapDiagonal(double[] dArray, int n, int n2, double[] dArray2) {
        for (int i = 0; i < n2; ++i) {
            dArray2[i * n2 + i] = dArray[i];
        }
        return DenseMatrix64F.wrap(n2, n2, dArray2);
    }

    public static DenseMatrix64F wrapDiagonalInverse(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n2 * n2];
        return MissingOps.wrapDiagonalInverse(dArray, n, n2, dArray2);
    }

    public static DenseMatrix64F wrapDiagonalInverse(double[] dArray, int n, int n2, double[] dArray2) {
        for (int i = 0; i < n2; ++i) {
            dArray2[i * n2 + i] = 1.0 / dArray[i];
        }
        return DenseMatrix64F.wrap(n2, n2, dArray2);
    }

    public static DenseMatrix64F copy(ReadableMatrix readableMatrix) {
        int n = readableMatrix.getDim();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = readableMatrix.get(i);
        }
        return DenseMatrix64F.wrap(readableMatrix.getMinorDim(), readableMatrix.getMajorDim(), dArray);
    }

    public static void copy(DenseMatrix64F denseMatrix64F, WritableMatrix writableMatrix) {
        int n = writableMatrix.getDim();
        for (int i = 0; i < n; ++i) {
            writableMatrix.set(i, denseMatrix64F.get(i));
        }
    }

    public static void gatherRowsAndColumns(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        double[] dArray = denseMatrix64F2.getData();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray[n3] = denseMatrix64F.unsafe_get(n4, nArray2[j]);
                ++n3;
            }
        }
    }

    public static DenseMatrix64F gatherRowsAndColumns(DenseMatrix64F denseMatrix64F, int[] nArray, int[] nArray2) {
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(nArray.length, nArray2.length);
        MissingOps.gatherRowsAndColumns(denseMatrix64F, denseMatrix64F2, nArray, nArray2);
        return denseMatrix64F2;
    }

    public static void copyRowsAndColumns(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, int[] nArray, int[] nArray2, boolean bl) {
        if (bl) {
            Arrays.fill(denseMatrix64F2.getData(), 0.0);
        }
        for (int n : nArray) {
            for (int n2 : nArray2) {
                denseMatrix64F2.unsafe_set(n, n2, denseMatrix64F.unsafe_get(n, n2));
            }
        }
    }

    public static void scatterRowsAndColumns(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, int[] nArray, int[] nArray2, boolean bl) {
        if (bl) {
            Arrays.fill(denseMatrix64F2.getData(), 0.0);
        }
        int n = nArray.length;
        int n2 = nArray2.length;
        double[] dArray = denseMatrix64F.getData();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                denseMatrix64F2.unsafe_set(n4, nArray2[j], dArray[n3]);
                ++n3;
            }
        }
    }

    public static void unwrap(DenseMatrix64F denseMatrix64F, double[] dArray, int n) {
        System.arraycopy(denseMatrix64F.getData(), 0, dArray, n, denseMatrix64F.getNumElements());
    }

    public static void unwrapIdentity(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            for (n3 = 0; n3 < i; ++n3) {
                dArray[n + i * n2 + n3] = 0.0;
            }
            dArray[n + i * n2 + i] = 1.0;
            for (n3 = i + 1; n3 < n2; ++n3) {
                dArray[n + i * n2 + n3] = 0.0;
            }
        }
    }

    public static void blockUnwrap(DenseMatrix64F denseMatrix64F, double[] dArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < denseMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < denseMatrix64F.getNumCols(); ++j) {
                dArray[n + (i + n2) * n4 + j + n3] = denseMatrix64F.get(i, j);
            }
        }
    }

    public static boolean anyDiagonalInfinities(DenseMatrix64F denseMatrix64F) {
        boolean bl = false;
        for (int i = 0; i < denseMatrix64F.getNumCols() && !bl; ++i) {
            if (!Double.isInfinite(denseMatrix64F.unsafe_get(i, i))) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean allFiniteDiagonals(DenseMatrix64F denseMatrix64F) {
        boolean bl = true;
        int n = denseMatrix64F.getNumCols();
        for (int i = 0; i < n; ++i) {
            bl &= !Double.isInfinite(denseMatrix64F.unsafe_get(i, i));
        }
        return bl;
    }

    public static int countFiniteDiagonals(DenseMatrix64F denseMatrix64F) {
        int n = denseMatrix64F.getNumCols();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = denseMatrix64F.unsafe_get(i, i);
            if (Double.isInfinite(d)) continue;
            ++n2;
        }
        return n2;
    }

    public static int countZeroDiagonals(DenseMatrix64F denseMatrix64F) {
        int n = denseMatrix64F.getNumCols();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = denseMatrix64F.unsafe_get(i, i);
            if (d != 0.0) continue;
            ++n2;
        }
        return n2;
    }

    public static boolean allZeroDiagonals(DenseMatrix64F denseMatrix64F) {
        int n = denseMatrix64F.getNumCols();
        for (int i = 0; i < n; ++i) {
            if (denseMatrix64F.unsafe_get(i, i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public static void getFiniteDiagonalIndices(DenseMatrix64F denseMatrix64F, int[] nArray) {
        int n = denseMatrix64F.getNumCols();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = denseMatrix64F.unsafe_get(i, i);
            if (Double.isInfinite(d)) continue;
            nArray[n2] = i;
            ++n2;
        }
    }

    public static int countFiniteNonZeroDiagonals(ReadableMatrix readableMatrix) {
        int n = readableMatrix.getMajorDim();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = readableMatrix.get(i, i);
            if (Double.isInfinite(d) || d == 0.0) continue;
            ++n2;
        }
        return n2;
    }

    public static int countFiniteNonZeroDiagonals(DenseMatrix64F denseMatrix64F) {
        int n = denseMatrix64F.getNumCols();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = denseMatrix64F.unsafe_get(i, i);
            if (Double.isInfinite(d) || d == 0.0) continue;
            ++n2;
        }
        return n2;
    }

    public static void getFiniteNonZeroDiagonalIndices(DenseMatrix64F denseMatrix64F, int[] nArray) {
        int n = denseMatrix64F.getNumCols();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = denseMatrix64F.unsafe_get(i, i);
            if (Double.isInfinite(d) || d == 0.0) continue;
            nArray[n2] = i;
            ++n2;
        }
    }

    public static void addToDiagonal(DenseMatrix64F denseMatrix64F, double d) {
        int n = denseMatrix64F.getNumRows();
        for (int i = 0; i < n; ++i) {
            denseMatrix64F.unsafe_set(i, i, denseMatrix64F.unsafe_get(i, i) + d);
        }
    }

    public static double det(DenseMatrix64F denseMatrix64F) {
        int n;
        int n2 = denseMatrix64F.getNumCols();
        if (n2 != (n = denseMatrix64F.getNumRows())) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        if (n2 <= 6) {
            return n2 >= 2 ? UnrolledDeterminantFromMinor.det(denseMatrix64F) : denseMatrix64F.get(0);
        }
        LUDecompositionAlt_D64 lUDecompositionAlt_D64 = new LUDecompositionAlt_D64();
        if (lUDecompositionAlt_D64.inputModified()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        return !lUDecompositionAlt_D64.decompose(denseMatrix64F) ? 0.0 : lUDecompositionAlt_D64.computeDeterminant().real;
    }

    public static double invertAndGetDeterminant(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, boolean bl) {
        int n;
        int n2 = denseMatrix64F.getNumCols();
        if (n2 != (n = denseMatrix64F.getNumRows())) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        if (n2 <= 5) {
            if (n2 >= 2) {
                UnrolledInverseFromMinor.inv(denseMatrix64F, denseMatrix64F2);
            } else {
                denseMatrix64F2.set(0, 1.0 / denseMatrix64F.get(0));
            }
            double d = n2 >= 2 ? UnrolledDeterminantFromMinor.det(denseMatrix64F) : denseMatrix64F.get(0);
            return bl ? Math.log(d) : d;
        }
        LUDecompositionAlt_D64 lUDecompositionAlt_D64 = new LUDecompositionAlt_D64();
        LinearSolverLu_D64 linearSolverLu_D64 = new LinearSolverLu_D64(lUDecompositionAlt_D64);
        if (linearSolverLu_D64.modifiesA()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        if (!linearSolverLu_D64.setA(denseMatrix64F)) {
            return Double.NaN;
        }
        linearSolverLu_D64.invert(denseMatrix64F2);
        return bl ? MissingOps.computeLogDeterminant(lUDecompositionAlt_D64) : lUDecompositionAlt_D64.computeDeterminant().real;
    }

    private static double computeLogDeterminant(LUDecompositionAlt_D64 lUDecompositionAlt_D64) {
        int n = lUDecompositionAlt_D64.getLU().getNumCols();
        if (n != lUDecompositionAlt_D64.getLU().getNumRows()) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        double d = 0.0;
        double[] dArray = lUDecompositionAlt_D64.getLU().getData();
        for (int i = 0; i < n * n; i += n + 1) {
            d += Math.log(Math.abs(dArray[i]));
        }
        return d;
    }

    public static InversionResult safeDeterminant(DenseMatrix64F denseMatrix64F, boolean bl) {
        InversionResult inversionResult;
        int n = MissingOps.countFiniteNonZeroDiagonals(denseMatrix64F);
        if (n == 0) {
            inversionResult = new InversionResult(InversionResult.Code.NOT_OBSERVED, 0, Double.NEGATIVE_INFINITY, true);
        } else {
            SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols(), false, false, false);
            if (!singularValueDecomposition.decompose(denseMatrix64F)) {
                if (SingularOps.rank(singularValueDecomposition) == 0) {
                    return new InversionResult(InversionResult.Code.NOT_OBSERVED, 0, Double.NEGATIVE_INFINITY, true);
                }
                throw new RuntimeException("SVD decomposition failed");
            }
            double[] dArray = singularValueDecomposition.getSingularValues();
            double d = SingularOps.singularThreshold(singularValueDecomposition);
            int n2 = 0;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                if (!(d3 > d)) continue;
                d2 += Math.log(d3);
                ++n2;
            }
            if (bl) {
                d2 = -d2;
            }
            inversionResult = new InversionResult(n2 == denseMatrix64F.getNumCols() ? InversionResult.Code.FULLY_OBSERVED : InversionResult.Code.PARTIALLY_OBSERVED, n2, d2, true);
        }
        return inversionResult;
    }

    public static InversionResult safeSolve(DenseMatrix64F denseMatrix64F, WrappedVector wrappedVector, WrappedVector wrappedVector2, boolean bl) {
        int n = wrappedVector.getDim();
        assert (denseMatrix64F.getNumRows() == n && denseMatrix64F.getNumCols() == n);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrap(wrappedVector.getBuffer(), wrappedVector.getOffset(), n, 1);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n, 1);
        InversionResult inversionResult = MissingOps.safeSolve(denseMatrix64F, denseMatrix64F2, denseMatrix64F3, bl);
        for (int i = 0; i < n; ++i) {
            wrappedVector2.set(i, denseMatrix64F3.unsafe_get(i, 0));
        }
        return inversionResult;
    }

    public static InversionResult safeSolve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, boolean bl) {
        InversionResult inversionResult;
        int n = MissingOps.countFiniteNonZeroDiagonals(denseMatrix64F);
        if (n == 0) {
            Arrays.fill(denseMatrix64F3.getData(), 0.0);
            inversionResult = new InversionResult(InversionResult.Code.NOT_OBSERVED, 0, Double.NEGATIVE_INFINITY, true);
        } else {
            LinearSolver<DenseMatrix64F> linearSolver = LinearSolverFactory.pseudoInverse(true);
            ((SolvePseudoInverseSvd)linearSolver).setThreshold(1.0E-8);
            linearSolver.setA(denseMatrix64F);
            linearSolver.solve(denseMatrix64F2, denseMatrix64F3);
            int n2 = 0;
            double d = 0.0;
            assert (!bl);
            inversionResult = new InversionResult(n2 == denseMatrix64F.getNumCols() ? InversionResult.Code.FULLY_OBSERVED : InversionResult.Code.PARTIALLY_OBSERVED, n2, d, true);
        }
        return inversionResult;
    }

    public static InversionResult safeInvertPrecision(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, boolean bl) {
        return MissingOps.safeInvert2(denseMatrix64F, denseMatrix64F2, bl, false);
    }

    public static InversionResult safeInvertVariance(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, boolean bl) {
        return MissingOps.safeInvert2(denseMatrix64F, denseMatrix64F2, bl, true);
    }

    public static InversionResult safeInvert2(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, boolean bl) {
        return MissingOps.safeInvert2(denseMatrix64F, denseMatrix64F2, bl, true);
    }

    private static InversionResult safeInvert2(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, boolean bl, boolean bl2) {
        int n;
        int n2 = denseMatrix64F.getNumCols();
        PermutationIndices permutationIndices = new PermutationIndices(denseMatrix64F);
        int n3 = permutationIndices.getNumberOfNonZeroFiniteDiagonals();
        double d = 0.0;
        if (n3 == n2) {
            if (bl) {
                d = MissingOps.invertAndGetDeterminant(denseMatrix64F, denseMatrix64F2, true);
            } else {
                MissingOps.symmPosDefInvert(denseMatrix64F, denseMatrix64F2);
            }
            return new InversionResult(InversionResult.Code.FULLY_OBSERVED, n2, d, true);
        }
        if (n3 == 0) {
            int[] nArray;
            Arrays.fill(denseMatrix64F2.getData(), 0.0);
            int n4 = permutationIndices.getNumberOfInfiniteDiagonals();
            if (n4 == n2) {
                return bl2 ? new InversionResult(InversionResult.Code.NOT_OBSERVED, 0, Double.NEGATIVE_INFINITY, true) : new InversionResult(InversionResult.Code.FULLY_OBSERVED, n2, Double.POSITIVE_INFINITY, true);
            }
            int n5 = permutationIndices.getNumberOfZeroDiagonals();
            if (n5 == n2) {
                for (int i = 0; i < n2; ++i) {
                    denseMatrix64F2.set(i, i, Double.POSITIVE_INFINITY);
                }
                return bl2 ? new InversionResult(InversionResult.Code.FULLY_OBSERVED, n2, Double.POSITIVE_INFINITY, true) : new InversionResult(InversionResult.Code.NOT_OBSERVED, 0, Double.NEGATIVE_INFINITY, true);
            }
            for (int n6 : nArray = permutationIndices.getZeroIndices()) {
                denseMatrix64F2.set(n6, n6, Double.POSITIVE_INFINITY);
            }
            return bl2 ? new InversionResult(InversionResult.Code.PARTIALLY_OBSERVED, n5, Double.POSITIVE_INFINITY, true) : new InversionResult(InversionResult.Code.PARTIALLY_OBSERVED, n4, Double.POSITIVE_INFINITY, true);
        }
        int[] nArray = permutationIndices.getNonZeroFiniteIndices();
        int[] nArray2 = permutationIndices.getZeroIndices();
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n3, n3);
        MissingOps.gatherRowsAndColumns(denseMatrix64F, denseMatrix64F3, nArray, nArray);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(n3, n3);
        if (bl) {
            d = MissingOps.invertAndGetDeterminant(denseMatrix64F3, denseMatrix64F4, true);
        } else {
            MissingOps.symmPosDefInvert(denseMatrix64F3, denseMatrix64F4);
        }
        MissingOps.scatterRowsAndColumns(denseMatrix64F4, denseMatrix64F2, nArray, nArray, true);
        for (n = 0; n < nArray2.length; ++n) {
            int n7 = nArray2[n];
            denseMatrix64F2.set(n7, n7, Double.POSITIVE_INFINITY);
        }
        n = bl2 ? permutationIndices.getNumberOfZeroDiagonals() : permutationIndices.getNumberOfInfiniteDiagonals();
        d = n == 0 ? d : Double.POSITIVE_INFINITY;
        return new InversionResult(InversionResult.Code.PARTIALLY_OBSERVED, n + n3, d, true);
    }

    public static void symmPosDefInvert(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        DenseMatrix64F denseMatrix64F3;
        LinearSolver<DenseMatrix64F> linearSolver = LinearSolverFactory.symmPosDef(denseMatrix64F.getNumCols());
        if (!linearSolver.setA(denseMatrix64F3 = new DenseMatrix64F(denseMatrix64F))) {
            CommonOps.invert(denseMatrix64F, denseMatrix64F2);
        } else {
            linearSolver.invert(denseMatrix64F2);
        }
    }

    public static void safeMult(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        int n = denseMatrix64F.getNumCols();
        assert (n == denseMatrix64F.getNumRows() && n == denseMatrix64F2.getNumCols() && n == denseMatrix64F2.getNumRows()) : "In safeMult, A and B must be square with the same dimension.";
        PermutationIndices permutationIndices = new PermutationIndices(denseMatrix64F);
        int n2 = permutationIndices.getNumberOfInfiniteDiagonals();
        PermutationIndices permutationIndices2 = new PermutationIndices(denseMatrix64F2);
        int n3 = permutationIndices2.getNumberOfInfiniteDiagonals();
        if (n2 == 0 && n3 == 0) {
            CommonOps.mult(denseMatrix64F, denseMatrix64F2, denseMatrix64F3);
        } else if (n2 == n) {
            CommonOps.scale(1.0, denseMatrix64F, denseMatrix64F3);
        } else if (n3 == n) {
            CommonOps.scale(1.0, denseMatrix64F2, denseMatrix64F3);
        } else {
            throw new RuntimeException("Partial safeMult not yet implemented.");
        }
    }

    public static void matrixVectorMultiple(DenseMatrix64F denseMatrix64F, WrappedVector wrappedVector, WrappedVector wrappedVector2, int n) {
        int n2;
        if (buffer.length < n) {
            buffer = new double[n];
        }
        for (n2 = 0; n2 < n; ++n2) {
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                d += denseMatrix64F.unsafe_get(n2, i) * wrappedVector.get(i);
            }
            MissingOps.buffer[n2] = d;
        }
        for (n2 = 0; n2 < n; ++n2) {
            wrappedVector2.set(n2, buffer[n2]);
        }
    }

    public static void safeWeightedAverage(ReadableVector readableVector, DenseMatrix64F denseMatrix64F, ReadableVector readableVector2, DenseMatrix64F denseMatrix64F2, WritableVector writableVector, DenseMatrix64F denseMatrix64F3, int n) {
        int n2;
        double d;
        int n3;
        double[] dArray = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            d = 0.0;
            n2 = Double.isInfinite(denseMatrix64F.unsafe_get(n3, n3));
            boolean bl = Double.isInfinite(denseMatrix64F2.unsafe_get(n3, n3));
            if (n2 != 0 && bl) {
                throw new IllegalArgumentException("Both precision matrices are infinite in dimension " + n3);
            }
            if (n2 != 0) {
                d = readableVector.get(n3);
            } else if (bl) {
                d = readableVector2.get(n3);
            } else {
                for (int i = 0; i < n; ++i) {
                    d += denseMatrix64F.unsafe_get(n3, i) * readableVector.get(i);
                    d += denseMatrix64F2.unsafe_get(n3, i) * readableVector2.get(i);
                }
            }
            dArray[n3] = d;
        }
        for (n3 = 0; n3 < n; ++n3) {
            d = 0.0;
            if (denseMatrix64F3.unsafe_get(n3, n3) == 0.0) {
                d = dArray[n3];
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    d += denseMatrix64F3.unsafe_get(n3, n2) * dArray[n2];
                }
            }
            writableVector.set(n3, d);
        }
    }

    public static void weightedAverage(ReadableVector readableVector, DenseMatrix64F denseMatrix64F, ReadableVector readableVector2, DenseMatrix64F denseMatrix64F2, WritableVector writableVector, DenseMatrix64F denseMatrix64F3, int n) {
        int n2;
        double d;
        int n3;
        double[] dArray = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += denseMatrix64F.unsafe_get(n3, n2) * readableVector.get(n2);
                d += denseMatrix64F2.unsafe_get(n3, n2) * readableVector2.get(n2);
            }
            dArray[n3] = d;
        }
        for (n3 = 0; n3 < n; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += denseMatrix64F3.unsafe_get(n3, n2) * dArray[n2];
            }
            writableVector.set(n3, d);
        }
    }

    public static void weightedAverage(ReadableVector readableVector, ReadableMatrix readableMatrix, ReadableVector readableVector2, ReadableMatrix readableMatrix2, WritableVector writableVector, ReadableMatrix readableMatrix3, int n) {
        int n2;
        double d;
        int n3;
        double[] dArray = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += readableMatrix.get(n3, n2) * readableVector.get(n2);
                d += readableMatrix2.get(n3, n2) * readableVector2.get(n2);
            }
            dArray[n3] = d;
        }
        for (n3 = 0; n3 < n; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += readableMatrix3.get(n3, n2) * dArray[n2];
            }
            writableVector.set(n3, d);
        }
    }

    public static void weightedAverage(double[] dArray, int n, DenseMatrix64F denseMatrix64F, double[] dArray2, int n2, DenseMatrix64F denseMatrix64F2, double[] dArray3, int n3, DenseMatrix64F denseMatrix64F3, int n4) {
        double[] dArray4 = new double[n4];
        MissingOps.weightedAverage(dArray, n, denseMatrix64F, dArray2, n2, denseMatrix64F2, dArray3, n3, denseMatrix64F3, n4, dArray4);
    }

    public static void weightedSum(double[] dArray, int n, DenseMatrix64F denseMatrix64F, double[] dArray2, int n2, DenseMatrix64F denseMatrix64F2, int n3, double[] dArray3) {
        for (int i = 0; i < n3; ++i) {
            double d = 0.0;
            for (int j = 0; j < n3; ++j) {
                d += denseMatrix64F.unsafe_get(i, j) * dArray[n + j];
                d += denseMatrix64F2.unsafe_get(i, j) * dArray2[n2 + j];
            }
            dArray3[i] = d;
        }
    }

    public static void weightedSumActualized(double[] dArray, int n, DenseMatrix64F denseMatrix64F, double[] dArray2, int n2, double[] dArray3, int n3, DenseMatrix64F denseMatrix64F2, double[] dArray4, int n4, int n5, double[] dArray5) {
        for (int i = 0; i < n5; ++i) {
            double d = 0.0;
            for (int j = 0; j < n5; ++j) {
                d += dArray2[n2 + i] * denseMatrix64F.unsafe_get(i, j) * dArray[n + j];
                d += dArray4[n4 + i] * denseMatrix64F2.unsafe_get(i, j) * dArray3[n3 + j];
            }
            dArray5[i] = d;
        }
    }

    public static void weightedAverage(double[] dArray, int n, DenseMatrix64F denseMatrix64F, double[] dArray2, int n2, DenseMatrix64F denseMatrix64F2, double[] dArray3, int n3, DenseMatrix64F denseMatrix64F3, int n4, double[] dArray4) {
        MissingOps.weightedSum(dArray, n, denseMatrix64F, dArray2, n2, denseMatrix64F2, n4, dArray4);
        for (int i = 0; i < n4; ++i) {
            if (Double.isInfinite(denseMatrix64F3.unsafe_get(i, i))) continue;
            double d = 0.0;
            for (int j = 0; j < n4; ++j) {
                if (Double.isInfinite(denseMatrix64F3.unsafe_get(j, j))) continue;
                d += denseMatrix64F3.unsafe_get(i, j) * dArray4[j];
            }
            dArray3[n3 + i] = d;
        }
    }

    public static double weightedInnerProduct(double[] dArray, int n, DenseMatrix64F denseMatrix64F, int n2) {
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = dArray[n + i];
            for (int j = 0; j < n2; ++j) {
                double d3 = dArray[n + j];
                d += d2 * denseMatrix64F.unsafe_get(i, j) * d3;
            }
        }
        return d;
    }

    public static double weightedInnerProductOfDifferences(double[] dArray, int n, double[] dArray2, int n2, DenseMatrix64F denseMatrix64F, int n3) {
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            double d2 = dArray[n + i] - dArray2[n2 + i];
            for (int j = 0; j < n3; ++j) {
                double d3 = dArray[n + j] - dArray2[n2 + j];
                d += d2 * denseMatrix64F.unsafe_get(i, j) * d3;
            }
        }
        return d;
    }

    public static double weightedThreeInnerProduct(double[] dArray, int n, DenseMatrix64F denseMatrix64F, double[] dArray2, int n2, DenseMatrix64F denseMatrix64F2, double[] dArray3, int n3, DenseMatrix64F denseMatrix64F3, int n4) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n4; ++i) {
            double d4 = dArray[n + i];
            double d5 = dArray2[n2 + i];
            double d6 = dArray3[n3 + i];
            for (int j = 0; j < n4; ++j) {
                double d7 = dArray[n + j];
                double d8 = dArray2[n2 + j];
                double d9 = dArray3[n3 + j];
                d += d4 * denseMatrix64F.unsafe_get(i, j) * d7;
                d2 += d5 * denseMatrix64F2.unsafe_get(i, j) * d8;
                d3 += d6 * denseMatrix64F3.unsafe_get(i, j) * d9;
            }
        }
        return d + d2 - d3;
    }

    public static double weightedThreeInnerProductNormalized(double[] dArray, int n, DenseMatrix64F denseMatrix64F, double[] dArray2, int n2, DenseMatrix64F denseMatrix64F2, double[] dArray3, int n3, double[] dArray4, int n4, int n5) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n5; ++i) {
            double d4 = dArray[n + i];
            double d5 = dArray2[n2 + i];
            double d6 = dArray3[n3 + i];
            double d7 = dArray4[n4 + i];
            for (int j = 0; j < n5; ++j) {
                double d8 = dArray[n + j];
                double d9 = dArray2[n2 + j];
                d += d4 * denseMatrix64F.unsafe_get(i, j) * d8;
                d2 += d5 * denseMatrix64F2.unsafe_get(i, j) * d9;
            }
            d3 += d6 * d7;
        }
        return d + d2 - d3;
    }

    public static void add(ReadableMatrix readableMatrix, ReadableMatrix readableMatrix2, WritableMatrix writableMatrix) {
        assert (readableMatrix.getDim() == readableMatrix2.getDim());
        assert (readableMatrix.getDim() == writableMatrix.getDim());
        int n = writableMatrix.getDim();
        for (int i = 0; i < n; ++i) {
            writableMatrix.set(i, readableMatrix.get(i) + readableMatrix2.get(i));
        }
    }

    public static void forceSymmetric(DenseMatrix64F denseMatrix64F) {
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F);
        CommonOps.transpose(denseMatrix64F, denseMatrix64F2);
        CommonOps.addEquals(denseMatrix64F, denseMatrix64F2);
        CommonOps.scale(0.5, denseMatrix64F);
    }

    public static void symmetricMult(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        int n = denseMatrix64F.getNumCols();
        assert (n == denseMatrix64F.getNumRows() && n == denseMatrix64F2.getNumCols() && n == denseMatrix64F2.getNumRows());
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    for (int i2 = 0; i2 < n; ++i2) {
                        d += denseMatrix64F2.unsafe_get(k, i2) * denseMatrix64F.unsafe_get(k, i) * denseMatrix64F.unsafe_get(i2, j);
                    }
                }
                denseMatrix64F3.unsafe_set(i, j, d);
                denseMatrix64F3.unsafe_set(j, i, d);
            }
        }
    }

    public static void diagMult(double[] dArray, DenseMatrix64F denseMatrix64F) {
        MissingOps.diagMult(dArray, denseMatrix64F, denseMatrix64F);
    }

    public static void diagMult(double[] dArray, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        assert (dArray.length == denseMatrix64F.getNumRows());
        assert (denseMatrix64F.getNumRows() == denseMatrix64F2.getNumRows() && denseMatrix64F.getNumCols() == denseMatrix64F2.getNumCols());
        for (int i = 0; i < denseMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < denseMatrix64F.getNumCols(); ++j) {
                denseMatrix64F2.unsafe_set(i, j, dArray[i] * denseMatrix64F.unsafe_get(i, j));
            }
        }
    }

    public static void diagMult(DenseMatrix64F denseMatrix64F, double[] dArray) {
        MissingOps.diagMult(denseMatrix64F, dArray, denseMatrix64F);
    }

    public static void diagMult(DenseMatrix64F denseMatrix64F, double[] dArray, DenseMatrix64F denseMatrix64F2) {
        assert (dArray.length == denseMatrix64F.getNumCols());
        assert (denseMatrix64F.getNumRows() == denseMatrix64F2.getNumRows() && denseMatrix64F.getNumCols() == denseMatrix64F2.getNumCols());
        for (int i = 0; i < denseMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < denseMatrix64F.getNumCols(); ++j) {
                denseMatrix64F2.unsafe_set(i, j, dArray[j] * denseMatrix64F.unsafe_get(i, j));
            }
        }
    }

    public static void diagDiv(double[] dArray, DenseMatrix64F denseMatrix64F) {
        assert (dArray.length == denseMatrix64F.getNumRows());
        for (int i = 0; i < denseMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < denseMatrix64F.getNumCols(); ++j) {
                denseMatrix64F.unsafe_set(i, j, denseMatrix64F.unsafe_get(i, j) / dArray[i]);
            }
        }
    }

    public static void diagDiv(DenseMatrix64F denseMatrix64F, double[] dArray) {
        assert (dArray.length == denseMatrix64F.getNumCols());
        for (int i = 0; i < denseMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < denseMatrix64F.getNumCols(); ++j) {
                denseMatrix64F.unsafe_set(i, j, denseMatrix64F.unsafe_get(i, j) / dArray[j]);
            }
        }
    }

    public static void addTransEquals(DenseMatrix64F denseMatrix64F) {
        assert (denseMatrix64F.getNumCols() == denseMatrix64F.getNumRows());
        for (int i = 0; i < denseMatrix64F.getNumCols(); ++i) {
            denseMatrix64F.unsafe_set(i, i, 2.0 * denseMatrix64F.unsafe_get(i, i));
            for (int j = 0; j < i; ++j) {
                denseMatrix64F.unsafe_set(i, j, denseMatrix64F.unsafe_get(i, j) + denseMatrix64F.unsafe_get(j, i));
                denseMatrix64F.unsafe_set(j, i, denseMatrix64F.unsafe_get(i, j));
            }
        }
    }

    public static double[] nextPossiblyDegenerateNormal(ReadableVector readableVector, DenseMatrix64F denseMatrix64F) {
        int n;
        int n2 = readableVector.getDim();
        if (denseMatrix64F.numCols != n2 || denseMatrix64F.numRows != n2) {
            throw new RuntimeException("Variance is a " + denseMatrix64F.numRows + "x" + denseMatrix64F.numCols + " matrix but mean has dimension " + n2);
        }
        int n3 = MissingOps.countZeroDiagonals(denseMatrix64F);
        if (n3 + (n = MissingOps.countFiniteNonZeroDiagonals(denseMatrix64F)) != n2) {
            throw new RuntimeException("At least one diagonal element of the variance is infinity. Cannot sample from distribution with infinite variance");
        }
        double[] dArray = ReadableVector.Utils.toArray(readableVector);
        if (n == n2) {
            double[][] dArray2 = CholeskyDecomposition.execute(denseMatrix64F.data, 0, n2);
            return MultivariateNormalDistribution.nextMultivariateNormalCholesky(dArray, dArray2);
        }
        int[] nArray = new int[n];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(denseMatrix64F.get(i, i) > 0.0)) continue;
            nArray[n4] = i;
            ++n4;
        }
        WrappedMatrix.Indexed indexed = new WrappedMatrix.Indexed(denseMatrix64F.data, 0, nArray, nArray, n2, n2);
        WrappedVector.Indexed indexed2 = new WrappedVector.Indexed(dArray, 0, nArray);
        double[] dArray3 = MultivariateNormalDistribution.nextMultivariateNormalVariance(ReadableVector.Utils.toArray(indexed2), ReadableMatrix.Utils.toMatrixArray(indexed));
        for (int i = 0; i < nArray.length; ++i) {
            dArray[nArray[i]] = dArray3[i];
        }
        return dArray;
    }
}

