/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.datatype.DataType;
import dr.inference.model.StateSet;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;

public class StronglyLumpableGenerator {
    private final String xmlOutput;

    public StronglyLumpableGenerator(StateSet[] stateSetArray, DataType dataType) {
        this.xmlOutput = this.generateXML(stateSetArray, dataType);
        this.saveToFile("generated_strongly_lumpable_block.xml");
    }

    private String generateXML(StateSet[] stateSetArray, DataType dataType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<stronglyLumpableCtmcRates id=\"lumpableRates\">\n");
        String string = dataType.getDescription();
        stringBuilder.append("\t<generalDataType idref=\"").append(string).append("\"/>\n");
        stringBuilder.append("\t<rates>\n");
        int n = stateSetArray.length * (stateSetArray.length - 1);
        String string2 = new String(new char[n]).replace("\u0000", "1 ").trim();
        stringBuilder.append("\t\t<parameter id=\"lump.across.rates\"  value=\"").append(string2).append("\"/>\n");
        stringBuilder.append("\t</rates>\n");
        for (int i = 0; i < stateSetArray.length; ++i) {
            String string3 = "L" + (i + 1);
            int n2 = stateSetArray[i].states().length;
            int n3 = n2 * (n2 - 1);
            String string4 = new String(new char[n3]).replace("\u0000", "1 ").trim();
            stringBuilder.append("\t<lump id=\"").append(string3).append("\">\n");
            stringBuilder.append("\t\t<stateSet idref=\"").append(stateSetArray[i].getId()).append("\"/>\n");
            if (string4.isEmpty()) {
                stringBuilder.append("\t\t<!-- \n");
                stringBuilder.append("\t\t<rates>\n");
                stringBuilder.append("\t\t\t<parameter id=\"").append(string3).append(".within.rates\" value=\"").append(string4).append("\"/>\n");
                stringBuilder.append("\t\t</rates>\n");
                stringBuilder.append("\t\t -->\n");
            } else {
                stringBuilder.append("\t\t<rates>\n");
                stringBuilder.append("\t\t\t<parameter id=\"").append(string3).append(".within.rates\" value=\"").append(string4).append("\"/>\n");
                stringBuilder.append("\t\t</rates>\n");
            }
            for (int n4 : stateSetArray[i].states()) {
                String string5 = dataType.getCode(n4);
                for (int j = 0; j < stateSetArray.length; ++j) {
                    double d;
                    DecimalFormat decimalFormat;
                    String string6;
                    if (j == i) continue;
                    int n5 = stateSetArray[j].states().length;
                    String string7 = String.join((CharSequence)" ", Collections.nCopies(n5, string6 = (decimalFormat = new DecimalFormat("0.00")).format(d = 1.0 / (double)n5)));
                    if (string7.isEmpty()) {
                        stringBuilder.append("\t\t<!-- \n");
                        stringBuilder.append("\t\t<proportions>\n");
                        stringBuilder.append("\t\t\t<state code=\"").append(string5).append("\"/>\n");
                        stringBuilder.append("\t\t\t<stateSet idref=\"").append(stateSetArray[j].getId()).append("\"/>\n");
                        stringBuilder.append("\t\t\t<parameter id=\"").append(string5).append(".").append(stateSetArray[j].getId()).append(".proportions\" value=\"").append(string7).append("\"/>\n");
                        stringBuilder.append("\t\t</proportions>\n");
                        stringBuilder.append("\t\t -->\n");
                        continue;
                    }
                    stringBuilder.append("\t\t<proportions>\n");
                    stringBuilder.append("\t\t\t<state code=\"").append(string5).append("\"/>\n");
                    stringBuilder.append("\t\t\t<stateSet idref=\"").append(stateSetArray[j].getId()).append("\"/>\n");
                    stringBuilder.append("\t\t\t<parameter id=\"").append(string5).append(".").append(stateSetArray[j].getId()).append(".proportions\" value=\"").append(string7).append("\"/>\n");
                    stringBuilder.append("\t\t</proportions>\n");
                }
            }
            stringBuilder.append("\t</lump>\n");
        }
        stringBuilder.append("</stronglyLumpableCtmcRates>");
        return stringBuilder.toString();
    }

    public String getXmlOutput() {
        return this.xmlOutput;
    }

    private void saveToFile(String string) {
        try (FileWriter fileWriter = new FileWriter(string);){
            fileWriter.write(this.xmlOutput);
            System.out.println("XML file saved as: " + string);
        }
        catch (IOException iOException) {
            System.err.println("Error writing XML to file: " + iOException.getMessage());
        }
    }
}

