/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.NormalStatisticsProvider;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.PriorPreconditioningProvider;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.math.UnivariateFunction;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.math.distributions.NormalDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NormalDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
GaussianProcessRandomGenerator,
GradientProvider,
HessianProvider,
NormalStatisticsProvider,
PriorPreconditioningProvider {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return NormalDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Variable<Double> mean;
    private final Variable<Double> scale;
    private Variable<Double> precision;
    private boolean hasPrecision = false;

    public NormalDistributionModel(Variable<Double> variable, Variable<Double> variable2) {
        super("normalDistributionModel");
        this.mean = variable;
        this.scale = variable2;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public NormalDistributionModel(Parameter parameter, Parameter parameter2, boolean bl) {
        super("normalDistributionModel");
        this.hasPrecision = bl;
        this.mean = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        if (bl) {
            this.precision = parameter2;
            this.scale = null;
        } else {
            this.scale = parameter2;
        }
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public double getStdev() {
        return this.getScale();
    }

    public double getScale() {
        if (this.hasPrecision) {
            return 1.0 / Math.sqrt(this.precision.getValue(0));
        }
        return this.scale.getValue(0);
    }

    public Variable<Double> getMean() {
        return this.mean;
    }

    @Override
    public double getNormalMean(int n) {
        return this.mean.getValue(0);
    }

    @Override
    public double getNormalSD(int n) {
        return this.getStdev();
    }

    public Variable<Double> getPrecision() {
        if (this.hasPrecision) {
            return this.precision;
        }
        return null;
    }

    @Override
    public double pdf(double d) {
        return NormalDistribution.pdf(d, this.mean(), this.getScale());
    }

    @Override
    public double logPdf(double d) {
        return NormalDistribution.logPdf(d, this.mean(), this.getScale());
    }

    @Override
    public double cdf(double d) {
        return NormalDistribution.cdf(d, this.mean(), this.getScale());
    }

    @Override
    public double quantile(double d) {
        return NormalDistribution.quantile(d, this.mean(), this.getScale());
    }

    @Override
    public double mean() {
        return this.mean.getValue(0);
    }

    @Override
    public double variance() {
        if (this.hasPrecision) {
            return 1.0 / this.precision.getValue(0);
        }
        double d = this.scale.getValue(0);
        return d * d;
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Object nextRandom() {
        double d = MathUtils.nextGaussian();
        d *= this.getScale();
        return d += this.mean();
    }

    @Override
    public double logPdf(Object object) {
        double d = (Double)object;
        return this.logPdf(d);
    }

    @Override
    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    public double getStandardDeviation(int n) {
        return this.getStdev();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = NormalDistribution.gradLogPdf(dArray[i], this.mean(), this.getScale());
        }
        return dArray2;
    }

    @Override
    public double[][] getPrecisionMatrix() {
        double d = this.hasPrecision ? this.precision.getValue(0) : this.scale.getValue(0) * this.scale.getValue(0);
        return new double[][]{{d}};
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.mean;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = NormalDistribution.hessianLogPdf(dArray[i], this.mean(), this.getScale());
        }
        return dArray2;
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        double[] dArray = this.getDiagonalHessianLogDensity(object);
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][i] = dArray[i];
        }
        return dArray2;
    }
}

