/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.operators.AbstractAdaptableTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.RandomWalkOperator;
import dr.math.MathUtils;
import dr.util.Transform;

public class RandomWalkNodeHeightOperator
extends AbstractAdaptableTreeOperator {
    private double tunableParameter;
    private final TreeModel tree;

    public RandomWalkNodeHeightOperator(TreeModel treeModel, double d, double d2, AdaptationMode adaptationMode, double d3) {
        super(adaptationMode, d3);
        this.tree = treeModel;
        this.setWeight(d);
        this.tunableParameter = d2;
    }

    @Override
    public double doOperation() {
        NodeRef nodeRef;
        NodeRef nodeRef2 = this.tree.getRoot();
        while ((nodeRef = this.tree.getInternalNode(MathUtils.nextInt(this.tree.getInternalNodeCount()))) == nodeRef2) {
        }
        double d = this.tree.getNodeHeight(this.tree.getParent(nodeRef));
        double d2 = Math.max(this.tree.getNodeHeight(this.tree.getChild(nodeRef, 0)), this.tree.getNodeHeight(this.tree.getChild(nodeRef, 1)));
        double d3 = this.tree.getNodeHeight(nodeRef);
        RandomWalkOperator.BoundaryCondition boundaryCondition = RandomWalkOperator.BoundaryCondition.rejecting;
        return this.doRandomWalk(nodeRef, d3, d, d2, this.tunableParameter, boundaryCondition);
    }

    private double doRandomWalk(NodeRef nodeRef, double d, double d2, double d3, double d4, RandomWalkOperator.BoundaryCondition boundaryCondition) {
        double d5;
        double d6;
        double d7 = (2.0 * MathUtils.nextDouble() - 1.0) * d4;
        if (boundaryCondition == RandomWalkOperator.BoundaryCondition.logit) {
            double d8 = (d - d3) / (d2 - d3);
            double d9 = Transform.LOGIT.inverse(Transform.LOGIT.transform(d8) + d7);
            d6 = d9 * (d2 - d3) + d3;
            d5 = Transform.LOGIT.logJacobian(d8) - Transform.LOGIT.logJacobian(d9);
        } else if (boundaryCondition == RandomWalkOperator.BoundaryCondition.log) {
            double d10 = d - d3;
            double d11 = Transform.LOG.inverse(Transform.LOG.transform(d10) + d7);
            d6 = d11 + d3;
            d5 = Transform.LOG.logJacobian(d10) - Transform.LOG.logJacobian(d11);
        } else {
            d6 = d + d7;
            d5 = 0.0;
            if (boundaryCondition == RandomWalkOperator.BoundaryCondition.reflecting) {
                d6 = RandomWalkNodeHeightOperator.reflectValue(d6, d3, d2);
            } else if (boundaryCondition == RandomWalkOperator.BoundaryCondition.rejecting && (d6 < d3 || d6 > d2)) {
                d5 = Double.NEGATIVE_INFINITY;
            }
        }
        this.tree.setNodeHeight(nodeRef, d6);
        return d5;
    }

    public static double reflectValue(double d, double d2, double d3) {
        double d4 = d;
        if (d3 == d2) {
            d4 = d3;
        } else if (d < d2) {
            if (Double.isInfinite(d3)) {
                d4 = d2 + (d2 - d);
            } else {
                double d5 = (d2 - d) / (d3 - d2);
                double d6 = Math.floor(d5);
                double d7 = (d5 - d6) * (d3 - d2);
                d4 = d6 % 2.0 == 0.0 ? d2 + d7 : d3 - d7;
            }
        } else if (d > d3) {
            if (Double.isInfinite(d2)) {
                d4 = d3 - (d4 - d3);
            } else {
                double d8 = (d - d3) / (d3 - d2);
                double d9 = Math.floor(d8);
                double d10 = (d8 - d9) * (d3 - d2);
                d4 = d9 % 2.0 == 0.0 ? d3 - d10 : d2 + d10;
            }
        }
        return d4;
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.tunableParameter = Math.exp(d);
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.tunableParameter);
    }

    @Override
    public double getRawParameter() {
        return this.tunableParameter;
    }

    @Override
    public String getAdaptableParameterName() {
        return "windowSize";
    }

    @Override
    public String getOperatorName() {
        return "randomWalk(" + this.tree.getId() + " internal nodes)";
    }
}

