/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.regression;

public class RegressionJNIWrapper {
    public static final String LIBRARY_NAME = "bsccs_jni";
    public static final String LIBRARY_PATH_LABEL = "bsccs.library.path";
    public static final String LIBRARY_PLATFORM_NAME = RegressionJNIWrapper.getPlatformSpecificLibraryName();
    public static final int NO_PRIOR = 0;
    public static final int LAPLACE_PRIOR = 1;
    public static final int NORMAL_PRIOR = 2;
    private static RegressionJNIWrapper INSTANCE = null;

    private RegressionJNIWrapper() {
    }

    public native int loadData(String var1);

    public native double getLogLikelihood(int var1);

    public native void getLogLikelihoodGradient(int var1, double[] var2);

    public native double getLogPrior(int var1);

    public native double getBeta(int var1, int var2);

    public native int getBetaSize(int var1);

    public native double getHessian(int var1, int var2, int var3);

    public native void setBeta(int var1, int var2, double var3);

    public native void setBeta(int var1, double[] var2);

    public native double getHyperprior(int var1);

    public native void setHyperprior(int var1, double var2);

    public native void findMode(int var1);

    public native int getUpdateCount(int var1);

    public native int getLikelihoodCount(int var1);

    public native void setPriorType(int var1, int var2);

    public native void makeDirty(int var1);

    private static String getPlatformSpecificLibraryName() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.startsWith("windows")) {
            if (string2.equals("i386")) {
                return "bsccs_jni32";
            }
            if (string2.startsWith("amd64") || string2.startsWith("x86_64")) {
                return "bsccs_jni64";
            }
        }
        return LIBRARY_NAME;
    }

    public static RegressionJNIWrapper loadLibrary() throws UnsatisfiedLinkError {
        if (INSTANCE == null) {
            System.err.println("Trying to load BSCCS library...");
            String string = "";
            if (System.getProperty(LIBRARY_PATH_LABEL) != null && (string = System.getProperty(LIBRARY_PATH_LABEL)).length() > 0 && !string.endsWith("/")) {
                string = string + "/";
            }
            System.loadLibrary(string + LIBRARY_PLATFORM_NAME);
            INSTANCE = new RegressionJNIWrapper();
            System.err.println("BSCCS library loaded.");
        }
        return INSTANCE;
    }
}

