/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;

public class PartitionedTreeTraitProvider
implements TreeTraitProvider {
    private final TreeTrait[] originalTraits;
    private final TreeTrait[] partitionedTraits;
    private final int nPartitions;
    private final int[] partitionDimensions;
    private final int totalDim;
    private final int[] nodeOffsets;

    public PartitionedTreeTraitProvider(final TreeTrait[] treeTraitArray, int[] nArray) {
        int n;
        this.originalTraits = treeTraitArray;
        this.partitionDimensions = nArray;
        this.nPartitions = nArray.length;
        this.nodeOffsets = new int[this.nPartitions];
        int n2 = 0;
        for (n = 0; n < this.nPartitions; ++n) {
            this.nodeOffsets[n] = n2;
            n2 += nArray[n];
        }
        this.totalDim = n2;
        n = treeTraitArray.length;
        this.partitionedTraits = new TreeTrait[n * this.nPartitions];
        for (int i = 0; i < n; ++i) {
            final int n3 = i;
            for (int j = 0; j < this.nPartitions; ++j) {
                final int n4 = j;
                TreeTrait.DA dA = new TreeTrait.DA(){

                    @Override
                    public String getTraitName() {
                        return treeTraitArray[n3].getTraitName() + "." + n4;
                    }

                    @Override
                    public TreeTrait.Intent getIntent() {
                        return treeTraitArray[n3].getIntent();
                    }

                    @Override
                    public double[] getTrait(Tree tree, NodeRef nodeRef) {
                        double[] dArray = (double[])treeTraitArray[n3].getTrait(tree, nodeRef);
                        return PartitionedTreeTraitProvider.this.partitionValues(dArray, n4);
                    }
                };
                this.partitionedTraits[i * this.nPartitions + j] = dA;
            }
        }
    }

    private double[] partitionValues(double[] dArray, int n) {
        int n2 = dArray.length / this.totalDim;
        int n3 = this.partitionDimensions[n];
        if (dArray.length % this.totalDim != 0) {
            throw new RuntimeException("The trait dimension must be a factor of the tree trait length.");
        }
        double[] dArray2 = new double[n2 * this.partitionDimensions[n]];
        int n4 = this.nodeOffsets[n];
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray, n4, dArray2, n5, n3);
            n4 += this.totalDim;
            n5 += n3;
        }
        return dArray2;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.partitionedTraits;
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        throw new RuntimeException("Error: not implemented.");
    }
}

