/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeStatistic;
import dr.inference.model.Parameter;
import java.util.Arrays;

public class NodeHeightsStatistic
extends TreeStatistic {
    private Tree tree = null;
    private Parameter groupSizes = null;
    private double[] heights = null;

    public NodeHeightsStatistic(String string, Tree tree) {
        this(string, tree, null);
    }

    public NodeHeightsStatistic(String string, Tree tree, Parameter parameter) {
        super(string);
        this.tree = tree;
        this.groupSizes = parameter;
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        if (this.groupSizes != null) {
            return this.groupSizes.getDimension();
        }
        return this.tree.getInternalNodeCount();
    }

    @Override
    public double getStatisticValue(int n) {
        if (n == 0) {
            this.calculateHeights();
        }
        return this.heights[n];
    }

    private void calculateHeights() {
        this.heights = new double[this.tree.getInternalNodeCount()];
        for (int i = 0; i < this.heights.length; ++i) {
            this.heights[i] = this.tree.getNodeHeight(this.tree.getInternalNode(i));
        }
        Arrays.sort(this.heights);
        if (this.groupSizes != null) {
            double[] dArray = this.heights;
            this.heights = new double[this.groupSizes.getDimension()];
            int n = 0;
            for (int i = 0; i < this.groupSizes.getDimension(); ++i) {
                n = (int)((double)n + (Double)this.groupSizes.getValue(i));
                this.heights[i] = dArray[n - 1];
            }
        }
    }
}

