/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree;

import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.Iterator;

public class BigFastTreeModel
extends TreeModel {
    public static final String BIG_FAST_TREE_MODEL = "bigFastTreeModel";
    private int root = -1;
    private int storedRoot;
    private int[] edges = null;
    private int[] storedEdges = null;
    private double[] heights = null;
    private double[] storedHeights = null;
    private final NodeRef[] nodes;
    private final int nodeCount;
    private final int externalNodeCount;
    private final int internalNodeCount;

    public BigFastTreeModel(Tree tree) {
        this(BIG_FAST_TREE_MODEL, tree, false, false);
    }

    public BigFastTreeModel(String string, Tree tree) {
        this(string, tree, false, false);
    }

    public BigFastTreeModel(String string, Tree tree, boolean bl, boolean bl2) {
        super(string, !bl2);
        this.setId(string);
        FlexibleTree flexibleTree = new FlexibleTree(tree);
        flexibleTree.resolveTree();
        if (!bl) {
            MutableTree.Utils.correctHeightsForTips(flexibleTree);
        }
        this.internalNodeCount = flexibleTree.getInternalNodeCount();
        this.externalNodeCount = flexibleTree.getExternalNodeCount();
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new NodeRef[this.nodeCount];
        this.edges = new int[this.nodeCount * 3];
        this.storedEdges = new int[this.nodeCount * 3];
        this.heights = new double[this.nodeCount];
        this.storedHeights = new double[this.nodeCount];
        boolean bl3 = false;
        NodeRef nodeRef = flexibleTree.getRoot();
        do {
            nodeRef = TreeUtils.postorderSuccessor(flexibleTree, nodeRef);
            int n = nodeRef.getNumber();
            if (flexibleTree.isExternal(nodeRef)) {
                this.nodes[n] = new Node(n, flexibleTree.getNodeTaxon(nodeRef));
                this.edges[n * 3] = flexibleTree.getParent(nodeRef).getNumber();
                this.edges[n * 3 + 1] = -1;
                this.edges[n * 3 + 2] = -1;
            } else {
                if (flexibleTree.isRoot(nodeRef)) {
                    this.root = n;
                    bl3 = true;
                    this.edges[n * 3] = -1;
                } else {
                    this.edges[n * 3] = flexibleTree.getParent(nodeRef).getNumber();
                }
                this.nodes[n] = new Node(n);
                this.edges[n * 3 + 1] = flexibleTree.getChild(nodeRef, 0).getNumber();
                this.edges[n * 3 + 2] = flexibleTree.getChild(nodeRef, 1).getNumber();
            }
            this.heights[n] = flexibleTree.getNodeHeight(nodeRef);
        } while (!bl3);
    }

    protected void copyTopology(Tree tree) {
        FlexibleTree flexibleTree = new FlexibleTree(tree);
        flexibleTree.resolveTree();
        boolean bl = false;
        NodeRef nodeRef = flexibleTree.getRoot();
        do {
            nodeRef = TreeUtils.postorderSuccessor(flexibleTree, nodeRef);
            int n = nodeRef.getNumber();
            if (flexibleTree.isExternal(nodeRef)) {
                this.nodes[n] = new Node(n, flexibleTree.getNodeTaxon(nodeRef));
                this.edges[n * 3] = flexibleTree.getParent(nodeRef).getNumber();
                this.edges[n * 3 + 1] = -1;
                this.edges[n * 3 + 2] = -1;
            } else {
                if (flexibleTree.isRoot(nodeRef)) {
                    this.root = n;
                    bl = true;
                    this.edges[n * 3] = -1;
                } else {
                    this.edges[n * 3] = flexibleTree.getParent(nodeRef).getNumber();
                }
                this.nodes[n] = new Node(n);
                this.edges[n * 3 + 1] = flexibleTree.getChild(nodeRef, 0).getNumber();
                this.edges[n * 3 + 2] = flexibleTree.getChild(nodeRef, 1).getNumber();
            }
            this.heights[n] = flexibleTree.getNodeHeight(nodeRef);
        } while (!bl);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public boolean inTreeEdit() {
        return this.inEdit;
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return this.heights[nodeRef.getNumber()];
    }

    public double getNodeHeightUpper(NodeRef nodeRef) {
        if (this.isRoot(nodeRef)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getNodeHeight(this.getParent(nodeRef));
    }

    public double getNodeHeightLower(NodeRef nodeRef) {
        if (this.isExternal(nodeRef)) {
            return 0.0;
        }
        return Math.max(this.getNodeHeight(this.getChild(nodeRef, 0)), this.getNodeHeight(this.getChild(nodeRef, 1)));
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        return 1.0;
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        throw new UnsupportedOperationException("getNodeAttribute not available in BigFastTreeModel");
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        throw new UnsupportedOperationException("getNodeAttributeNames not available in BigFastTreeModel");
    }

    @Override
    public double[] getMultivariateNodeTrait(NodeRef nodeRef, String string) {
        throw new UnsupportedOperationException("getMultivariateNodeTrait not available in BigFastTreeModel");
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((Node)nodeRef).taxon;
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return nodeRef.getNumber() < this.externalNodeCount;
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return nodeRef.getNumber() == this.root;
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        if (this.isExternal(nodeRef)) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.edges[nodeRef.getNumber() * 3 + i + 1] <= -1) continue;
            ++n;
        }
        return n;
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return this.nodes[this.getChild(nodeRef.getNumber(), n)];
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        if (this.isRoot(nodeRef)) {
            return null;
        }
        int n = this.getParent(nodeRef.getNumber());
        return n == -1 ? null : this.nodes[n];
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.nodes[n];
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.nodes[n + this.externalNodeCount];
    }

    @Override
    public NodeRef getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public NodeRef[] getNodes() {
        return this.nodes;
    }

    @Override
    public int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    @Override
    public NodeRef getRoot() {
        return this.nodes[this.root];
    }

    @Override
    public boolean isTipDateSampled() {
        return false;
    }

    private int getParent(int n) {
        return this.edges[n * 3];
    }

    private int getChild(int n, int n2) {
        assert (n2 == 0 || n2 == 1);
        return this.edges[n * 3 + n2 + 1];
    }

    private void setParent(int n, int n2) {
        this.edges[n * 3] = n2;
    }

    private void setChild(int n, int n2, int n3) {
        assert (n2 == 0 || n2 == 1);
        this.edges[n * 3 + n2 + 1] = n3;
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        this.root = nodeRef.getNumber();
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        int n = nodeRef.getNumber();
        int n2 = nodeRef2.getNumber();
        if (this.getChild(n, 0) == -1) {
            this.setChild(n, 0, n2);
        } else if (this.getChild(n, 1) == -1) {
            this.setChild(n, 1, n2);
        } else {
            throw new IllegalArgumentException("Node already has two children");
        }
        this.setParent(n2, n);
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef, false));
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef2, false));
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        int n = nodeRef.getNumber();
        int n2 = nodeRef2.getNumber();
        if (this.getChild(n, 0) == n2) {
            this.setChild(n, 0, -1);
            if (this.getChildCount(nodeRef) == 1) {
                this.setChild(n, 0, this.getChild(n, 1));
                this.setChild(n, 1, -1);
            }
        } else if (this.getChild(n, 1) == n2) {
            this.setChild(n, 1, -1);
        } else {
            throw new IllegalArgumentException("Child not in node");
        }
        this.setParent(n2, -1);
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef, false));
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef2, false));
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean isTreeValid() {
        for (NodeRef nodeRef : this.nodes) {
            double d = this.getNodeHeight(nodeRef);
            if (!(d > this.getNodeHeightUpper(nodeRef)) && !(d < this.getNodeHeightLower(nodeRef))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        this.heights[nodeRef.getNumber()] = d;
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef, true));
    }

    @Override
    public void setNodeHeightQuietly(NodeRef nodeRef, double d) {
        this.heights[nodeRef.getNumber()] = d;
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have node rates set");
    }

    public void setNodeTrait(NodeRef nodeRef, String string, double d) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have traits set");
    }

    @Override
    public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have traits set");
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have branch lengths set");
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        throw new UnsupportedOperationException("BigFastTreeModel does not use NodeAttributes");
    }

    @Override
    public void adoptTreeStructure(int[] nArray, double[] dArray, int[] nArray2, String[] stringArray) {
        int n;
        int n2;
        int[] nArray3 = this.createNodeMap(stringArray);
        if (this.nodeCount != nArray.length) {
            throw new RuntimeException("Incorrect number of edges provided: " + nArray.length + " versus " + this.nodeCount + " nodes.");
        }
        for (n2 = this.externalNodeCount; n2 < this.nodeCount; ++n2) {
            n = this.getChildCount(this.nodes[n2]);
            for (int i = 0; i < n; ++i) {
                this.removeChild(this.nodes[n2], this.getChild(this.nodes[n2], 0));
            }
        }
        for (n2 = 0; n2 < this.getExternalNodeCount(); ++n2) {
            this.setNodeHeight(this.getExternalNode(nArray3[n2]), dArray[n2]);
        }
        for (n2 = 0; n2 < this.getExternalNodeCount() - 1; ++n2) {
            this.setNodeHeight(this.getInternalNode(n2), dArray[this.getExternalNodeCount() + n2]);
        }
        n2 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != -1) {
                if (n < this.getExternalNodeCount()) {
                    this.addChild(this.getNode(nArray[n]), this.getExternalNode(nArray3[n]));
                    System.out.println("external: " + nArray[n] + " > " + nArray3[n]);
                    continue;
                }
                this.addChild(this.getNode(nArray[n]), this.getNode(n));
                System.out.println("internal: " + nArray[n] + " > " + n);
                continue;
            }
            n2 = n;
        }
        for (n = 0; n < nArray.length; ++n) {
            NodeRef nodeRef;
            NodeRef nodeRef2;
            NodeRef nodeRef3;
            if (nArray[n] == -1) continue;
            if (n < this.externalNodeCount) {
                if (nArray2[n] != 0 || this.getChild(this.nodes[nArray[n]], 0) == this.nodes[nArray3[n]]) continue;
                nodeRef3 = this.getNode(nArray[n]);
                nodeRef2 = this.getChild(nodeRef3, 0);
                nodeRef = this.getChild(nodeRef3, 1);
                this.removeChild(nodeRef3, nodeRef2);
                this.removeChild(nodeRef3, nodeRef);
                this.addChild(nodeRef3, nodeRef);
                this.addChild(nodeRef3, nodeRef2);
                continue;
            }
            if (nArray2[n] != 0 || this.getChild(this.nodes[nArray[n]], 0) == this.nodes[n]) continue;
            nodeRef3 = this.getNode(nArray[n]);
            nodeRef2 = this.getChild(nodeRef3, 0);
            nodeRef = this.getChild(nodeRef3, 1);
            this.removeChild(nodeRef3, nodeRef2);
            this.removeChild(nodeRef3, nodeRef);
            this.addChild(nodeRef3, nodeRef);
            this.addChild(nodeRef3, nodeRef2);
        }
        this.setRoot(this.nodes[n2]);
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.edges, 0, this.storedEdges, 0, this.edges.length);
        System.arraycopy(this.heights, 0, this.storedHeights, 0, this.heights.length);
        this.storedRoot = this.root;
    }

    @Override
    protected void restoreState() {
        int[] nArray = this.storedEdges;
        this.storedEdges = this.edges;
        this.edges = nArray;
        double[] dArray = this.storedHeights;
        this.storedHeights = this.heights;
        this.heights = dArray;
        this.root = this.storedRoot;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Taxon getTaxon(int n) {
        return ((Node)this.getExternalNode((int)n)).taxon;
    }

    private class Node
    implements NodeRef {
        final Taxon taxon;
        final int number;

        private Node(int n) {
            this(n, (Taxon)null);
        }

        private Node(int n, Taxon taxon) {
            this.number = n;
            this.taxon = taxon;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public void setNumber(int n) {
            throw new UnsupportedOperationException("Node is immutable");
        }

        public Taxon getTaxon() {
            return this.taxon;
        }
    }
}

